/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.theme;

import com.google.gson.JsonObject;
import greymerk.roguelike.theme.BlockSet;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.theme.ThemeBase;
import greymerk.roguelike.theme.ThemeBling;
import greymerk.roguelike.theme.ThemeBrick;
import greymerk.roguelike.theme.ThemeCave;
import greymerk.roguelike.theme.ThemeChecker;
import greymerk.roguelike.theme.ThemeCrypt;
import greymerk.roguelike.theme.ThemeDarkHall;
import greymerk.roguelike.theme.ThemeDarkOak;
import greymerk.roguelike.theme.ThemeEnder;
import greymerk.roguelike.theme.ThemeEniIce;
import greymerk.roguelike.theme.ThemeEniQuartz;
import greymerk.roguelike.theme.ThemeEniko;
import greymerk.roguelike.theme.ThemeEniko2;
import greymerk.roguelike.theme.ThemeEtho;
import greymerk.roguelike.theme.ThemeEthoTower;
import greymerk.roguelike.theme.ThemeGrey;
import greymerk.roguelike.theme.ThemeHouse;
import greymerk.roguelike.theme.ThemeIce;
import greymerk.roguelike.theme.ThemeJungle;
import greymerk.roguelike.theme.ThemeMineShaft;
import greymerk.roguelike.theme.ThemeMossy;
import greymerk.roguelike.theme.ThemeMuddy;
import greymerk.roguelike.theme.ThemeNether;
import greymerk.roguelike.theme.ThemeOak;
import greymerk.roguelike.theme.ThemePurpur;
import greymerk.roguelike.theme.ThemePyramid;
import greymerk.roguelike.theme.ThemeQuartz;
import greymerk.roguelike.theme.ThemeRainbow;
import greymerk.roguelike.theme.ThemeSandstone;
import greymerk.roguelike.theme.ThemeSandstoneRed;
import greymerk.roguelike.theme.ThemeSewer;
import greymerk.roguelike.theme.ThemeSnow;
import greymerk.roguelike.theme.ThemeSpruce;
import greymerk.roguelike.theme.ThemeTemple;
import greymerk.roguelike.theme.ThemeTower;

public enum Theme {
    OAK,
    SPRUCE,
    CRYPT,
    MOSSY,
    MUDDY,
    NETHER,
    SANDSTONE,
    QUARTZ,
    BLING,
    CHECKER,
    RAINBOW,
    SNOW,
    JUNGLE,
    BRICK,
    DARKOAK,
    ICE,
    ENIKO,
    ENIKO2,
    ENIQUARTZ,
    ENIICE,
    TOWER,
    ETHO,
    CAVE,
    SEWER,
    ENDER,
    MINESHAFT,
    ETHOTOWER,
    PYRAMID,
    DARKHALL,
    TEMPLE,
    SANDSTONERED,
    HOUSE,
    GREY,
    PURPUR;


    public static ITheme getTheme(Theme type) {
        ThemeBase theme;
        switch (type) {
            case OAK: {
                theme = new ThemeOak();
                break;
            }
            case SPRUCE: {
                theme = new ThemeSpruce();
                break;
            }
            case CRYPT: {
                theme = new ThemeCrypt();
                break;
            }
            case MOSSY: {
                theme = new ThemeMossy();
                break;
            }
            case MUDDY: {
                theme = new ThemeMuddy();
                break;
            }
            case NETHER: {
                theme = new ThemeNether();
                break;
            }
            case SANDSTONE: {
                theme = new ThemeSandstone();
                break;
            }
            case QUARTZ: {
                theme = new ThemeQuartz();
                break;
            }
            case BLING: {
                theme = new ThemeBling();
                break;
            }
            case CHECKER: {
                theme = new ThemeChecker();
                break;
            }
            case RAINBOW: {
                theme = new ThemeRainbow();
                break;
            }
            case SNOW: {
                theme = new ThemeSnow();
                break;
            }
            case JUNGLE: {
                theme = new ThemeJungle();
                break;
            }
            case BRICK: {
                theme = new ThemeBrick();
                break;
            }
            case DARKOAK: {
                theme = new ThemeDarkOak();
                break;
            }
            case ICE: {
                theme = new ThemeIce();
                break;
            }
            case ENIKO: {
                theme = new ThemeEniko();
                break;
            }
            case ENIKO2: {
                theme = new ThemeEniko2();
                break;
            }
            case ENIQUARTZ: {
                theme = new ThemeEniQuartz();
                break;
            }
            case ENIICE: {
                theme = new ThemeEniIce();
                break;
            }
            case TOWER: {
                theme = new ThemeTower();
                break;
            }
            case ETHO: {
                theme = new ThemeEtho();
                break;
            }
            case CAVE: {
                theme = new ThemeCave();
                break;
            }
            case SEWER: {
                theme = new ThemeSewer();
                break;
            }
            case ENDER: {
                theme = new ThemeEnder();
                break;
            }
            case MINESHAFT: {
                theme = new ThemeMineShaft();
                break;
            }
            case ETHOTOWER: {
                theme = new ThemeEthoTower();
                break;
            }
            case PYRAMID: {
                theme = new ThemePyramid();
                break;
            }
            case DARKHALL: {
                theme = new ThemeDarkHall();
                break;
            }
            case TEMPLE: {
                theme = new ThemeTemple();
                break;
            }
            case SANDSTONERED: {
                theme = new ThemeSandstoneRed();
                break;
            }
            case HOUSE: {
                theme = new ThemeHouse();
                break;
            }
            case GREY: {
                theme = new ThemeGrey();
                break;
            }
            case PURPUR: {
                theme = new ThemePurpur();
                break;
            }
            default: {
                return null;
            }
        }
        return theme;
    }

    public static ITheme create(JsonObject json) {
        JsonObject data;
        BlockSet primary = null;
        BlockSet secondary = null;
        if (json.has("primary")) {
            data = json.get("primary").getAsJsonObject();
            primary = new BlockSet(data);
        }
        if (json.has("secondary")) {
            data = json.get("secondary").getAsJsonObject();
            secondary = new BlockSet(data);
        }
        if (json.has("base")) {
            ITheme theme = Theme.getTheme(Theme.valueOf(json.get("base").getAsString()));
            return new ThemeBase((ThemeBase)theme, primary, secondary);
        }
        ITheme theme = Theme.getTheme(OAK);
        return new ThemeBase((ThemeBase)theme, primary, secondary);
    }
}

