/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.client.lore;

import com.gtnewhorizons.gtnhintergalactic.GTNHIntergalactic;
import com.gtnewhorizons.gtnhintergalactic.client.lore.LoreHolder;
import gregtech.api.objects.XSTR;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandom;
import org.apache.commons.lang3.StringUtils;

public class LoreHandler
implements IResourceManagerReloadListener {
    private static final Map<Field, String> LORE_HOLDERS = new HashMap<Field, String>();

    public void func_110549_a(IResourceManager p_110549_1_) {
        LoreHandler.updateLoreHolders();
    }

    public static void registerLoreHolder(Class<?> clazz) {
        try {
            for (Field field : clazz.getDeclaredFields()) {
                LoreHolder loreHolder;
                if (!field.getType().isAssignableFrom(String.class) || !Modifier.isStatic(field.getModifiers()) || (loreHolder = field.getDeclaredAnnotation(LoreHolder.class)) == null) continue;
                field.setAccessible(true);
                LORE_HOLDERS.put(field, loreHolder.value());
            }
        }
        catch (Exception e) {
            GTNHIntergalactic.LOG.error("An exception occured while looking for @LoreHolder annotations in " + clazz.toString(), (Throwable)e);
        }
    }

    private static void updateLoreHolders() {
        LORE_HOLDERS.forEach((field, keyPrefix) -> {
            try {
                field.set(null, LoreHandler.getRandomLine(keyPrefix));
            }
            catch (Exception e) {
                GTNHIntergalactic.LOG.warn("Unable to update LoreHolder in " + field.getDeclaringClass().toString() + " (Field: " + field.getName() + ")", (Throwable)e);
            }
        });
    }

    private static String getRandomLine(String keyPrefix) {
        List<WeightedRandom.Item> lines = LoreHandler.getAllLines(keyPrefix);
        if (lines.size() == 0) {
            return null;
        }
        try {
            return ((WeightedText)WeightedRandom.func_76271_a((Random)XSTR.XSTR_INSTANCE, lines)).text;
        }
        catch (IllegalArgumentException e) {
            GTNHIntergalactic.LOG.warn("The total weight of all lines for \"" + keyPrefix + "\" exceeds " + Integer.MAX_VALUE, (Throwable)e);
        }
        catch (Exception e) {
            GTNHIntergalactic.LOG.error("An unexpected Exception occured while choosing a random lore for \"" + keyPrefix + '\"', (Throwable)e);
        }
        return null;
    }

    private static List<WeightedRandom.Item> getAllLines(String keyPrefix) {
        String localizedLine;
        String unlocalizedLine;
        ArrayList<WeightedRandom.Item> allLines = new ArrayList<WeightedRandom.Item>();
        int i = 0;
        while (!(unlocalizedLine = keyPrefix + i).equals(localizedLine = StatCollector.func_74838_a((String)unlocalizedLine))) {
            if (!StringUtils.isBlank((CharSequence)localizedLine)) {
                allLines.add(new WeightedText(localizedLine));
            }
            ++i;
        }
        return allLines;
    }

    private static class WeightedText
    extends WeightedRandom.Item {
        private String text;

        private WeightedText(String weightedText) {
            super(0);
            this.extractWeightAndText(weightedText);
        }

        private void extractWeightAndText(String weightedText) {
            int endOfWeight = weightedText.indexOf(58);
            if (endOfWeight < 1) {
                this.field_76292_a = 1;
                this.text = weightedText;
                return;
            }
            if (weightedText.charAt(endOfWeight - 1) == '\\') {
                this.field_76292_a = 1;
                this.text = weightedText.substring(0, endOfWeight - 1) + weightedText.substring(endOfWeight);
                return;
            }
            String weightString = weightedText.substring(0, endOfWeight);
            try {
                int weight = Integer.parseInt(weightString);
                if (weight < 0) {
                    GTNHIntergalactic.LOG.warn("\"{}\" has a negative weight ({}). This is not allowed, a weight of 1 will be used instead.", new Object[]{weightedText, weight});
                    this.field_76292_a = 1;
                } else {
                    this.field_76292_a = weight;
                }
                this.text = weightedText.substring(endOfWeight + 1);
                return;
            }
            catch (NumberFormatException e) {
                GTNHIntergalactic.LOG.warn("Could not parse \"" + weightString + "\" as Integer. If it is not supposed to be a weight, escape the ':' delimiter using '\\'.", (Throwable)e);
            }
            catch (Exception e) {
                GTNHIntergalactic.LOG.error("An unexpected Exception occured while extracting weight and text from lore \"" + weightedText + '\"', (Throwable)e);
            }
            this.field_76292_a = 1;
            this.text = weightedText;
        }
    }
}

