/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.integration.table.gui.component.area;

import elan.tweaks.common.gui.component.BackgroundUIComponent;
import elan.tweaks.common.gui.component.TickingUIComponent;
import elan.tweaks.common.gui.component.UIContext;
import elan.tweaks.common.gui.dto.Rgba;
import elan.tweaks.common.gui.dto.VectorXY;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.ResearchProcessPort;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.component.area.Runes;
import elan.tweaks.thaumcraft.research.frontend.integration.table.gui.textures.ParchmentTexture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/ParchmentUIComponent;", "Lelan/tweaks/common/gui/component/BackgroundUIComponent;", "Lelan/tweaks/common/gui/component/TickingUIComponent;", "research", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;", "runes", "Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/Runes;", "uiOrigin", "Lelan/tweaks/common/gui/dto/VectorXY;", "(Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/ResearchProcessPort;Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/area/Runes;Lelan/tweaks/common/gui/dto/VectorXY;)V", "drawParchment", "", "context", "Lelan/tweaks/common/gui/component/UIContext;", "drawRunes", "onDrawBackground", "uiMousePosition", "partialTicks", "", "onTick", "ThaumcraftResearchTweaks"})
public final class ParchmentUIComponent
implements BackgroundUIComponent,
TickingUIComponent {
    @NotNull
    private final ResearchProcessPort research;
    @NotNull
    private final Runes runes;
    @NotNull
    private final VectorXY uiOrigin;

    public ParchmentUIComponent(@NotNull ResearchProcessPort research, @NotNull Runes runes, @NotNull VectorXY uiOrigin) {
        Intrinsics.checkNotNullParameter((Object)research, (String)"research");
        Intrinsics.checkNotNullParameter((Object)runes, (String)"runes");
        Intrinsics.checkNotNullParameter((Object)uiOrigin, (String)"uiOrigin");
        this.research = research;
        this.runes = runes;
        this.uiOrigin = uiOrigin;
    }

    @Override
    public void onDrawBackground(@NotNull VectorXY uiMousePosition, float partialTicks, @NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)uiMousePosition, (String)"uiMousePosition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.research.missingNotes()) {
            return;
        }
        this.drawParchment(context);
        this.drawRunes(context);
    }

    private final void drawParchment(UIContext context) {
        UIContext.DefaultImpls.drawBlending$default(context, ParchmentTexture.INSTANCE, this.uiOrigin, null, 4, null);
    }

    private final void drawRunes(UIContext context) {
        this.runes.forEach((Function1<? super Runes.Rune, Unit>)((Function1)new Function1<Runes.Rune, Unit>(context){
            final /* synthetic */ UIContext $context;
            {
                this.$context = $context;
                super(1);
            }

            public final void invoke(@NotNull Runes.Rune rune) {
                Intrinsics.checkNotNullParameter((Object)rune, (String)"rune");
                Rgba colorMask = new Rgba(0.0f, 0.0f, 0.0f, rune.getAlpha());
                this.$context.drawBlending(rune.getTexture(), rune.getUiOrigin(), colorMask);
            }
        }));
    }

    @Override
    public void onTick(float partialTicks, @NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.research.missingNotes()) {
            this.runes.clear();
        }
        this.runes.update(partialTicks, context.getRandom());
    }
}

