/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.AutoValue_Lines;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.AutoValue_Lines_Segment;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.Draw;
import com.github.dcysteine.neicustomdiagram.api.draw.Drawable;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.toprettystring.ToPrettyString;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

@AutoValue
public abstract class Lines
implements Drawable {
    public abstract int colour();

    public abstract ImmutableList<Segment> segments();

    public abstract ImmutableList<Segment> arrows();

    @Override
    public Dimension maxDimension() {
        int maxX = -1;
        int maxY = -1;
        for (Segment segment : Iterables.concat(this.segments(), this.arrows())) {
            maxX = Math.max(maxX, segment.a().x());
            maxX = Math.max(maxX, segment.b().x());
            maxY = Math.max(maxY, segment.a().y());
            maxY = Math.max(maxY, segment.b().y());
        }
        return Dimension.create(maxX + 1, maxY + 1);
    }

    @Override
    public void draw(DiagramState diagramState) {
        this.segments().forEach(segment -> segment.drawSegment(this.colour()));
        this.arrows().forEach(segment -> segment.drawArrow(this.colour()));
    }

    @ToPrettyString
    public abstract String toPrettyString();

    public static Builder builder(Point pos) {
        return new Builder(pos);
    }

    public static final class Builder {
        private int colour = -16777216;
        private Point currentPosition;
        private final ImmutableList.Builder<Segment> segmentsBuilder;
        private final ImmutableList.Builder<Segment> arrowsBuilder;

        public Builder(Point pos) {
            this.currentPosition = pos;
            this.segmentsBuilder = ImmutableList.builder();
            this.arrowsBuilder = ImmutableList.builder();
        }

        public Builder setColour(int colour) {
            this.colour = colour;
            return this;
        }

        public Builder move(Point pos) {
            this.currentPosition = pos;
            return this;
        }

        public Builder addSegment(Point pos) {
            this.segmentsBuilder.add((Object)Segment.create(this.currentPosition, pos));
            this.currentPosition = pos;
            return this;
        }

        public Builder addSegment(Segment segment) {
            this.segmentsBuilder.add((Object)segment);
            return this;
        }

        public Builder addArrow(Point pos) {
            this.arrowsBuilder.add((Object)Segment.create(this.currentPosition, pos));
            this.currentPosition = pos;
            return this;
        }

        public Builder addReverseArrow(Point pos) {
            this.arrowsBuilder.add((Object)Segment.create(pos, this.currentPosition));
            this.currentPosition = pos;
            return this;
        }

        public Builder addDoubleArrow(Point pos) {
            this.arrowsBuilder.add((Object)Segment.create(this.currentPosition, pos));
            this.arrowsBuilder.add((Object)Segment.create(pos, this.currentPosition));
            this.currentPosition = pos;
            return this;
        }

        public Builder addArrow(Segment segment) {
            this.arrowsBuilder.add((Object)segment);
            return this;
        }

        public Lines build() {
            return new AutoValue_Lines(this.colour, (ImmutableList<Segment>)this.segmentsBuilder.build(), (ImmutableList<Segment>)this.arrowsBuilder.build());
        }
    }

    @AutoValue
    public static abstract class Segment {
        public static Segment create(Point a, Point b) {
            Preconditions.checkArgument((boolean)a.isOrthogonal(b), (String)"Points aren't orthogonal: [%s] [%s]", (Object[])new Object[]{a, b});
            return new AutoValue_Lines_Segment(a, b);
        }

        public abstract Point a();

        public abstract Point b();

        public void drawSegment(int colour) {
            Draw.drawLine(this.a(), this.b(), colour);
        }

        public void drawArrow(int colour) {
            this.drawSegment(colour);
            Draw.drawArrowhead(this.a(), this.b(), colour);
        }
    }
}

