/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class RomanNumerals {
    private static final TreeMap<Integer, String> map = new TreeMap();
    private static final Map<Integer, String> cache = new HashMap<Integer, String>();

    public static String toRoman(int number) {
        return cache.computeIfAbsent(number, RomanNumerals::toRomanUncached);
    }

    public static String toRomanLimited(int number, int limit) {
        if (number > limit) {
            return String.valueOf(number);
        }
        return RomanNumerals.toRoman(number);
    }

    private static String toRomanUncached(int number) {
        if (number == 0) {
            return "0";
        }
        if (number < 0) {
            return "-" + RomanNumerals.toRomanUncached(Math.abs(number));
        }
        int floor = map.floorKey(number);
        if (number == floor) {
            return map.get(number);
        }
        return map.get(floor) + RomanNumerals.toRomanUncached(number - floor);
    }

    static {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    }
}

