/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EnergyBlast
extends EnergyItems {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIconTier2;
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIconTier3;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int tier;
    private int damage;

    public EnergyBlast(int tier) {
        this.func_77625_d(1);
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.func_77655_b("energyBlaster");
        this.func_77664_n();
        this.func_77656_e(250);
        this.tier = tier;
        switch (this.tier) {
            case 1: {
                this.setEnergyUsed(AlchemicalWizardry.energyBlastLPPerShot);
                this.damage = AlchemicalWizardry.energyBlastDamage;
                break;
            }
            case 2: {
                this.setEnergyUsed(AlchemicalWizardry.energyBlastSecondTierLPPerShot);
                this.damage = AlchemicalWizardry.energyBlastSecondTierDamage;
                break;
            }
            case 3: {
                this.setEnergyUsed(AlchemicalWizardry.energyBlastThirdTierLPPerShot);
                this.damage = AlchemicalWizardry.energyBlastThirdTierDamage;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBlaster_activated");
        this.activeIcon = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBlaster_activated");
        this.activeIconTier2 = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBlaster2_activated");
        this.activeIconTier3 = iconRegister.func_94245_a("AlchemicalWizardry:EnergyBlaster3_activated");
        this.passiveIcon = iconRegister.func_94245_a("AlchemicalWizardry:SheathedItem");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((tag = stack.func_77978_p()).func_74767_n("isActive")) {
            switch (this.tier) {
                case 1: {
                    return this.activeIcon;
                }
                case 2: {
                    return this.activeIconTier2;
                }
                case 3: {
                    return this.activeIconTier3;
                }
            }
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int maxDelay = 1;
        int maxDelayAfterActivation = 1;
        switch (this.tier) {
            case 1: {
                maxDelay = AlchemicalWizardry.energyBlastMaxDelay;
                maxDelayAfterActivation = AlchemicalWizardry.energyBlastMaxDelayAfterActivation + 1;
                break;
            }
            case 2: {
                maxDelay = AlchemicalWizardry.energyBlastSecondTierMaxDelay;
                maxDelayAfterActivation = AlchemicalWizardry.energyBlastSecondTierMaxDelayAfterActivation + 1;
                break;
            }
            case 3: {
                maxDelay = AlchemicalWizardry.energyBlastThirdTierMaxDelay;
                maxDelayAfterActivation = AlchemicalWizardry.energyBlastThirdTierMaxDelayAfterActivation + 1;
            }
        }
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.func_70093_af()) {
            this.setActivated(par1ItemStack, !this.getActivated(par1ItemStack));
            par1ItemStack.func_77978_p().func_74768_a("worldTimeDelay", (int)(par2World.func_72820_D() - 1L) % maxDelayAfterActivation);
            return par1ItemStack;
        }
        if (!this.getActivated(par1ItemStack)) {
            return par1ItemStack;
        }
        if (this.getDelay(par1ItemStack) > 0) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.field_71075_bZ.field_75098_d && !EnergyBlast.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
            return par1ItemStack;
        }
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!par2World.field_72995_K) {
            par2World.func_72838_d((Entity)new EnergyBlastProjectile(par2World, (EntityLivingBase)par3EntityPlayer, this.damage));
            this.setDelay(par1ItemStack, maxDelay);
        }
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        int delay = this.getDelay(par1ItemStack);
        if (!par2World.field_72995_K && delay > 0) {
            this.setDelay(par1ItemStack, delay - 1);
        }
        int lpPerActivation = 0;
        int maxDelayAfterActivation = 1;
        switch (this.tier) {
            case 1: {
                lpPerActivation = AlchemicalWizardry.energyBlastLPPerActivation;
                maxDelayAfterActivation = AlchemicalWizardry.energyBlastMaxDelayAfterActivation + 1;
                break;
            }
            case 2: {
                lpPerActivation = AlchemicalWizardry.energyBlastSecondTierLPPerActivation;
                maxDelayAfterActivation = AlchemicalWizardry.energyBlastSecondTierMaxDelayAfterActivation + 1;
                break;
            }
            case 3: {
                lpPerActivation = AlchemicalWizardry.energyBlastThirdTierLPPerActivation;
                maxDelayAfterActivation = AlchemicalWizardry.energyBlastThirdTierMaxDelayAfterActivation + 1;
            }
        }
        if (par2World.func_72820_D() % (long)maxDelayAfterActivation == (long)par1ItemStack.func_77978_p().func_74762_e("worldTimeDelay") && par1ItemStack.func_77978_p().func_74767_n("isActive") && !par3EntityPlayer.field_71075_bZ.field_75098_d && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, lpPerActivation)) {
            this.setActivated(par1ItemStack, false);
        }
        par1ItemStack.func_77964_b(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.func_74838_a((String)"tooltip.energyblast.desc1"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.energyblast.desc2"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.alchemy.damage") + " " + this.damage);
        if (par1ItemStack.func_77978_p() != null) {
            if (par1ItemStack.func_77978_p().func_74767_n("isActive")) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.activated"));
            } else {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.sigil.state.deactivated"));
            }
            if (!par1ItemStack.func_77978_p().func_74779_i("ownerName").equals("")) {
                par3List.add(StatCollector.func_74838_a((String)"tooltip.owner.currentowner") + " " + par1ItemStack.func_77978_p().func_74779_i("ownerName"));
            }
        }
    }

    public void setActivated(ItemStack par1ItemStack, boolean newActivated) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74757_a("isActive", newActivated);
    }

    public boolean getActivated(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        return par1ItemStack.func_77978_p().func_74767_n("isActive");
    }

    public void setDelay(ItemStack par1ItemStack, int newDelay) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.func_77978_p().func_74768_a("delay", newDelay);
    }

    public int getDelay(ItemStack par1ItemStack) {
        if (par1ItemStack.func_77978_p() == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        return par1ItemStack.func_77978_p().func_74762_e("delay");
    }
}

