/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.runtime.providers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import minetweaker.runtime.IScriptIterator;

public class ScriptIteratorZip
implements IScriptIterator {
    private final File file;
    private final ZipFile zipFile;
    private final Iterator<ZipEntry> entries;
    private ZipEntry current;

    public ScriptIteratorZip(File file) throws IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
        ArrayList<ZipEntry> entriesList = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> original = this.zipFile.entries();
        while (original.hasMoreElements()) {
            ZipEntry entry = original.nextElement();
            if (!entry.getName().startsWith("scripts/") || !entry.getName().endsWith(".zs")) continue;
            entriesList.add(entry);
        }
        this.entries = entriesList.iterator();
    }

    @Override
    public String getGroupName() {
        return this.file.getName().substring(0, this.file.getName().lastIndexOf(46));
    }

    @Override
    public boolean next() {
        if (this.entries.hasNext()) {
            this.current = this.entries.next();
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.current.getName().substring("scripts/".length());
    }

    @Override
    public InputStream open() throws IOException {
        return this.zipFile.getInputStream(this.current);
    }
}

