/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.string;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableListIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;

public final class StringUtils {
    public static final String KEY_HOLDSHIFT = "misc.holdshift";
    public static final List<String> UNTRANSLATED_STRINGS = new ArrayList<String>();

    private StringUtils() {
    }

    public static String handleColor(String input) {
        if (input == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        ImmutableList chars = Lists.charactersOf((String)input);
        UnmodifiableListIterator iter = chars.listIterator();
        while (iter.hasNext()) {
            Character c = (Character)iter.next();
            if (c.charValue() == '%' && iter.hasNext()) {
                Character c2 = (Character)iter.next();
                if (c2.charValue() == 'c') {
                    StringBuilder handled = new StringBuilder();
                    ChatColor[] values = ChatColor.values();
                    ArrayList<ChatColor> colors = new ArrayList<ChatColor>(values.length);
                    colors.addAll(Arrays.asList(values));
                    int i = 0;
                    block1: while (iter.hasNext() && !colors.isEmpty()) {
                        Character c3 = (Character)iter.next();
                        handled.append(c3);
                        Iterator colorIter = colors.iterator();
                        while (colorIter.hasNext()) {
                            ChatColor color = (ChatColor)((Object)colorIter.next());
                            if (color.name().length() <= i) break block1;
                            if (c3.charValue() == color.name().charAt(i)) continue;
                            colorIter.remove();
                        }
                        ++i;
                    }
                    if (!colors.isEmpty()) {
                        ChatColor color = (ChatColor)((Object)colors.get(0));
                        builder.append(color.toString());
                        continue;
                    }
                    builder.append((CharSequence)handled);
                    continue;
                }
                builder.append('%');
                builder.append(c2);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String translate(String key) {
        String result = StringUtils.handleColor(StatCollector.func_74838_a((String)key));
        if (result.equals(key) && !UNTRANSLATED_STRINGS.contains(key) && !key.contains(".tip")) {
            UNTRANSLATED_STRINGS.add(key);
        }
        return result;
    }

    public static void addShiftAddition(ItemStack stack, List<String> list) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            String baseKey = MessageFormat.format("{0}.tip", stack.func_77973_b().func_77667_c(stack));
            String key = baseKey + 1;
            String translation = StringUtils.translate(key);
            int i = 1;
            while (!translation.equals(key)) {
                list.add(translation);
                key = baseKey + ++i;
                translation = StringUtils.translate(key);
            }
        } else {
            String baseKey = MessageFormat.format("{0}.tip", stack.func_77973_b().func_77667_c(stack));
            String key = baseKey + 1;
            String translation = StringUtils.translate(key);
            if (!translation.equals(key)) {
                list.add(StringUtils.translate(KEY_HOLDSHIFT));
            }
        }
    }

    public static String getFormatedStackSize(long stackSize, boolean forceDisplayNumber) {
        String s = stackSize == 1L && !forceDisplayNumber ? "" : (stackSize < 1000L ? stackSize + "" : (stackSize < 100000L ? stackSize / 1000L + "K" : (stackSize < 1000000L ? "0M" + stackSize / 100000L : stackSize / 1000000L + "M")));
        return s;
    }

    public static String toPercent(double value) {
        if (value > 1.0) {
            value = 1.0;
        }
        if (value < 0.0) {
            value = 0.0;
        }
        int percent = (int)(value *= 100.0);
        return percent + "%";
    }

    public static String getWithMaxWidth(String name, int width, FontRenderer fontRenderer) {
        boolean changed = false;
        while (fontRenderer.func_78256_a(name) > width) {
            name = name.substring(0, name.length() - 2);
            changed = true;
        }
        if (changed) {
            name = name + "...";
        }
        return name;
    }

    public static String getCuttedString(String input, int maxLength, FontRenderer renderer) {
        if (renderer.func_78256_a(input) < maxLength) {
            return input;
        }
        input = input + "...";
        while (renderer.func_78256_a(input) > maxLength && input.length() > 5) {
            input = input.substring(0, input.length() - 4) + "...";
        }
        return input;
    }

    public static String getStringWithSpacesFromInteger(int source) {
        String data = Integer.toString(source);
        return StringUtils.insertThousandsSeparators(data);
    }

    public static String getStringWithSpacesFromLong(long source) {
        String data = Long.toString(source);
        return StringUtils.insertThousandsSeparators(data);
    }

    public static String insertThousandsSeparators(String source) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = source.length(); i > 3; i -= 3) {
            sb.insert(0, source.substring(i - 3, i));
            sb.insert(0, ' ');
        }
        sb.insert(0, source.substring(0, i));
        return sb.toString();
    }
}

