/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.util;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.parts.AEBasePart;
import appeng.parts.ICableBusContainer;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.tile.networking.TileCableBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001\u001a@\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017\u001a\"\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a6\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010\"\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001c0#\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"facingPosX", "", "Lappeng/parts/AEBasePart;", "getFacingPosX", "(Lappeng/parts/AEBasePart;)Ljava/lang/Integer;", "facingPosY", "getFacingPosY", "facingPosZ", "getFacingPosZ", "facingTile", "Lnet/minecraft/tileentity/TileEntity;", "getFacingTile", "(Lappeng/parts/AEBasePart;)Lnet/minecraft/tileentity/TileEntity;", "getCableBus", "Lappeng/parts/ICableBusContainer;", "w", "Lnet/minecraft/world/IBlockAccess;", "posX", "posY", "posZ", "getPart", "Lappeng/api/parts/IPart;", "hitX", "", "hitY", "hitZ", "listAllGridP2P", "", "Lappeng/parts/p2p/PartP2PTunnel;", "grid", "Lappeng/api/networking/IGrid;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "listTargetGridP2P", "clazz", "Ljava/lang/Class;", "betterp2p"})
@SourceDebugExtension(value={"SMAP\nCableBusUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CableBusUtil.kt\ncom/projecturanus/betterp2p/util/CableBusUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1547#2:87\n1618#2,3:88\n764#2:91\n855#2,2:92\n1849#2:94\n1547#2:95\n1618#2,3:96\n1850#2:99\n*S KotlinDebug\n*F\n+ 1 CableBusUtil.kt\ncom/projecturanus/betterp2p/util/CableBusUtilKt\n*L\n51#1:87\n51#1:88,3\n57#1:91\n57#1:92,2\n59#1:94\n59#1:95\n59#1:96,3\n59#1:99\n*E\n"})
public final class CableBusUtilKt {
    @Nullable
    public static final ICableBusContainer getCableBus(@NotNull IBlockAccess w, int posX, int posY, int posZ) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        TileEntity te = w.func_147438_o(posX, posY, posZ);
        ICableBusContainer out = null;
        if (te instanceof TileCableBus) {
            out = (ICableBusContainer)((TileCableBus)te).getCableBus();
        }
        return out;
    }

    @Nullable
    public static final IPart getPart(@NotNull IBlockAccess w, int posX, int posY, int posZ, float hitX, float hitY, float hitZ) {
        SelectedPart p;
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Vec3 vec = Vec3.func_72443_a((double)hitX, (double)hitY, (double)hitZ);
        TileEntity te = w.func_147438_o(posX, posY, posZ);
        if (!(te instanceof IPartHost)) {
            return null;
        }
        SelectedPart selectedPart = p = ((IPartHost)te).selectPart(vec);
        return selectedPart != null ? selectedPart.part : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PartP2PTunnel<?>> listTargetGridP2P(@Nullable IGrid grid, @NotNull EntityPlayer player, @NotNull Class<? extends PartP2PTunnel<?>> clazz) {
        Object object;
        block6: {
            block5: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                if (grid instanceof ISecurityGrid && !((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD)) {
                    return CollectionsKt.emptyList();
                }
                object = grid;
                if (object == null || (object = object.getMachines(clazz)) == null) break block5;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IGridNode iGridNode = (IGridNode)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IGridHost iGridHost = it.getMachine();
                    Intrinsics.checkNotNull((Object)iGridHost, (String)"null cannot be cast to non-null type appeng.parts.p2p.PartP2PTunnel<*>");
                    collection.add((PartP2PTunnel)iGridHost);
                }
                object = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                if (object != null) break block6;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PartP2PTunnel<?>> listAllGridP2P(@Nullable IGrid grid, @NotNull EntityPlayer player) {
        List list;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (grid instanceof ISecurityGrid && !((ISecurityGrid)grid).hasPermission(player, SecurityPermissions.BUILD)) {
            return CollectionsKt.emptyList();
        }
        IGrid iGrid = grid;
        if (iGrid != null && (iGrid = iGrid.getMachinesClasses()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)iGrid;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Class c = (Class)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(c.getSuperclass(), PartP2PTunnel.class)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List classes = list;
        List ret = new ArrayList();
        Iterable $this$forEach$iv = classes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection collection;
            Class c = (Class)element$iv;
            boolean bl = false;
            List list2 = ret;
            IGrid iGrid2 = grid;
            if (iGrid2 != null && (iGrid2 = iGrid2.getMachines(c)) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object element$iv$iv;
                element$iv$iv = (Iterable)iGrid2;
                List list3 = list2;
                boolean $i$f$map = false;
                void var14_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IGridNode iGridNode = (IGridNode)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    IGridHost iGridHost = it.getMachine();
                    Intrinsics.checkNotNull((Object)iGridHost, (String)"null cannot be cast to non-null type appeng.parts.p2p.PartP2PTunnel<*>");
                    collection2.add((PartP2PTunnel)iGridHost);
                }
                list2 = list3;
                collection = (List)destination$iv$iv;
            } else {
                collection = CollectionsKt.emptyList();
            }
            list2.addAll(collection);
        }
        return ret;
    }

    @Nullable
    public static final Integer getFacingPosX(@NotNull AEBasePart $this$facingPosX) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosX, (String)"<this>");
        IPartHost iPartHost = $this$facingPosX.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null) {
            ForgeDirection forgeDirection = $this$facingPosX.getSide();
            n = iPartHost.x & (forgeDirection != null ? forgeDirection.offsetX : EnumFacing.UP.func_82601_c());
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public static final Integer getFacingPosY(@NotNull AEBasePart $this$facingPosY) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosY, (String)"<this>");
        IPartHost iPartHost = $this$facingPosY.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null) {
            ForgeDirection forgeDirection = $this$facingPosY.getSide();
            n = iPartHost.y & (forgeDirection != null ? forgeDirection.offsetY : EnumFacing.UP.func_96559_d());
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public static final Integer getFacingPosZ(@NotNull AEBasePart $this$facingPosZ) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$facingPosZ, (String)"<this>");
        IPartHost iPartHost = $this$facingPosZ.getHost();
        if (iPartHost != null && (iPartHost = iPartHost.getLocation()) != null) {
            ForgeDirection forgeDirection = $this$facingPosZ.getSide();
            n = iPartHost.z & (forgeDirection != null ? forgeDirection.offsetZ : EnumFacing.UP.func_82599_e());
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public static final TileEntity getFacingTile(@NotNull AEBasePart $this$facingTile) {
        Intrinsics.checkNotNullParameter((Object)$this$facingTile, (String)"<this>");
        if ($this$facingTile.getHost().isInWorld()) {
            Integer posX = CableBusUtilKt.getFacingPosX($this$facingTile);
            Integer posY = CableBusUtilKt.getFacingPosY($this$facingTile);
            Integer posZ = CableBusUtilKt.getFacingPosZ($this$facingTile);
            if (posX != null && posY != null && posZ != null) {
                IPartHost iPartHost = $this$facingTile.getHost();
                return iPartHost != null && (iPartHost = iPartHost.getLocation()) != null && (iPartHost = iPartHost.getWorld()) != null ? iPartHost.func_147438_o(posX.intValue(), posY.intValue(), posZ.intValue()) : null;
            }
        }
        return null;
    }
}

