/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.util;

import chylex.hee.init.ItemList;
import chylex.hee.item.ItemSpawnEggs;
import chylex.hee.mechanics.charms.CharmRecipe;
import chylex.hee.mechanics.charms.CharmType;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.content.fragments.KnowledgeFragmentCharm;
import chylex.hee.mechanics.compendium.content.fragments.KnowledgeFragmentCrafting;
import chylex.hee.mechanics.compendium.content.fragments.KnowledgeFragmentEnhancement;
import chylex.hee.mechanics.compendium.events.CompendiumEvents;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import chylex.hee.mechanics.curse.CurseType;
import chylex.hee.mechanics.enhancements.IEnhancementEnum;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public final class KnowledgeUtils {
    public static KnowledgeObject<? extends IKnowledgeObjectInstance<?>> tryGetFromItemStack(ItemStack is) {
        GameRegistry.UniqueIdentifier uniqueId = null;
        try {
            uniqueId = GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uniqueId != null && uniqueId.modId.equalsIgnoreCase("hardcoreenderexpansion")) {
            if (is.func_77973_b() == ItemList.spawn_eggs) {
                Class entity = ItemSpawnEggs.getMobFromDamage(is.func_77960_j());
                if (entity == null) {
                    entity = (Class)EntityList.field_75623_d.get(is.func_77960_j());
                }
                return entity == null ? null : KnowledgeObject.getObject(entity);
            }
            if (is.func_77973_b() instanceof ItemBlock) {
                return CompendiumEvents.getBlockObject(is);
            }
            return KnowledgeObject.getObject(is.func_77973_b());
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getCompendiumTooltip(ItemStack is, EntityPlayer player) {
        List tooltip = is.func_82840_a(player, false);
        if (KnowledgeUtils.tryGetFromItemStack(is) != null) {
            tooltip.add(EnumChatFormatting.DARK_PURPLE + I18n.func_135052_a((String)"compendium.viewObject", (Object[])new Object[0]));
        }
        return tooltip;
    }

    public static KnowledgeFragment[] createCharmFragments(int startID, int requiredFragment) {
        ArrayList<KnowledgeFragment> fragments = new ArrayList<KnowledgeFragment>();
        int a = 0;
        for (CharmType type : CharmType.values()) {
            for (CharmRecipe recipe : type.recipes) {
                fragments.add(new KnowledgeFragmentCharm(startID + a++).setRecipe(recipe).setPrice(2).setUnlockRequirements(requiredFragment));
            }
        }
        return fragments.toArray(new KnowledgeFragment[fragments.size()]);
    }

    public static KnowledgeFragment[] createCurseFragments(int startID, int requiredFragment) {
        ArrayList<KnowledgeFragment> fragments = new ArrayList<KnowledgeFragment>();
        int a = 0;
        for (CurseType type : CurseType.values()) {
            fragments.add(new KnowledgeFragmentCrafting(startID + a++).setRecipe(new ItemStack(ItemList.curse, 8, (int)type.damage)).setPrice(3).setUnlockRequirements(requiredFragment));
        }
        return fragments.toArray(new KnowledgeFragment[fragments.size()]);
    }

    public static KnowledgeFragment[] createEnhancementFragments(Class<? extends Enum> enhancementCls, int startID, int points, int maxUsedIDs, int[] requiredFragments) {
        Enum[] enums = enhancementCls.getEnumConstants();
        if (enums.length > maxUsedIDs) {
            throw new RuntimeException("Enhancement " + enhancementCls.getName() + " exceeds fragment ID limit (" + maxUsedIDs + ").");
        }
        KnowledgeFragment[] fragments = new KnowledgeFragment[enums.length];
        for (int a = 0; a < enums.length; ++a) {
            fragments[a] = new KnowledgeFragmentEnhancement(startID + a).setEnhancement((IEnhancementEnum)((Object)enums[a])).setPrice(points).setUnlockRequirements(requiredFragments);
        }
        return fragments;
    }

    private KnowledgeUtils() {
    }
}

