/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.proxy;

import chylex.hee.entity.fx.EntityAltarOrbFX;
import chylex.hee.entity.fx.EntityBigPortalFX;
import chylex.hee.entity.fx.EntityCustomBubbleFX;
import chylex.hee.entity.fx.EntityEnderGooFX;
import chylex.hee.entity.fx.EntityEnergyClusterFX;
import chylex.hee.entity.fx.EntityOrbitingPortalFX;
import chylex.hee.entity.fx.behavior.ParticleBehaviorMoveTo;
import chylex.hee.entity.item.EntityItemAltar;
import chylex.hee.entity.item.EntityItemIgneousRock;
import chylex.hee.entity.item.EntityItemInstabilityOrb;
import chylex.hee.entity.projectile.EntityProjectileCorruptedEnergy;
import chylex.hee.entity.projectile.EntityProjectileSpatialDash;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.curse.CurseType;
import chylex.hee.mechanics.essence.EssenceType;
import chylex.hee.proxy.FXCommonProxy;
import chylex.hee.system.logging.Log;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityAuraFX;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityCritFX;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntityPortalFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FXClientProxy
extends FXCommonProxy {
    private static void spawn(EntityFX fx) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
    }

    @Override
    public void omnipresent(String particleName, World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        switch (particleName) {
            case "smoke": {
                FXClientProxy.spawn((EntityFX)new EntitySmokeFX(world, x, y, z, motionX, motionY, motionZ));
                break;
            }
            case "largesmoke": {
                FXClientProxy.spawn((EntityFX)new EntitySmokeFX(world, x, y, z, motionX, motionY, motionZ, 2.5f));
                break;
            }
            case "portal": {
                FXClientProxy.spawn((EntityFX)new EntityPortalFX(world, x, y, z, motionX, motionY, motionZ));
                break;
            }
            default: {
                Log.debug("Particle $0 not found!", particleName);
            }
        }
    }

    @Override
    public void item(ItemStack is, World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        FXClientProxy.spawn((EntityFX)(is.func_94608_d() == 0 ? new EntityDiggingFX(world, x, y, z, motionX, motionY, motionZ, Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j()) : new EntityBreakingFX(world, x, y, z, motionX, motionY, motionZ, is.func_77973_b(), is.func_77960_j())));
    }

    @Override
    public void itemTarget(ItemStack is, World world, double startX, double startY, double startZ, final double targetX, final double targetY, final double targetZ, final float speedMultiplier) {
        Object fx = is.func_94608_d() == 0 ? new EntityDiggingFX(world, startX, startY, startZ, 0.0, 0.0, 0.0, Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j()){
            final ParticleBehaviorMoveTo moveBehavior;
            {
                super(x0, x1, x2, x3, x4, x5, x6, x7, x8);
                this.moveBehavior = new ParticleBehaviorMoveTo((EntityFX)this, targetX, targetY, targetZ, speedMultiplier);
            }

            public void func_70071_h_() {
                this.moveBehavior.update((EntityFX)this);
            }
        } : new EntityBreakingFX(world, startX, startY, startZ, 0.0, 0.0, 0.0, is.func_77973_b(), is.func_77960_j()){
            final ParticleBehaviorMoveTo moveBehavior;
            {
                super(x0, x1, x2, x3, x4, x5, x6, x7, x8);
                this.moveBehavior = new ParticleBehaviorMoveTo((EntityFX)this, targetX, targetY, targetZ, speedMultiplier);
            }

            public void func_70071_h_() {
                this.moveBehavior.update((EntityFX)this);
            }
        };
        fx.field_70145_X = true;
        FXClientProxy.spawn((EntityFX)fx);
    }

    @Override
    public void bubble(World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        FXClientProxy.spawn((EntityFX)new EntityCustomBubbleFX(world, x, y, z, motionX, motionY, motionZ));
    }

    @Override
    public void flame(World world, double x, double y, double z, int maxAge) {
        this.flame(world, x, y, z, 0.0, 0.0, 0.0, maxAge);
    }

    @Override
    public void flame(World world, double x, double y, double z, double motionX, double motionY, double motionZ, final int maxAge) {
        FXClientProxy.spawn((EntityFX)new EntityFlameFX(world, x, y, z, motionX, motionY, motionZ){
            {
                super(x0, x1, x2, x3, x4, x5, x6);
                this.field_70547_e = maxAge;
            }
        });
    }

    @Override
    public void portalBig(World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        FXClientProxy.spawn(new EntityBigPortalFX(world, x, y, z, motionX, motionY, motionZ));
    }

    @Override
    public void portalBig(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scaleMp) {
        FXClientProxy.spawn(new EntityBigPortalFX(world, x, y, z, motionX, motionY, motionZ, scaleMp));
    }

    @Override
    public void portalBig(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float scaleMp, final float red, final float green, final float blue) {
        FXClientProxy.spawn(new EntityBigPortalFX(world, x, y, z, motionX, motionY, motionZ, scaleMp){
            {
                super(world, x, y, z, motionX, motionY, motionZ, particleScaleMp);
                this.field_70552_h = red;
                this.field_70553_i = green;
                this.field_70551_j = blue;
            }
        });
    }

    @Override
    public void portalOrbiting(World world, double x, double y, double z, double motionY) {
        FXClientProxy.spawn((EntityFX)new EntityOrbitingPortalFX(world, x, y, z, motionY));
    }

    @Override
    public void portalColor(World world, double x, double y, double z, double motionX, double motionY, double motionZ, final float red, final float green, final float blue) {
        FXClientProxy.spawn((EntityFX)new EntityPortalFX(world, x, y, z, motionX, motionY, motionZ){
            {
                super(x0, x1, x2, x3, x4, x5, x6);
                this.field_70552_h = red;
                this.field_70553_i = green;
                this.field_70551_j = blue;
            }
        });
    }

    @Override
    public void magicCrit(World world, double x, double y, double z, double motionX, double motionY, double motionZ, float red, float green, float blue) {
        EntityCritFX fx = new EntityCritFX(world, x, y, z, motionX, motionY, motionZ);
        fx.func_70538_b(red, green, blue);
        fx.func_94053_h();
        FXClientProxy.spawn((EntityFX)fx);
    }

    @Override
    public void spell(World world, double x, double y, double z, float red, float green, float blue) {
        EntitySpellParticleFX fx = new EntitySpellParticleFX(world, x, y, z, 0.0, 0.0, 0.0);
        fx.func_70538_b(red, green, blue);
        FXClientProxy.spawn((EntityFX)fx);
    }

    @Override
    public void aura(World world, double x, double y, double z, final float red, final float green, final float blue, final int maxAge) {
        FXClientProxy.spawn((EntityFX)new EntityAuraFX(world, x, y, z, 0.0, 0.0, 0.0){
            {
                super(x0, x1, x2, x3, x4, x5, x6);
                this.field_70547_e = maxAge;
                this.field_70552_h = red;
                this.field_70553_i = green;
                this.field_70551_j = blue;
            }
        });
    }

    @Override
    public void curse(World world, double x, double y, double z, CurseType type) {
        Random rand = world.field_73012_v;
        int color = rand.nextInt(5) <= 2 ? type.getColor(0) : type.getColor(1);
        this.portalBig(world, x, y, z, (rand.nextDouble() - 0.5) * rand.nextDouble() * 0.03, (rand.nextDouble() - 0.5) * rand.nextDouble() * 0.03, (rand.nextDouble() - 0.5) * rand.nextDouble() * 0.03, 0.1f + rand.nextFloat() * 0.1f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    @Override
    public void spatialDash(World world, double x, double y, double z) {
        Random rand = world.field_73012_v;
        FXClientProxy.spawn(new EntityBigPortalFX(world, x + (rand.nextDouble() - rand.nextDouble()) * 0.3, y + (rand.nextDouble() - rand.nextDouble()) * 0.3, z + (rand.nextDouble() - rand.nextDouble()) * 0.3, (rand.nextDouble() - 0.5) * 0.01, (rand.nextDouble() - 0.5) * 0.01, (rand.nextDouble() - 0.5) * 0.01, 0.1f));
        for (int a = 0; a < 3; ++a) {
            double motX = (rand.nextDouble() - rand.nextDouble()) * 2.0E-4;
            double motY = (rand.nextDouble() - rand.nextDouble()) * 2.0E-4;
            double motZ = (rand.nextDouble() - rand.nextDouble()) * 2.0E-4;
            FXClientProxy.spawn(new EntityEnergyClusterFX(world, x, y, z, 0.6, 0.2, 1.0, motX, motY, motZ, 0.015f));
        }
    }

    @Override
    public void corruptedEnergy(World world, int x, int y, int z) {
        Random rand = world.field_73012_v;
        double motX = (rand.nextDouble() - rand.nextDouble()) * 0.2;
        double motY = (rand.nextDouble() - rand.nextDouble()) * 0.2;
        double motZ = (rand.nextDouble() - rand.nextDouble()) * 0.2;
        FXClientProxy.spawn(new EntityBigPortalFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, motX, motY, motZ, rand.nextBoolean() ? 1.0f : 1.5f + rand.nextFloat()));
    }

    @Override
    public void enderGoo(World world, int x, int y, int z) {
        Random rand = world.field_73012_v;
        FXClientProxy.spawn((EntityFX)new EntityEnderGooFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble() * 0.5, (double)z + rand.nextDouble(), (rand.nextDouble() - 0.5) * 0.1, 0.12, (rand.nextDouble() - 0.5) * 0.1));
    }

    @Override
    public void altarOrb(World world, double startX, double startY, double startZ, double targetX, double targetY, double targetZ, EssenceType essence) {
        FXClientProxy.spawn(new EntityAltarOrbFX(world, startX, startY, startZ, targetX, targetY, targetZ, essence));
    }

    @Override
    public void energyCluster(TileEntityEnergyCluster cluster) {
        Random rand = cluster.func_145831_w().field_73012_v;
        FXClientProxy.spawn(new EntityEnergyClusterFX(cluster.func_145831_w(), (double)cluster.field_145851_c + 0.5 + (rand.nextDouble() - rand.nextDouble()) * 0.1, (double)cluster.field_145848_d + 0.5 + (rand.nextDouble() - rand.nextDouble()) * 0.1, (double)cluster.field_145849_e + 0.5 + (rand.nextDouble() - rand.nextDouble()) * 0.1, cluster.getColor(0), cluster.getColor(1), cluster.getColor(2), cluster.data));
    }

    @Override
    public void energyClusterMoving(World world, double x, double y, double z, double motionX, double motionY, double motionZ, double red, double green, double blue) {
        FXClientProxy.spawn(new EntityEnergyClusterFX(world, x, y, z, red, green, blue, motionX, motionY, motionZ));
    }

    @Override
    public void altarAura(EntityItemAltar item) {
        Random rand = item.field_70170_p.field_73012_v;
        FXClientProxy.spawn((EntityFX)new EntityAuraFX(item.field_70170_p, item.field_70165_t + rand.nextDouble() * 0.4 - 0.2, item.field_70163_u + rand.nextDouble() * 0.4, item.field_70161_v + rand.nextDouble() * 0.4 - 0.2, 0.0, rand.nextDouble() * 0.05 + 0.05, 0.0){
            {
                this.func_70536_a(82);
                this.field_70551_j = 1.0f;
                this.field_70553_i = 1.0f;
                this.field_70552_h = 1.0f;
                this.field_70544_f = this.field_70146_Z.nextFloat() * 0.2f + 0.5f;
                this.field_70547_e = 10 + this.field_70146_Z.nextInt(3);
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
            }
        });
    }

    @Override
    public void igneousRockBreak(EntityItemIgneousRock rock) {
        Random rand = rock.field_70170_p.field_73012_v;
        FXClientProxy.spawn((EntityFX)new EntityBreakingFX(rock.field_70170_p, rock.field_70165_t + rand.nextDouble() * 0.4 - 0.2, rock.field_70163_u + 0.2 + rand.nextDouble() * 0.2, rock.field_70161_v + rand.nextDouble() * 0.4 - 0.2, 0.0, -0.015, 0.0, ItemList.igneous_rock, 0){
            {
                this.field_70145_X = true;
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
                this.field_70181_x = -0.015;
            }
        });
    }

    @Override
    public void instability(EntityItemInstabilityOrb orb) {
        Random rand = orb.field_70170_p.field_73012_v;
        double motX = (rand.nextDouble() - 0.5) * 0.25;
        double motY = 0.12 + rand.nextGaussian() * 0.02 + rand.nextGaussian() * 0.02;
        double motZ = (rand.nextDouble() - 0.5) * 0.25;
        if (rand.nextInt(4) == 0) {
            FXClientProxy.spawn(new EntityFX(orb.field_70170_p, orb.field_70165_t, orb.field_70163_u + 0.25, orb.field_70161_v, motX, motY, motZ){
                {
                    this.func_70536_a(160 + this.field_70146_Z.nextInt(8));
                    this.field_70551_j = 0.0f;
                    this.field_70552_h = 0.0f;
                    this.field_70553_i = 0.75f;
                    this.field_70545_g = Blocks.field_150433_aE.field_149763_I / 3.0f;
                    this.field_70544_f /= 1.75f;
                    this.field_70547_e = 80 + this.field_70146_Z.nextInt(30);
                }
            });
        } else {
            FXClientProxy.spawn((EntityFX)new EntityBreakingFX(orb.field_70170_p, orb.field_70165_t, orb.field_70163_u + 0.25, orb.field_70161_v, motX, motY, motZ, ItemList.instability_orb, 0){
                {
                    this.field_70545_g /= 3.0f;
                    this.field_70544_f /= 2.5f;
                    this.field_70547_e = 80 + this.field_70146_Z.nextInt(30);
                }
            });
        }
    }

    @Override
    public void spatialDashExplode(EntityProjectileSpatialDash spatialDash) {
        Random rand = spatialDash.field_70170_p.field_73012_v;
        FXClientProxy.spawn(new EntityBigPortalFX(spatialDash.field_70170_p, spatialDash.field_70165_t + (rand.nextDouble() - rand.nextDouble()) * 0.1, spatialDash.field_70163_u + (rand.nextDouble() - rand.nextDouble()) * 0.1, spatialDash.field_70161_v + (rand.nextDouble() - rand.nextDouble()) * 0.1, (rand.nextDouble() - 0.5) * 0.3, (rand.nextDouble() - 0.5) * 0.3, (rand.nextDouble() - 0.5) * 0.3, 1.0f));
    }

    @Override
    public void corruptedEnergy(EntityProjectileCorruptedEnergy energy) {
        Random rand = energy.field_70170_p.field_73012_v;
        double motX = (rand.nextDouble() - rand.nextDouble()) * 0.2;
        double motY = (rand.nextDouble() - rand.nextDouble()) * 0.2;
        double motZ = (rand.nextDouble() - rand.nextDouble()) * 0.2;
        FXClientProxy.spawn(new EntityBigPortalFX(energy.field_70170_p, energy.field_70165_t + (rand.nextDouble() - 0.5) * 0.2, energy.field_70163_u + 0.5 + (rand.nextDouble() - 0.5) * 0.2, energy.field_70161_v + (rand.nextDouble() - 0.5) * 0.2, motX, motY, motZ, rand.nextBoolean() ? 0.3f : 0.4f + rand.nextFloat() * 0.4f));
    }
}

