/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.savedata.types;

import chylex.hee.mechanics.misc.TempleEvents;
import chylex.hee.system.savedata.WorldSavefile;
import chylex.hee.system.util.BlockPosM;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;

public class DragonSavefile
extends WorldSavefile {
    private Map<String, ChunkCoordinates> crystals = new HashMap<String, ChunkCoordinates>();
    private Set<UUID> templePlayers = new HashSet<UUID>();
    private BlockPosM portalEggLocation = new BlockPosM(0, 100, 0);
    private ChunkCoordIntPair lastDragonChunk = new ChunkCoordIntPair(0, 0);
    private boolean isDragonDead;
    private int dragonDeathCount;
    private boolean preventTempleDestruction;
    private boolean shouldDestroyEnd;

    public DragonSavefile() {
        super("server.nbt");
    }

    public String addCrystal(int posX, int posY, int posZ) {
        String key = "l-" + Arrays.hashCode(new int[]{posX, posY, posZ});
        this.crystals.put(key, new ChunkCoordinates(posX, posY, posZ));
        this.setModified();
        return key;
    }

    public void destroyCrystal(String key) {
        this.crystals.remove(key);
        this.setModified();
    }

    public int countCrystals() {
        return this.crystals.size();
    }

    public void resetCrystals() {
        this.crystals.clear();
        this.setModified();
    }

    public void setLastDragonChunk(int x, int z) {
        this.lastDragonChunk = new ChunkCoordIntPair(x, z);
        this.setModified();
    }

    public ChunkCoordIntPair getLastDragonChunk() {
        return this.lastDragonChunk;
    }

    public void setDragonDead(boolean isDead) {
        this.isDragonDead = isDead;
        this.setModified();
    }

    public boolean isDragonDead() {
        return this.isDragonDead;
    }

    public void addDragonDeath() {
        ++this.dragonDeathCount;
        this.setModified();
    }

    public int getDragonDeathAmount() {
        return this.dragonDeathCount;
    }

    public void setPlayerIsInTemple(EntityPlayer player, boolean isInTemple) {
        UUID playerID = player.func_146103_bH().getId();
        boolean contains = this.templePlayers.contains(playerID);
        if (isInTemple && !contains) {
            this.templePlayers.add(playerID);
        } else if (!isInTemple && contains) {
            this.templePlayers.remove(player.func_146103_bH().getId());
        }
        this.setModified();
    }

    public Set<UUID> getPlayersInTemple() {
        return new HashSet<UUID>(this.templePlayers);
    }

    public void resetPlayersInTemple() {
        this.templePlayers.clear();
        this.setModified();
    }

    public void setPreventTempleDestruction(boolean preventTempleDestruction) {
        this.preventTempleDestruction = preventTempleDestruction;
        this.setModified();
    }

    public boolean shouldPreventTempleDestruction() {
        return this.preventTempleDestruction;
    }

    public void setDestroyEnd(boolean should) {
        this.shouldDestroyEnd = should;
        this.setModified();
    }

    public boolean shouldDestroyEnd() {
        return this.shouldDestroyEnd;
    }

    public BlockPosM getPortalEggLocation() {
        return this.portalEggLocation;
    }

    @Override
    protected void onSave(NBTTagCompound nbt) {
        nbt.func_74777_a("dragonDeaths", (short)this.dragonDeathCount);
        nbt.func_74757_a("dragonDead", this.isDragonDead);
        nbt.func_74757_a("noTempleDestruct", this.preventTempleDestruction);
        nbt.func_74757_a("destroyEnd", this.shouldDestroyEnd);
        nbt.func_74772_a("portalCoords", this.portalEggLocation.toLong());
        nbt.func_74783_a("lastChunk", new int[]{this.lastDragonChunk.field_77276_a, this.lastDragonChunk.field_77275_b});
        NBTTagCompound tagCrystals = new NBTTagCompound();
        for (Map.Entry<String, ChunkCoordinates> entry : this.crystals.entrySet()) {
            ChunkCoordinates coords = entry.getValue();
            tagCrystals.func_74783_a(entry.getKey(), new int[]{coords.field_71574_a, coords.field_71572_b, coords.field_71573_c});
        }
        nbt.func_74782_a("crystals", (NBTBase)tagCrystals);
        NBTTagList tagTemplePlayers = new NBTTagList();
        for (UUID uuid : this.templePlayers) {
            tagTemplePlayers.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        nbt.func_74782_a("templePlayers", (NBTBase)tagTemplePlayers);
    }

    @Override
    protected void onLoad(NBTTagCompound nbt) {
        this.dragonDeathCount = nbt.func_74765_d("dragonDeaths");
        this.isDragonDead = nbt.func_74767_n("dragonDead");
        this.preventTempleDestruction = nbt.func_74767_n("noTempleDestruct");
        this.shouldDestroyEnd = nbt.func_74767_n("destroyEnd");
        if (this.shouldDestroyEnd) {
            TempleEvents.destroyWorld();
        }
        this.portalEggLocation = BlockPosM.fromNBT(nbt, "portalCoords");
        int[] lastChunk = nbt.func_74759_k("lastChunk");
        if (lastChunk.length == 2) {
            this.lastDragonChunk = new ChunkCoordIntPair(lastChunk[0], lastChunk[1]);
        }
        NBTTagCompound tagCrystals = nbt.func_74775_l("crystals");
        for (String key : tagCrystals.func_150296_c()) {
            int[] coords = tagCrystals.func_74759_k(key);
            if (coords.length != 3) continue;
            this.crystals.put(key, new ChunkCoordinates(coords[0], coords[1], coords[2]));
        }
        NBTTagList tagTemplePlayers = nbt.func_150295_c("templePlayers", 8);
        for (int a = 0; a < tagTemplePlayers.func_74745_c(); ++a) {
            this.templePlayers.add(UUID.fromString(tagTemplePlayers.func_150307_f(a)));
        }
    }
}

