/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.interaction;

import chylex.hee.entity.mob.EntityMobHomelandEnderman;
import chylex.hee.entity.technical.EntityTechnicalBiomeInteraction;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.misc.HomelandEndermen;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C08PlaySound;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.data.AbstractBiomeInteraction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class BiomeInteractionEnchantedIsland {

    public static class InteractionCellarSounds
    extends AbstractBiomeInteraction {
        private EntityPlayer target;
        private Procedure procedure;
        private byte lastSoundId;
        private byte cellarCheckTimer;
        private int timer;
        private int waitTimer;
        private float soundAngle;
        private float soundDist;
        private boolean soundAngleSign;
        private boolean isActive = true;

        @Override
        public void init() {
            List players = this.world.func_72872_a(EntityPlayer.class, this.getIslandBoundingBox());
            if (players.isEmpty()) {
                this.entity.func_70106_y();
                return;
            }
            List interactions = this.world.func_72872_a(EntityTechnicalBiomeInteraction.class, this.entity.field_70121_D.func_72314_b(1.0, 1.0, 1.0));
            for (int attempt = 0; attempt <= 10; ++attempt) {
                if (attempt == 10) {
                    this.target = null;
                    this.entity.func_70106_y();
                    return;
                }
                this.target = (EntityPlayer)players.get(this.rand.nextInt(players.size()));
                if (this.target.field_70128_L) continue;
                for (EntityTechnicalBiomeInteraction interaction : interactions) {
                    if (interaction == this.entity || interaction.getInteractionType() != InteractionCellarSounds.class || ((InteractionCellarSounds)interaction.getInteraction()).target != this.target) continue;
                    this.target = null;
                    break;
                }
                if (this.target != null) break;
            }
            this.procedure = Procedure.values[this.rand.nextInt(Procedure.values.length)];
            this.soundDist = 21.0f + this.rand.nextFloat() * 5.0f;
            this.soundAngle = (float)(this.rand.nextDouble() * Math.PI * 2.0);
            this.soundAngleSign = this.rand.nextBoolean();
        }

        @Override
        public void update() {
            if (this.target == null || this.target.field_70128_L || !this.target.field_70121_D.func_72326_a(this.getIslandBoundingBox())) {
                this.entity.func_70106_y();
                return;
            }
            if (this.rand.nextInt(10) == 0) {
                this.soundAngle = (float)((double)this.soundAngle + (double)(this.soundAngleSign ? -1 : 1) * (0.8 + this.rand.nextDouble() * 0.5) * MathUtil.toRad(40.0));
                if (this.rand.nextInt(80) == 0) {
                    boolean bl = this.soundAngleSign = !this.soundAngleSign;
                }
            }
            if (this.rand.nextInt(200) == 0) {
                this.procedure = Procedure.values[this.rand.nextInt(Procedure.values.length)];
            }
            if (this.waitTimer > 0) {
                --this.waitTimer;
            }
            if ((double)this.soundDist > 40.0) {
                this.entity.func_70106_y();
            }
            if ((this.cellarCheckTimer = (byte)(this.cellarCheckTimer + 1)) > 10) {
                boolean foundBottom = false;
                boolean foundTop = false;
                int tx = (int)this.target.field_70165_t;
                int tz = (int)this.target.field_70161_v;
                int minPersegritY = (int)this.target.field_70163_u;
                int maxPersegritY = minPersegritY + 1;
                for (int a = 0; a < 8; ++a) {
                    if (!foundBottom) {
                        if (this.world.func_147439_a(tx, minPersegritY, tz) != BlockList.persegrit) {
                            --minPersegritY;
                        } else {
                            foundBottom = true;
                        }
                    }
                    if (!foundTop) {
                        if (this.world.func_147439_a(tx, maxPersegritY, tz) != BlockList.persegrit) {
                            ++maxPersegritY;
                        } else {
                            foundTop = true;
                        }
                    }
                    if (foundBottom && foundTop) break;
                }
                if (foundBottom && foundTop) {
                    if ((double)this.soundDist > 6.0) {
                        this.soundDist = (float)((double)this.soundDist - (0.012 + this.rand.nextDouble() * 0.01));
                    } else if (this.rand.nextInt(100) == 0) {
                        this.soundDist = (float)((double)this.soundDist + this.rand.nextDouble() * 5.0);
                    }
                    this.isActive = true;
                } else {
                    this.soundDist = (float)((double)this.soundDist + 0.08);
                    this.isActive = false;
                }
            }
            if (!this.isActive) {
                return;
            }
            if (--this.timer < 0) {
                switch (this.procedure) {
                    case FOOTSTEPS: {
                        this.timer = 7 + this.rand.nextInt(3);
                        this.play((byte)12, BlockList.persegrit.field_149762_H.func_150497_c() * 0.15f, BlockList.persegrit.field_149762_H.func_150494_d() * 1.0f);
                        break;
                    }
                    case BLOCK_BREAKING: {
                        this.timer = 7 + this.rand.nextInt(8 + this.rand.nextInt(15));
                        if (this.lastSoundId == 0 || this.rand.nextInt(8) == 0) {
                            this.lastSoundId = (byte)(1 + this.rand.nextInt(BreakEffects.values.length));
                        }
                        this.play((byte)(14 + this.lastSoundId), this.lastSoundId == BreakEffects.WOOD.ordinal() + 1 ? 0.5f : 0.25f, BlockList.persegrit.field_149762_H.func_150494_d() * 0.8f);
                        break;
                    }
                    case CHEST_OPENING: {
                        if (this.lastSoundId == 0) {
                            this.timer = 12 + this.rand.nextInt(10 + this.rand.nextInt(50)) + this.rand.nextInt(15);
                            this.lastSoundId = 1;
                            this.play((byte)13, 0.12f, 0.9f + this.rand.nextFloat() * 0.1f);
                            break;
                        }
                        this.timer = 4 + this.rand.nextInt(10 + this.rand.nextInt(70)) + this.rand.nextInt(25);
                        this.lastSoundId = 0;
                        this.play((byte)14, 0.1f, 0.9f + this.rand.nextFloat() * 0.1f);
                        break;
                    }
                    case MOB_KILLING: {
                        if (this.lastSoundId == 0) {
                            this.lastSoundId = (byte)(1 + this.rand.nextInt(MobEffects.values.length));
                        }
                        this.timer = 10 + this.rand.nextInt(4 + this.rand.nextInt(7) * this.rand.nextInt(2));
                        this.play((byte)(19 + 2 * (this.lastSoundId - 1) + (this.rand.nextInt(6) == 0 ? 1 : 0)), this.lastSoundId == MobEffects.COW.ordinal() + 1 ? 0.4f : 1.0f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f);
                    }
                }
                if (--this.waitTimer < -8 - this.rand.nextInt(12)) {
                    this.waitTimer = 10 + MathUtil.floor(15.0f * this.soundDist * (0.3f + this.rand.nextFloat() * 0.6f));
                }
            }
        }

        private void play(byte soundId, float volume, float pitch) {
            PacketPipeline.sendToPlayer(this.target, new C08PlaySound(soundId, this.target.field_70165_t + (double)(MathHelper.func_76134_b((float)this.soundAngle) * this.soundDist), this.target.field_70163_u, this.target.field_70161_v + (double)(MathHelper.func_76126_a((float)this.soundAngle) * this.soundDist), volume, pitch));
        }

        @Override
        public void saveToNBT(NBTTagCompound nbt) {
        }

        @Override
        public void loadFromNBT(NBTTagCompound nbt) {
        }

        private static enum MobEffects {
            PIG,
            COW,
            SHEEP,
            CHICKEN,
            ZOMBIE,
            SKELETON;

            static final MobEffects[] values;

            static {
                values = MobEffects.values();
            }
        }

        private static enum BreakEffects {
            GRASS,
            GRAVEL,
            SAND,
            WOOD;

            static final BreakEffects[] values;

            static {
                values = BreakEffects.values();
            }
        }

        private static enum Procedure {
            FOOTSTEPS,
            BLOCK_BREAKING,
            CHEST_OPENING,
            MOB_KILLING;

            static final Procedure[] values;

            static {
                values = Procedure.values();
            }
        }
    }

    public static class InteractionOvertake
    extends AbstractBiomeInteraction {
        public long groupId = -1L;
        private int overtakeTimer;

        @Override
        public void init() {
            List endermen = this.world.func_72872_a(EntityMobHomelandEnderman.class, this.getIslandBoundingBox());
            for (int attempt = 0; attempt < 3 && !endermen.isEmpty(); ++attempt) {
                List<EntityMobHomelandEnderman> sameGroup;
                EntityMobHomelandEnderman subject = (EntityMobHomelandEnderman)endermen.remove(this.rand.nextInt(endermen.size()));
                if (subject.getGroupId() == -1L || (sameGroup = HomelandEndermen.getInSameGroup(subject)).size() < 5) continue;
                ArrayList<HomelandEndermen.OvertakeGroupRole> roles = CollectionUtil.newList(HomelandEndermen.OvertakeGroupRole.values);
                for (EntityMobHomelandEnderman enderman : sameGroup) {
                    roles.remove((Object)enderman.getGroupRole());
                }
                if (!roles.isEmpty() || this.rand.nextInt(666) >= MathUtil.square(sameGroup.size()) || this.rand.nextInt(3) != 0) continue;
                this.groupId = subject.getGroupId();
                break;
            }
            if (this.groupId == -1L) {
                this.entity.func_70106_y();
            }
        }

        @Override
        public void update() {
            if (++this.overtakeTimer > 500 + this.rand.nextInt(300)) {
                this.entity.func_70106_y();
            }
        }

        @Override
        public void saveToNBT(NBTTagCompound nbt) {
            nbt.func_74772_a("group", this.groupId);
            nbt.func_74777_a("timer", (short)this.overtakeTimer);
        }

        @Override
        public void loadFromNBT(NBTTagCompound nbt) {
            this.groupId = nbt.func_74763_f("group");
            this.overtakeTimer = nbt.func_74765_d("timer");
        }
    }
}

