/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.mobhandler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import kubatech.api.ConstructableItemStack;
import kubatech.api.utils.GSONUtils;
import net.minecraft.item.ItemStack;

public class MobDrop {
    @GSONUtils.SkipGSON
    public ItemStack stack;
    public ConstructableItemStack reconstructableStack;
    public DropType type;
    public int chance;
    public Integer enchantable;
    public HashMap<Integer, Integer> damages;
    public boolean lootable = false;
    public boolean playerOnly = false;
    private static final ByteBuf BufHelper = Unpooled.buffer();

    private MobDrop() {
    }

    public MobDrop(ItemStack stack, DropType type, int chance, Integer enchantable, HashMap<Integer, Integer> damages, boolean lootable, boolean playerOnly) {
        this.stack = stack;
        this.reconstructableStack = new ConstructableItemStack(stack);
        this.type = type;
        this.chance = chance;
        this.enchantable = enchantable;
        this.damages = damages;
        this.lootable = lootable;
        this.playerOnly = playerOnly;
    }

    public void reconstructStack() {
        this.stack = this.reconstructableStack.construct();
    }

    public void writeToByteBuf(ByteBuf byteBuf) {
        BufHelper.clear();
        this.reconstructableStack.writeToByteBuf(BufHelper);
        BufHelper.writeInt(this.type.ordinal());
        BufHelper.writeInt(this.chance);
        BufHelper.writeBoolean(this.enchantable != null);
        if (this.enchantable != null) {
            BufHelper.writeInt(this.enchantable.intValue());
        }
        BufHelper.writeBoolean(this.damages != null);
        if (this.damages != null) {
            BufHelper.writeInt(this.damages.size());
            this.damages.forEach((k, v) -> {
                BufHelper.writeInt(k.intValue());
                BufHelper.writeInt(v.intValue());
            });
        }
        BufHelper.writeBoolean(this.lootable);
        BufHelper.writeBoolean(this.playerOnly);
        byteBuf.writeInt(BufHelper.readableBytes());
        byteBuf.writeBytes(BufHelper);
    }

    public static MobDrop readFromByteBuf(ByteBuf byteBuf) {
        MobDrop mobDrop = new MobDrop();
        int size = byteBuf.readInt();
        mobDrop.reconstructableStack = ConstructableItemStack.readFromByteBuf(byteBuf);
        mobDrop.type = DropType.get(byteBuf.readInt());
        mobDrop.chance = byteBuf.readInt();
        mobDrop.enchantable = byteBuf.readBoolean() ? Integer.valueOf(byteBuf.readInt()) : null;
        if (byteBuf.readBoolean()) {
            mobDrop.damages = new HashMap();
            int damagessize = byteBuf.readInt();
            for (int i = 0; i < damagessize; ++i) {
                mobDrop.damages.put(byteBuf.readInt(), byteBuf.readInt());
            }
        } else {
            mobDrop.damages = null;
        }
        mobDrop.lootable = byteBuf.readBoolean();
        mobDrop.playerOnly = byteBuf.readBoolean();
        mobDrop.reconstructStack();
        return mobDrop;
    }

    public static enum DropType {
        Normal,
        Rare,
        Additional,
        Infernal;

        private static final DropType[] values;

        public static DropType get(int ordinal) {
            return values[ordinal];
        }

        static {
            values = DropType.values();
        }
    }
}

