/*
 * Decompiled with CFR 0.152.
 */
package kubatech.loaders;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import kubatech.api.LoaderReference;
import kubatech.api.enums.ItemList;
import kubatech.api.utils.ItemID;
import kubatech.loaders.item.items.TeaUltimate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class TCLoader {
    public static final String TCCategoryKey = "KUBATECH";
    private static InfusionRecipe ultimateTeaRecipe = null;
    private static ResearchItem ultimateTeaResearch = null;

    public static void init() {
        if (!LoaderReference.GTNHCoreMod || !LoaderReference.DraconicEvolution) {
            return;
        }
        TCLoader.registerRecipe();
        TCLoader.registerResearch();
    }

    private static void registerRecipe() {
        if (ultimateTeaRecipe != null) {
            return;
        }
        ItemStack[] components = new ItemStack[]{ItemList.LegendaryEarlGrayTea.get(1L, new Object[0]), ItemList.LegendaryGreenTea.get(1L, new Object[0]), ItemList.LegendaryPeppermintTea.get(1L, new Object[0]), ItemList.LegendaryPuerhTea.get(1L, new Object[0]), ItemList.LegendaryYellowTea.get(1L, new Object[0]), ItemList.BlackTea.get(1L, new Object[0]), ItemList.EarlGrayTea.get(1L, new Object[0]), ItemList.GreenTea.get(1L, new Object[0]), ItemList.LemonTea.get(1L, new Object[0]), ItemList.MilkTea.get(1L, new Object[0]), ItemList.OolongTea.get(1L, new Object[0]), ItemList.PeppermintTea.get(1L, new Object[0]), ItemList.PuerhTea.get(1L, new Object[0]), ItemList.WhiteTea.get(1L, new Object[0]), ItemList.YellowTea.get(1L, new Object[0])};
        final HashSet componentsHashed = Arrays.stream(components).map(stack -> ItemID.create_NoCopy(stack, true, false, true)).collect(Collectors.toCollection(HashSet::new));
        ultimateTeaRecipe = new InfusionRecipe("KT_UltimateTea", ItemList.LegendaryUltimateTea.get(1L, new Object[0]), 10, new AspectList().add(Aspect.MAGIC, 100).add(Aspect.HEAL, 100).add(Aspect.PLANT, 100).add(Aspect.EXCHANGE, 100), GameRegistry.findItemStack((String)"DraconicEvolution", (String)"dezilsMarshmallow", (int)1), components){

            public boolean matches(ArrayList<ItemStack> input, ItemStack central, World world, EntityPlayer player) {
                if (!central.func_77969_a(this.getRecipeInput())) {
                    return false;
                }
                if (!ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.research)) {
                    return false;
                }
                if (componentsHashed.size() > input.size()) {
                    return false;
                }
                HashSet hashedInputs = input.stream().map(stack -> ItemID.create_NoCopy(stack, true, false, true)).collect(Collectors.toCollection(HashSet::new));
                return hashedInputs.containsAll(componentsHashed);
            }
        };
        ThaumcraftApi.getCraftingRecipes().add(ultimateTeaRecipe);
    }

    private static void registerResearch() {
        if (ultimateTeaResearch == null) {
            ultimateTeaResearch = new ResearchItem("KT_UltimateTea", "NEWHORIZONS", new AspectList().add(Aspect.MAGIC, 1).add(Aspect.HEAL, 1).add(Aspect.PLANT, 1).add(Aspect.EXCHANGE, 1), -2, 4, 2, ItemList.LegendaryUltimateTea.get(1L, new Object[0])){

                public String getName() {
                    return TeaUltimate.getUltimateTeaDisplayName(super.getName());
                }
            };
            ultimateTeaResearch.setPages(new ResearchPage[]{new ResearchPage("KT.research.ultimatetea"){

                public String getTranslatedText() {
                    return TeaUltimate.getUltimateTeaDisplayName(super.getTranslatedText());
                }
            }, new ResearchPage(ultimateTeaRecipe)});
            ultimateTeaResearch.setParents(new String[]{"INFUSION", "DEZILSMARSHMALLOW"});
            ThaumcraftApi.addWarpToResearch((String)"KT_UltimateTea", (int)20);
        }
        ResearchCategories.addResearch((ResearchItem)ultimateTeaResearch);
    }
}

