/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.WorldCoord;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.IDropToFillTextField;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.client.render.BlockPosHighlighter;
import appeng.container.implementations.ContainerInterfaceTerminal;
import appeng.container.slot.AppEngSlot;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.PatternHelper;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiInterfaceTerminal
extends AEBaseGui
implements IDropToFillTextField {
    private static final int MAGIC_HEIGHT_NUMBER = 151;
    private static final int offsetX = 21;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final HashMap<ClientDCInternalInv, DimensionalCoord> blockPosHashMap = new HashMap();
    private final HashMap<GuiButton, ClientDCInternalInv> guiButtonHashMap = new HashMap();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Set<Object> matchedStacks = new HashSet<Object>();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private final MEGuiTextField searchFieldOutputs;
    private final MEGuiTextField searchFieldInputs;
    private final MEGuiTextField searchFieldNames;
    private final GuiImgButton guiButtonHideFull;
    private final GuiImgButton guiButtonAssemblersOnly;
    private final GuiImgButton guiButtonBrokenRecipes;
    private final GuiImgButton terminalStyleBox;
    private boolean refreshList = false;
    private boolean onlyMolecularAssemblers = false;
    private boolean onlyBrokenRecipes = false;
    private int rows = 3;
    private static final String MOLECULAR_ASSEMBLER = "tile.appliedenergistics2.BlockMolecularAssembler";

    public GuiInterfaceTerminal(InventoryPlayer inventoryPlayer, PartInterfaceTerminal te) {
        super(new ContainerInterfaceTerminal(inventoryPlayer, te));
        this.setScrollBar(new GuiScrollbar());
        this.field_146999_f = 208;
        this.field_147000_g = 255;
        this.searchFieldInputs = new MEGuiTextField(86, 12, ButtonToolTips.SearchFieldInputs.getLocal()){

            @Override
            public void onTextChange(String oldText) {
                GuiInterfaceTerminal.this.refreshList();
            }
        };
        this.searchFieldOutputs = new MEGuiTextField(86, 12, ButtonToolTips.SearchFieldOutputs.getLocal()){

            @Override
            public void onTextChange(String oldText) {
                GuiInterfaceTerminal.this.refreshList();
            }
        };
        this.searchFieldNames = new MEGuiTextField(71, 12, ButtonToolTips.SearchFieldNames.getLocal()){

            @Override
            public void onTextChange(String oldText) {
                GuiInterfaceTerminal.this.refreshList();
            }
        };
        this.searchFieldNames.setFocused(true);
        this.guiButtonAssemblersOnly = new GuiImgButton(0, 0, Settings.ACTIONS, null);
        this.guiButtonHideFull = new GuiImgButton(0, 0, Settings.ACTIONS, null);
        this.guiButtonBrokenRecipes = new GuiImgButton(0, 0, Settings.ACTIONS, null);
        this.terminalStyleBox = new GuiImgButton(0, 0, Settings.TERMINAL_STYLE, null);
    }

    private void setScrollBar() {
        this.getScrollBar().setTop(52).setLeft(189).setHeight(this.rows * 18 - 2);
        this.getScrollBar().setRange(0, this.lines.size() - this.rows, 2);
    }

    @Override
    public void func_73866_w_() {
        this.rows = this.calculateRowsCount();
        super.func_73866_w_();
        this.field_147000_g = 151 + this.rows * 18;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        this.searchFieldInputs.x = this.field_147003_i + Math.max(32, 21);
        this.searchFieldInputs.y = this.field_147009_r + 25;
        this.searchFieldOutputs.x = this.field_147003_i + Math.max(32, 21);
        this.searchFieldOutputs.y = this.field_147009_r + 38;
        this.searchFieldNames.x = this.field_147003_i + Math.max(32, 21) + 99;
        this.searchFieldNames.y = this.field_147009_r + 38;
        this.guiButtonAssemblersOnly.field_146128_h = this.field_147003_i + Math.max(32, 21) + 99;
        this.guiButtonAssemblersOnly.field_146129_i = this.field_147009_r + 20;
        this.guiButtonHideFull.field_146128_h = this.guiButtonAssemblersOnly.field_146128_h + 18;
        this.guiButtonHideFull.field_146129_i = this.field_147009_r + 20;
        this.guiButtonBrokenRecipes.field_146128_h = this.guiButtonHideFull.field_146128_h + 18;
        this.guiButtonBrokenRecipes.field_146129_i = this.field_147009_r + 20;
        this.terminalStyleBox.field_146128_h = this.field_147003_i - 18;
        this.terminalStyleBox.field_146129_i = this.field_147009_r + 8;
        this.setScrollBar();
        this.repositionSlots();
    }

    protected void repositionSlots() {
        for (Object obj : this.field_147002_h.field_75151_b) {
            if (!(obj instanceof AppEngSlot)) continue;
            AppEngSlot slot = (AppEngSlot)((Object)obj);
            slot.field_75221_f = this.field_147000_g + slot.getY() - 78 - 7;
        }
    }

    protected int calculateRowsCount() {
        int maxRows = this.getMaxRows();
        boolean hasNEI = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI);
        int NEIPadding = hasNEI ? 40 : 0;
        int extraSpace = this.field_146295_m - 151 - NEIPadding;
        return Math.max(3, Math.min(maxRows, extraSpace / 18));
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.InterfaceTerminal.getLocal()), 8, 6, GuiColors.InterfaceTerminalTitle.getColor());
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 23, this.field_147000_g - 96, GuiColors.InterfaceTerminalInventory.getColor());
        int offset = 51;
        int ex = this.getScrollBar().getCurrentScroll();
        for (int x = 0; x < this.rows && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                for (int z = 0; z < inv.getInventory().func_70302_i_(); ++z) {
                    if (!this.matchedStacks.contains(inv.getInventory().func_70301_a(z))) continue;
                    GuiInterfaceTerminal.func_73734_a((int)(z * 18 + 22), (int)(1 + offset), (int)(z * 18 + 22 + 16), (int)(1 + offset + 16), (int)GuiColors.InterfaceTerminalMatch.getColor());
                }
            } else if (lineObj instanceof String) {
                String name = (String)lineObj;
                int rows = this.byName.get((Object)name).size();
                String postfix = "";
                if (rows > 1) {
                    postfix = " (" + rows + ')';
                }
                while (name.length() > 2 && this.field_146289_q.func_78256_a(name + postfix) > 158) {
                    name = name.substring(0, name.length() - 1);
                }
                this.field_146289_q.func_78276_b(name + postfix, 24, 6 + offset, GuiColors.InterfaceTerminalName.getColor());
            }
            offset += 18;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        this.field_146292_n.clear();
        this.field_147002_h.field_75151_b.removeIf(slot -> slot instanceof SlotDisconnected);
        this.guiButtonAssemblersOnly.set(this.onlyMolecularAssemblers ? ActionItems.MOLECULAR_ASSEMBLEERS_ON : ActionItems.MOLECULAR_ASSEMBLEERS_OFF);
        this.guiButtonHideFull.set(AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal ? ActionItems.TOGGLE_SHOW_FULL_INTERFACES_OFF : ActionItems.TOGGLE_SHOW_FULL_INTERFACES_ON);
        this.guiButtonBrokenRecipes.set(this.onlyBrokenRecipes ? ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERN_OFF : ActionItems.TOGGLE_SHOW_ONLY_INVALID_PATTERN_ON);
        this.terminalStyleBox.set(AEConfig.instance.settings.getSetting(Settings.TERMINAL_STYLE));
        this.field_146292_n.add(this.guiButtonAssemblersOnly);
        this.field_146292_n.add(this.guiButtonHideFull);
        this.field_146292_n.add(this.guiButtonBrokenRecipes);
        this.field_146292_n.add(this.terminalStyleBox);
        this.guiButtonHashMap.clear();
        int offset = 51;
        int ex = this.getScrollBar().getCurrentScroll();
        for (int x = 0; x < this.rows && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                for (int z = 0; z < inv.getInventory().func_70302_i_(); ++z) {
                    this.field_147002_h.field_75151_b.add(new SlotDisconnected(inv, z, z * 18 + 22, 1 + offset));
                }
                GuiImgButton guiButton = new GuiImgButton(this.field_147003_i + 4, this.field_147009_r + offset + 1, Settings.ACTIONS, ActionItems.HIGHLIGHT_INTERFACE);
                this.guiButtonHashMap.put(guiButton, inv);
                this.field_146292_n.add(guiButton);
            }
            offset += 18;
        }
        super.func_73863_a(mouseX, mouseY, btn);
        this.handleTooltip(mouseX, mouseY, this.searchFieldInputs);
        this.handleTooltip(mouseX, mouseY, this.searchFieldOutputs);
        this.handleTooltip(mouseX, mouseY, this.searchFieldNames);
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.searchFieldInputs.mouseClicked(xCoord, yCoord, btn);
        this.searchFieldOutputs.mouseClicked(xCoord, yCoord, btn);
        this.searchFieldNames.mouseClicked(xCoord, yCoord, btn);
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_146284_a(GuiButton btn) {
        GuiImgButton iBtn;
        if (this.guiButtonHashMap.containsKey(btn)) {
            DimensionalCoord blockPos = this.blockPosHashMap.get(this.guiButtonHashMap.get(btn));
            WorldCoord blockPos2 = new WorldCoord((int)this.field_146297_k.field_71439_g.field_70165_t, (int)this.field_146297_k.field_71439_g.field_70163_u, (int)this.field_146297_k.field_71439_g.field_70161_v);
            if (this.field_146297_k.field_71441_e.field_73011_w.field_76574_g != blockPos.getDimension()) {
                this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation(PlayerMessages.InterfaceInOtherDim.getName(), new Object[]{blockPos.getDimension()}));
            } else {
                BlockPosHighlighter.highlightBlock(blockPos, System.currentTimeMillis() + 500L * WorldCoord.getTaxicabDistance(blockPos, blockPos2));
                this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentTranslation(PlayerMessages.InterfaceHighlighted.getName(), new Object[]{blockPos.x, blockPos.y, blockPos.z}));
            }
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (btn == this.guiButtonHideFull) {
            AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal = !AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal;
            this.refreshList();
        } else if (btn == this.guiButtonAssemblersOnly) {
            this.onlyMolecularAssemblers = !this.onlyMolecularAssemblers;
            this.refreshList();
        } else if (btn == this.guiButtonBrokenRecipes) {
            this.onlyBrokenRecipes = !this.onlyBrokenRecipes;
            this.refreshList();
        } else if (btn instanceof GuiImgButton && (iBtn = (GuiImgButton)btn).getSetting() != Settings.ACTIONS) {
            Enum cv = iBtn.getCurrentValue();
            boolean backwards = Mouse.isButtonDown((int)1);
            Enum next = Platform.rotateEnum(cv, backwards, iBtn.getSetting().getPossibleValues());
            if (btn == this.terminalStyleBox) {
                AEConfig.instance.settings.putSetting(iBtn.getSetting(), next);
                this.reinitialize();
            }
            iBtn.set(next);
        }
    }

    private void reinitialize() {
        this.field_146292_n.clear();
        this.func_73866_w_();
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        int x;
        this.bindTexture("guis/newinterfaceterminal.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 53);
        int offset = 51;
        int ex = this.getScrollBar().getCurrentScroll();
        for (x = 0; x < this.rows; ++x) {
            this.func_73729_b(offsetX, offsetY + 53 + x * 18, 0, 52, this.field_146999_f, 18);
        }
        for (x = 0; x < this.rows && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = inv.getInventory().func_70302_i_() * 18;
                this.func_73729_b(offsetX + 20, offsetY + offset, 20, 173, width, 18);
            }
            offset += 18;
        }
        this.func_73729_b(offsetX, offsetY + 50 + this.rows * 18, 0, 158, this.field_146999_f, 99);
        this.searchFieldInputs.drawTextBox();
        this.searchFieldOutputs.drawTextBox();
        this.searchFieldNames.drawTextBox();
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (character == ' ' ? this.searchFieldInputs.getText().isEmpty() && this.searchFieldInputs.isFocused() || this.searchFieldOutputs.getText().isEmpty() && this.searchFieldOutputs.isFocused() || this.searchFieldNames.getText().isEmpty() && this.searchFieldNames.isFocused() : character == '\t' && this.handleTab()) {
                return;
            }
            if (this.searchFieldInputs.textboxKeyTyped(character, key) || this.searchFieldOutputs.textboxKeyTyped(character, key) || this.searchFieldNames.textboxKeyTyped(character, key)) {
                this.refreshList();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    private boolean handleTab() {
        if (this.searchFieldInputs.isFocused()) {
            this.searchFieldInputs.setFocused(false);
            if (GuiInterfaceTerminal.func_146272_n()) {
                this.searchFieldNames.setFocused(true);
            } else {
                this.searchFieldOutputs.setFocused(true);
            }
            return true;
        }
        if (this.searchFieldOutputs.isFocused()) {
            this.searchFieldOutputs.setFocused(false);
            if (GuiInterfaceTerminal.func_146272_n()) {
                this.searchFieldInputs.setFocused(true);
            } else {
                this.searchFieldNames.setFocused(true);
            }
            return true;
        }
        if (this.searchFieldNames.isFocused()) {
            this.searchFieldNames.setFocused(false);
            if (GuiInterfaceTerminal.func_146272_n()) {
                this.searchFieldOutputs.setFocused(true);
            } else {
                this.searchFieldInputs.setFocused(true);
            }
            return true;
        }
        return false;
    }

    public void postUpdate(NBTTagCompound in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.func_150296_c()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                NBTTagCompound invData = in.func_74775_l(key);
                ClientDCInternalInv current = this.getById(id, invData.func_74763_f("sortBy"), invData.func_74779_i("un"));
                int X = invData.func_74762_e("x");
                int Y = invData.func_74762_e("y");
                int Z = invData.func_74762_e("z");
                int dim = invData.func_74762_e("dim");
                this.blockPosHashMap.put(current, new DimensionalCoord(X, Y, Z, dim));
                for (int x = 0; x < current.getInventory().func_70302_i_(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().func_70299_a(x, ItemStack.func_77949_a((NBTTagCompound)invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        this.field_146292_n.clear();
        this.matchedStacks.clear();
        String searchFieldInputs = this.searchFieldInputs.getText().toLowerCase();
        String searchFieldOutputs = this.searchFieldOutputs.getText().toLowerCase();
        String searchFieldNames = this.searchFieldNames.getText().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm("IN:" + searchFieldInputs + "OUT:" + searchFieldOutputs + "NAME:" + searchFieldNames + AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal + this.onlyMolecularAssemblers + this.onlyBrokenRecipes);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFieldInputs.isEmpty() && searchFieldOutputs.isEmpty();
            boolean interfaceHasFreeSlots = false;
            boolean interfaceHasBrokenRecipes = false;
            if (!found || AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal || this.onlyBrokenRecipes) {
                for (ItemStack itemStack : entry.getInventory()) {
                    if (itemStack == null) {
                        interfaceHasFreeSlots = true;
                        continue;
                    }
                    if (this.onlyBrokenRecipes && this.recipeIsBroken(itemStack)) {
                        interfaceHasBrokenRecipes = true;
                    }
                    if ((searchFieldInputs.isEmpty() || !this.itemStackMatchesSearchTerm(itemStack, searchFieldInputs, 0)) && (searchFieldOutputs.isEmpty() || !this.itemStackMatchesSearchTerm(itemStack, searchFieldOutputs, 1))) continue;
                    found = true;
                    this.matchedStacks.add(itemStack);
                }
            }
            if (!(!found || !entry.getName().toLowerCase().contains(searchFieldNames) || this.onlyMolecularAssemblers && !entry.getUnlocalizedName().contains(MOLECULAR_ASSEMBLER) || AEConfig.instance.showOnlyInterfacesWithFreeSlotsInInterfaceTerminal && !interfaceHasFreeSlots || this.onlyBrokenRecipes && !interfaceHasBrokenRecipes)) {
                this.byName.put((Object)entry.getName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.names.size() + this.byId.size());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.setScrollBar();
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm, int pass) {
        if (itemStack == null) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return false;
        }
        NBTTagList tags = encodedValue.func_150295_c(pass == 0 ? "in" : "out", 10);
        boolean containsInvalidDisplayName = GuiText.UnknownItem.getLocal().toLowerCase().contains(searchTerm);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            String displayName;
            NBTTagCompound tag = tags.func_150305_b(i);
            ItemStack parsedItemStack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (!(parsedItemStack != null ? (displayName = Platform.getItemDisplayName(AEApi.instance().storage().createItemStack(parsedItemStack)).toLowerCase()).contains(searchTerm) : containsInvalidDisplayName && !tag.func_82582_d())) continue;
            return true;
        }
        return false;
    }

    private boolean recipeIsBroken(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return true;
        }
        World w = CommonHelper.proxy.getWorld();
        if (w == null) {
            return false;
        }
        try {
            new PatternHelper(itemStack, w);
            return false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.SMALL ? AEConfig.instance.InterfaceTerminalSmallSize : Integer.MAX_VALUE;
    }

    private ClientDCInternalInv getById(long id, long sortBy, String unlocalizedName) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(9, id, sortBy, unlocalizedName);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }

    @Override
    public boolean isOverTextField(int mousex, int mousey) {
        return this.searchFieldInputs.isMouseIn(mousex, mousey) || this.searchFieldOutputs.isMouseIn(mousex, mousey) || this.searchFieldNames.isMouseIn(mousex, mousey);
    }

    @Override
    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        if (this.searchFieldInputs.isMouseIn(mousex, mousey)) {
            this.searchFieldInputs.setText(displayName);
        } else if (this.searchFieldOutputs.isMouseIn(mousex, mousey)) {
            this.searchFieldOutputs.setText(displayName);
        } else if (this.searchFieldNames.isMouseIn(mousex, mousey)) {
            this.searchFieldNames.setText(displayName);
        }
    }
}

