/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.util.IConfigManager;
import appeng.helpers.IOreFilterable;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileCellWorkbench
extends AEBaseTile
implements IUpgradeableHost,
IAEAppEngInventory,
IConfigManagerHost,
IOreFilterable {
    private final AppEngInternalInventory cell = new AppEngInternalInventory(this, 1);
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 63);
    private final ConfigManager manager = new ConfigManager(this);
    private IInventory cacheUpgrades = null;
    private IInventory cacheConfig = null;
    private boolean locked = false;

    public TileCellWorkbench() {
        this.manager.registerSetting(Settings.COPY_MODE, (Enum)CopyMode.CLEAR_ON_REMOVE);
        this.cell.setEnableClientEvents(true);
    }

    public IInventory getCellUpgradeInventory() {
        if (this.cacheUpgrades == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            ItemStack is = this.cell.func_70301_a(0);
            if (is == null) {
                return null;
            }
            IInventory inv = cell.getUpgradesInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheUpgrades = inv;
            return this.cacheUpgrades;
        }
        return this.cacheUpgrades;
    }

    public ICellWorkbenchItem getCell() {
        if (this.cell.func_70301_a(0) == null) {
            return null;
        }
        if (this.cell.func_70301_a(0).func_77973_b() instanceof ICellWorkbenchItem) {
            return (ICellWorkbenchItem)this.cell.func_70301_a(0).func_77973_b();
        }
        return null;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCellWorkbench(NBTTagCompound data) {
        this.cell.writeToNBT(data, "cell");
        this.config.writeToNBT(data, "config");
        this.manager.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCellWorkbench(NBTTagCompound data) {
        this.cell.readFromNBT(data, "cell");
        this.config.readFromNBT(data, "config");
        this.manager.readFromNBT(data);
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        if (name.equals("cell")) {
            return this.cell;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        IInventory inv = this.getCellUpgradeInventory();
        if (inv != null) {
            for (int x = 0; x < inv.func_70302_i_(); ++x) {
                ItemStack is = inv.func_70301_a(x);
                if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || ((IUpgradeModule)is.func_77973_b()).getType(is) != u) continue;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.cell && !this.locked) {
            this.locked = true;
            this.cacheUpgrades = null;
            this.cacheConfig = null;
            IInventory configInventory = this.getCellConfigInventory();
            if (configInventory != null) {
                int x;
                boolean cellHasConfig = false;
                for (x = 0; x < configInventory.func_70302_i_(); ++x) {
                    if (configInventory.func_70301_a(x) == null) continue;
                    cellHasConfig = true;
                    break;
                }
                if (cellHasConfig) {
                    for (x = 0; x < this.config.func_70302_i_(); ++x) {
                        this.config.func_70299_a(x, configInventory.func_70301_a(x));
                    }
                } else {
                    for (x = 0; x < this.config.func_70302_i_(); ++x) {
                        configInventory.func_70299_a(x, this.config.func_70301_a(x));
                    }
                    configInventory.func_70296_d();
                }
            } else if (this.manager.getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
                for (int x = 0; x < this.config.func_70302_i_(); ++x) {
                    this.config.func_70299_a(x, null);
                }
                this.func_70296_d();
            }
            this.locked = false;
        } else if (inv == this.config && !this.locked) {
            IInventory c = this.getCellConfigInventory();
            if (c != null) {
                for (int x = 0; x < this.config.func_70302_i_(); ++x) {
                    c.func_70299_a(x, this.config.func_70301_a(x));
                }
                c.func_70296_d();
            }
        } else if (inv == this.cacheUpgrades && this.getInstalledUpgrades(Upgrades.ORE_FILTER) == 0) {
            this.setFilter("");
        }
    }

    private IInventory getCellConfigInventory() {
        if (this.cacheConfig == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            ItemStack is = this.cell.func_70301_a(0);
            if (is == null) {
                return null;
            }
            IInventory inv = cell.getConfigInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheConfig = inv;
        }
        return this.cacheConfig;
    }

    @Override
    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        if (this.cell.func_70301_a(0) != null) {
            drops.add(this.cell.func_70301_a(0));
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.manager;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    @Override
    public String getFilter() {
        ItemStack is = this.cell.func_70301_a(0);
        if (is != null && is.func_77973_b() instanceof ICellWorkbenchItem) {
            return ((ICellWorkbenchItem)is.func_77973_b()).getOreFilter(is);
        }
        return "";
    }

    @Override
    public void setFilter(String filter) {
        ItemStack is = this.cell.func_70301_a(0);
        if (is != null && is.func_77973_b() instanceof ICellWorkbenchItem) {
            ((ICellWorkbenchItem)is.func_77973_b()).setOreFilter(is, filter);
        }
    }
}

