/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.BlockDoubleslabMeta;
import de.katzenpapst.amunra.block.IMassiveBlock;
import de.katzenpapst.amunra.block.IMetaBlock;
import de.katzenpapst.amunra.block.SubBlock;
import de.katzenpapst.amunra.helper.BlockMassHelper;
import de.katzenpapst.amunra.item.ItemSlabMulti;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSlabMeta
extends BlockSlab
implements IMetaBlock,
IMassiveBlock {
    protected final Map<String, Integer> nameMetaMap = new HashMap<String, Integer>();
    protected SubBlock[] subBlocksArray = new SubBlock[8];
    protected BlockDoubleslabMeta doubleslabMetablock;

    public BlockSlabMeta(String name, Material material) {
        super(false, material);
        this.func_149663_c(name);
    }

    @Override
    public String getUnlocalizedSubBlockName(int meta) {
        return this.getSubBlock(meta).func_149739_a() + ".slab";
    }

    public void setDoubleslabMeta(BlockDoubleslabMeta doubleslabMetablock) {
        this.doubleslabMetablock = doubleslabMetablock;
    }

    @Override
    public BlockMetaPair addSubBlock(int meta, SubBlock sb) {
        if (meta >= this.subBlocksArray.length || meta < 0) {
            throw new IllegalArgumentException("Meta " + meta + " must be < " + this.subBlocksArray.length + " and >= 0");
        }
        if (this.subBlocksArray[meta] != null) {
            throw new IllegalArgumentException("Meta " + meta + " is already in use");
        }
        if (this.nameMetaMap.containsKey(sb.func_149739_a())) {
            throw new IllegalArgumentException("Name " + sb.func_149739_a() + " is already in use");
        }
        this.nameMetaMap.put(sb.func_149739_a(), meta);
        this.subBlocksArray[meta] = sb;
        return new BlockMetaPair((Block)this, (byte)meta);
    }

    public BlockMetaPair addSubBlock(int meta, BlockMetaPair basedOn) {
        return this.addSubBlock(meta, ((IMetaBlock)basedOn.getBlock()).getSubBlock(basedOn.getMetadata()));
    }

    @Override
    public int getMetaByName(String name) {
        if (this.nameMetaMap.containsKey(name)) {
            return this.nameMetaMap.get(name);
        }
        throw new IllegalArgumentException("Subblock " + name + " doesn't exist");
    }

    @Override
    public SubBlock getSubBlock(int meta) {
        return this.subBlocksArray[this.getDistinctionMeta(meta)];
    }

    public SubBlock[] getAllSubBlocks() {
        return this.subBlocksArray;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getSubBlock(meta).func_149691_a(side, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        for (SubBlock sb : this.subBlocksArray) {
            if (sb == null) continue;
            sb.func_149651_a(reg);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return AmunRa.arTab;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public int func_149692_a(int meta) {
        return this.getDistinctionMeta(meta);
    }

    public int func_149643_k(World worldIn, int x, int y, int z) {
        return worldIn.func_72805_g(x, y, z);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.subBlocksArray.length; ++i) {
            if (this.subBlocksArray[i] == null) continue;
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        int meta = world.func_72805_g(x, y, z);
        if (this.getSubBlock(meta) != null) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, this.getDistinctionMeta(meta));
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, x, y, z, null);
    }

    @Override
    public void register() {
        GameRegistry.registerBlock((Block)this, ItemSlabMulti.class, (String)this.func_149739_a(), (Object[])new Object[]{this, this.doubleslabMetablock});
        for (int i = 0; i < this.subBlocksArray.length; ++i) {
            SubBlock sb = this.subBlocksArray[i];
            if (sb == null) continue;
            this.setHarvestLevel(sb.getHarvestTool(0), sb.getHarvestLevel(0), i);
        }
    }

    public String func_150002_b(int p_150002_1_) {
        return this.func_149739_a() + "." + this.getSubBlock(p_150002_1_).func_149739_a();
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int metadata = world.func_72805_g(x, y, z);
        return this.getSubBlock(metadata).getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public float func_149712_f(World worldIn, int x, int y, int z) {
        int meta = worldIn.func_72805_g(x, y, z);
        return this.getSubBlock(meta).func_149712_f(worldIn, x, y, z);
    }

    @Override
    public int getNumPossibleSubBlocks() {
        return this.subBlocksArray.length;
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        return this.getSubBlock(metadata).getExpDrop(world, 0, fortune);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        int meta = worldIn.func_72805_g(x, y, z);
        this.getSubBlock(meta).func_149695_a(worldIn, x, y, z, neighbor);
        super.func_149695_a(worldIn, x, y, z, neighbor);
    }

    @Override
    public float getMass(World w, int x, int y, int z, int meta) {
        SubBlock sb = this.getSubBlock(meta);
        float parentMass = BlockMassHelper.getBlockMass(w, sb, meta, x, y, z);
        return parentMass / 2.0f;
    }

    public String getHarvestTool(int metadata) {
        SubBlock sb = this.getSubBlock(metadata);
        return sb == null ? null : sb.getHarvestTool(metadata);
    }

    public int getHarvestLevel(int metadata) {
        SubBlock sb = this.getSubBlock(metadata);
        return sb == null ? -1 : sb.getHarvestLevel(metadata);
    }

    public boolean isToolEffective(String type, int metadata) {
        return this.getHarvestTool(metadata).equals(type);
    }
}

