/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.command;

import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldProvider;

public class CommandMothershipInfo
extends CommandBase {
    public String func_71517_b() {
        return "mothership_info";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <name>";
    }

    public void func_71515_b(ICommandSender sender, String[] params) {
        HashMap<Integer, Mothership> data = TickHandlerServer.mothershipData.getMotherships();
        Mothership playerMS = null;
        WorldProvider worldProvider = sender.func_130014_f_().field_73011_w;
        if (worldProvider instanceof MothershipWorldProvider) {
            MothershipWorldProvider shipProvider = (MothershipWorldProvider)worldProvider;
            playerMS = (Mothership)shipProvider.getCelestialBody();
        }
        if (data.size() <= 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("No registered motherships"));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(data.size() + " registered motherships"));
            for (Map.Entry entry : data.entrySet()) {
                Mothership ship = (Mothership)((Object)entry.getValue());
                int id = (Integer)entry.getKey();
                StringBuilder sb = new StringBuilder();
                if (playerMS == ship) {
                    sb.append(">");
                } else {
                    sb.append(" ");
                }
                sb.append("#");
                sb.append(id);
                sb.append(", ID ");
                sb.append(ship.getID());
                sb.append(", '");
                sb.append(ship.getLocalizedName());
                sb.append("', DIM ");
                sb.append(ship.getDimensionID());
                sb.append(", ");
                if (ship.isInTransit()) {
                    sb.append("in transit to ");
                } else {
                    sb.append("orbiting ");
                }
                sb.append(ship.getDestination().getName());
                sender.func_145747_a((IChatComponent)new ChatComponentText(sb.toString()));
            }
        }
    }
}

