/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.mothership;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import de.katzenpapst.amunra.helper.PlayerID;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;

public class Mothership
extends CelestialBody {
    protected Set<PlayerID> playerSetLanding = new HashSet<PlayerID>();
    protected Set<PlayerID> playerSetUsage = new HashSet<PlayerID>();
    protected PermissionMode permModeLanding = PermissionMode.NONE;
    protected PermissionMode permModeUsage = PermissionMode.NONE;
    protected PlayerID owner;
    protected String msName = "";
    protected CelestialBody previousParent;
    protected CelestialBody currentParent;
    protected long travelTimeTotal;
    protected long travelTimeRemaining;
    protected boolean inTransit = false;
    protected int mothershipId;
    public static final String nameSeparator = "\\";

    public Mothership(int id, PlayerID owner) {
        super("mothership_" + id);
        this.mothershipId = id;
        this.owner = owner;
        this.setBodyIcon(new ResourceLocation("amunra", "textures/gui/mothership_icons/0.png"));
        this.setRelativeOrbitTime(5.0f);
    }

    public Mothership(int id, UUID ownerUUID, String ownerName) {
        this(id, new PlayerID(ownerUUID, ownerName));
    }

    public boolean setParent(CelestialBody parent) {
        if (parent instanceof Satellite) {
            return false;
        }
        this.currentParent = parent;
        this.inTransit = false;
        this.travelTimeRemaining = 0L;
        return true;
    }

    public Set<PlayerID> getPlayerListLanding() {
        return this.playerSetLanding;
    }

    public void addPlayerToListLanding(PlayerID pi) {
        this.playerSetLanding.add(pi);
    }

    public void setPlayerListLanding(Collection<PlayerID> list) {
        this.playerSetLanding.clear();
        this.playerSetLanding.addAll(list);
    }

    public Set<PlayerID> getPlayerListUsage() {
        return this.playerSetUsage;
    }

    public void addPlayerToListUsage(PlayerID pi) {
        this.playerSetUsage.add(pi);
    }

    public void setPlayerListUsage(Collection<PlayerID> list) {
        this.playerSetUsage.clear();
        this.playerSetUsage.addAll(list);
    }

    public PermissionMode getLandingPermissionMode() {
        return this.permModeLanding;
    }

    public void setLandingPermissionMode(PermissionMode mode) {
        this.permModeLanding = mode;
    }

    public PermissionMode getUsagePermissionMode() {
        return this.permModeUsage;
    }

    public void setUsagePermissionMode(PermissionMode mode) {
        this.permModeUsage = mode;
    }

    public boolean getReachable() {
        return this.isReachable;
    }

    public void setUnreachable() {
        this.isReachable = true;
    }

    public String getLocalizedName() {
        if (this.msName.isEmpty()) {
            this.msName = String.format(StatCollector.func_74838_a((String)"mothership.default.name"), this.mothershipId);
        }
        return this.msName;
    }

    public void setLocalizedName(String newName) {
        this.msName = newName;
    }

    public boolean isInTransit() {
        return this.inTransit;
    }

    public CelestialBody getParent() {
        if (this.inTransit) {
            return null;
        }
        return this.currentParent;
    }

    public CelestialBody getSource() {
        if (this.inTransit) {
            return this.previousParent;
        }
        return null;
    }

    public CelestialBody getDestination() {
        return this.currentParent;
    }

    public boolean startTransit(CelestialBody target, long travelTime) {
        if (!Mothership.canBeOrbited(target) || this.isInTransit() || travelTime > (long)AmunRa.config.mothershipMaxTravelTime) {
            return false;
        }
        AmunRa.LOGGER.debug("Mothership {} will begin transit to {}", new Object[]{this.getID(), target.getName()});
        this.inTransit = true;
        this.travelTimeRemaining = this.travelTimeTotal = travelTime;
        this.previousParent = this.currentParent;
        this.currentParent = target;
        TickHandlerServer.mothershipData.updateOrbitsFor(this.previousParent);
        return true;
    }

    public boolean endTransit() {
        if (!this.inTransit) {
            return false;
        }
        AmunRa.LOGGER.info("Mothership {} finished transit", new Object[]{this.getID()});
        this.previousParent = null;
        this.travelTimeRemaining = 0L;
        this.travelTimeTotal = 0L;
        this.inTransit = false;
        TickHandlerServer.mothershipData.updateOrbitsFor(this.currentParent);
        return true;
    }

    public boolean forceArrival() {
        if (!this.inTransit) {
            return false;
        }
        this.travelTimeRemaining = 0L;
        return true;
    }

    public MothershipWorldProvider getWorldProviderServer() {
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer ws = mcServer.func_71218_a(this.getDimensionID());
        if (ws == null || !(ws.field_73011_w instanceof MothershipWorldProvider)) {
            return null;
        }
        return (MothershipWorldProvider)ws.field_73011_w;
    }

    @SideOnly(value=Side.CLIENT)
    public MothershipWorldProvider getWorldProviderClient() {
        WorldClient ws = ClientProxyCore.mc.field_71441_e;
        if (ws != null && ws.field_73011_w.field_76574_g == this.getDimensionID()) {
            return (MothershipWorldProvider)ws.field_73011_w;
        }
        return null;
    }

    public double getTravelDistanceTo(CelestialBody target) {
        return AstronomyHelper.getDistance(this.currentParent, target);
    }

    public int getScaledTravelTime(int barLength) {
        float remain = this.getRemainingTravelTime();
        float total = this.getTotalTravelTime();
        float relative = remain / total;
        float scaled = (1.0f - relative) * (float)barLength;
        return (int)scaled;
    }

    public PlayerID getOwner() {
        return this.owner;
    }

    public int getID() {
        return this.mothershipId;
    }

    public String getUnlocalizedNamePrefix() {
        return "mothership";
    }

    public static boolean canBeOrbited(CelestialBody body) {
        return AmunRa.config.mothershipMaxTier >= body.getTierRequirement() && body instanceof Planet || body instanceof Moon || body instanceof Star && !AmunRa.config.mothershipBodiesNoOrbit.contains(body.getName());
    }

    public CelestialBody setDimensionInfo(int dimID) {
        return this.setDimensionInfo(dimID, MothershipWorldProvider.class);
    }

    public static CelestialBody findBodyByNamePath(String bodyName) {
        SolarSystem curSys = null;
        CelestialBody body = null;
        CelestialBody moon = null;
        String[] parts = bodyName.split(Pattern.quote(nameSeparator));
        block5: for (int i = 0; i < parts.length; ++i) {
            switch (i) {
                case 0: {
                    curSys = (SolarSystem)GalaxyRegistry.getRegisteredSolarSystems().get(parts[i]);
                    body = curSys.getMainStar();
                    continue block5;
                }
                case 1: {
                    body = (CelestialBody)GalaxyRegistry.getRegisteredPlanets().get(parts[i]);
                    if (((Planet)body).getParentSolarSystem().equals(curSys)) continue block5;
                    throw new RuntimeException("Planet " + body.getName() + " is not in " + bodyName);
                }
                case 2: {
                    moon = (CelestialBody)GalaxyRegistry.getRegisteredMoons().get(parts[i]);
                    if (!((Moon)moon).getParentPlanet().equals((Object)body)) {
                        throw new RuntimeException("Moon " + moon.getName() + " is not in " + bodyName);
                    }
                    return moon;
                }
            }
        }
        if (body == null) {
            throw new RuntimeException("Could not find body for " + bodyName);
        }
        return body;
    }

    public static CelestialBody findBodyByGCBodyName(String bodyName) {
        CelestialBody body;
        Collection sysList = GalaxyRegistry.getRegisteredSolarSystems().values();
        for (SolarSystem sys : sysList) {
            body = sys.getMainStar();
            if (!body.getName().equals(bodyName)) continue;
            return body;
        }
        body = (CelestialBody)GalaxyRegistry.getRegisteredPlanets().get(bodyName);
        if (body != null) {
            return body;
        }
        return (CelestialBody)GalaxyRegistry.getRegisteredMoons().get(bodyName);
    }

    public static CelestialBody findBodyByString(String str) {
        if (str.contains(nameSeparator)) {
            return Mothership.findBodyByNamePath(str);
        }
        return Mothership.findBodyByGCBodyName(str);
    }

    public static Mothership createFromNBT(NBTTagCompound data) {
        if (!data.func_74764_b("id") || !data.func_74764_b("owner")) {
            throw new RuntimeException("Invalid Mothership!");
        }
        int id = data.func_74762_e("id");
        String ownerUUID = data.func_74779_i("owner");
        String ownerName = data.func_74779_i("ownerName");
        Mothership result = new Mothership(id, UUID.fromString(ownerUUID), ownerName);
        String parentId = data.func_74779_i("parentName");
        CelestialBody foundParent = Mothership.findBodyByNamePath(parentId);
        String prevParentId = data.func_74779_i("prevParentName");
        if (!prevParentId.isEmpty()) {
            result.previousParent = Mothership.findBodyByNamePath(prevParentId);
        }
        result.currentParent = foundParent;
        result.inTransit = data.func_74767_n("inTransit");
        result.travelTimeRemaining = data.func_74763_f("travelTimeRemaining");
        result.travelTimeTotal = data.func_74763_f("travelTimeTotal");
        result.setDimensionInfo(data.func_74762_e("dim"));
        result.isReachable = true;
        result.readSettingsFromNBT(data);
        return result;
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74778_a("owner", this.owner.getUUID().toString());
        data.func_74778_a("ownerName", this.owner.getName());
        data.func_74768_a("id", this.mothershipId);
        data.func_74768_a("dim", this.dimensionID);
        String parentId = AstronomyHelper.getOrbitableBodyName(this.currentParent);
        data.func_74778_a("parentName", parentId);
        if (this.previousParent != null) {
            String prevParentId = AstronomyHelper.getOrbitableBodyName(this.previousParent);
            data.func_74778_a("prevParentName", prevParentId);
        }
        data.func_74757_a("inTransit", this.inTransit);
        data.func_74772_a("travelTimeRemaining", this.travelTimeRemaining);
        data.func_74772_a("travelTimeTotal", this.travelTimeTotal);
        this.writeSettingsToNBT(data);
    }

    public void readSettingsFromNBT(NBTTagCompound data) {
        int modeIndex;
        PlayerID pd;
        NBTTagCompound playerData;
        int i;
        if (data.func_74764_b("bodyIcon")) {
            this.setBodyIcon(new ResourceLocation(data.func_74779_i("bodyIcon")));
        }
        if (data.func_74764_b("name")) {
            this.msName = data.func_74779_i("name");
        }
        NBTTagList list = data.func_150295_c("playerList", 10);
        this.playerSetLanding = new HashSet<PlayerID>();
        for (i = 0; i < list.func_74745_c(); ++i) {
            playerData = list.func_150305_b(i);
            pd = new PlayerID(playerData);
            this.playerSetLanding.add(pd);
        }
        if (data.func_74764_b("permissionMode")) {
            modeIndex = data.func_74762_e("permissionMode");
            this.permModeLanding = PermissionMode.values()[modeIndex];
        }
        list = data.func_150295_c("playerListUse", 10);
        this.playerSetUsage = new HashSet<PlayerID>();
        for (i = 0; i < list.func_74745_c(); ++i) {
            playerData = list.func_150305_b(i);
            pd = new PlayerID(playerData);
            this.playerSetUsage.add(pd);
        }
        if (data.func_74764_b("permissionModeUse")) {
            modeIndex = data.func_74762_e("permissionModeUse");
            this.permModeUsage = PermissionMode.values()[modeIndex];
        }
    }

    public void writeSettingsToNBT(NBTTagCompound data) {
        data.func_74778_a("bodyIcon", this.getBodyIcon().toString());
        data.func_74778_a("name", this.msName);
        NBTTagList list = new NBTTagList();
        for (PlayerID p : this.playerSetLanding) {
            list.func_74742_a((NBTBase)p.getNbt());
        }
        data.func_74782_a("playerList", (NBTBase)list);
        list = new NBTTagList();
        for (PlayerID p : this.playerSetUsage) {
            list.func_74742_a((NBTBase)p.getNbt());
        }
        data.func_74782_a("playerListUse", (NBTBase)list);
        data.func_74768_a("permissionMode", this.permModeLanding.ordinal());
        data.func_74768_a("permissionModeUse", this.permModeUsage.ordinal());
    }

    public long getTotalTravelTime() {
        return this.travelTimeTotal;
    }

    public long getRemainingTravelTime() {
        return this.travelTimeRemaining;
    }

    public long modRemainingTravelTime(int mod) {
        this.travelTimeRemaining += (long)mod;
        return this.travelTimeRemaining;
    }

    public void setRemainingTravelTime(int set) {
        this.travelTimeRemaining = set;
    }

    public boolean isPlayerOwner(EntityPlayer player) {
        return this.owner.isSameUser(player);
    }

    public boolean isPlayerOwner(PlayerID player) {
        return this.owner.equals(player);
    }

    public boolean isPlayerUsagePermitted(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.isPlayerPermitted(player, this.permModeUsage);
    }

    public boolean isPlayerLandingPermitted(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return this.isPlayerPermitted(player, this.permModeLanding);
    }

    protected boolean isPlayerPermitted(EntityPlayer player, PermissionMode mode) {
        boolean bl;
        PlayerID playerId = new PlayerID(player);
        switch (this.permModeLanding) {
            case ALL: {
                bl = true;
                break;
            }
            case BLACKLIST: {
                if (this.isPlayerOwner(playerId) || !this.playerSetLanding.contains(playerId)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WHITELIST: {
                if (this.isPlayerOwner(playerId) || this.playerSetLanding.contains(playerId)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case NONE: {
                bl = this.isPlayerOwner(playerId);
                break;
            }
            default: {
                bl = this.isPlayerOwner(playerId);
            }
        }
        return bl;
    }

    public static enum PermissionMode {
        ALL,
        NONE,
        WHITELIST,
        BLACKLIST;

    }
}

