/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.network.packet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.client.gui.GuiARCelestialSelection;
import de.katzenpapst.amunra.client.gui.GuiMothershipSelection;
import de.katzenpapst.amunra.client.gui.GuiMothershipSettings;
import de.katzenpapst.amunra.client.gui.GuiShuttleSelection;
import de.katzenpapst.amunra.crafting.RecipeHelper;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttleFake;
import de.katzenpapst.amunra.helper.PlayerID;
import de.katzenpapst.amunra.helper.ShuttleTeleportHelper;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.mothership.MothershipWorldData;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import de.katzenpapst.amunra.tile.TileEntityGravitation;
import de.katzenpapst.amunra.tile.TileEntityHydroponics;
import de.katzenpapst.amunra.tile.TileEntityShuttleDock;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;

public class PacketSimpleAR
extends Packet
implements IPacket {
    private EnumSimplePacket type;
    private List<Object> data;

    public PacketSimpleAR() {
    }

    public PacketSimpleAR(EnumSimplePacket packetType, Object ... data) {
        this(packetType, Arrays.asList(data));
    }

    public PacketSimpleAR(EnumSimplePacket packetType, List<Object> data) {
        if (packetType.getDecodeClasses().length != data.size()) {
            AmunRa.LOGGER.warn("Found data length different than packet type", (Throwable)new RuntimeException());
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            AmunRa.LOGGER.error("Could not encode data", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        this.type = EnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
            }
            if (buffer.readableBytes() <= 0) return;
        }
        catch (Exception e) {
            AmunRa.LOGGER.error("Error handling simple packet type: " + (Object)((Object)this.type) + " " + buffer, (Throwable)e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (!(player instanceof EntityClientPlayerMP)) {
            return;
        }
        MothershipWorldData mData = TickHandlerServer.mothershipData;
        switch (this.type) {
            case C_OPEN_SHUTTLE_GUI: {
                GuiShuttleSelection gui;
                if (!String.valueOf(this.data.get(0)).equals(FMLClientHandler.instance().getClient().field_71439_g.func_146103_bH().getName())) break;
                String dimensionList = (String)this.data.get(1);
                String[] destinations = dimensionList.split("\\?");
                ArrayList possibleCelestialBodies = Lists.newArrayList();
                HashMap spaceStationData = Maps.newHashMap();
                for (String str : destinations) {
                    CelestialBody celestialBody = ShuttleTeleportHelper.getReachableCelestialBodiesForName(str);
                    if (celestialBody == null && str.contains("$")) {
                        String[] values = str.split("\\$");
                        int homePlanetID = Integer.parseInt(values[4]);
                        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
                            if (satellite.getParentPlanet().getDimensionID() != homePlanetID) continue;
                            celestialBody = satellite;
                            break;
                        }
                        if (!spaceStationData.containsKey(homePlanetID)) {
                            spaceStationData.put(homePlanetID, new HashMap());
                        }
                        ((Map)spaceStationData.get(homePlanetID)).put(values[1], new GuiCelestialSelection.StationDataGUI(values[2], Integer.valueOf(Integer.parseInt(values[3]))));
                    }
                    if (celestialBody == null) continue;
                    possibleCelestialBodies.add(celestialBody);
                }
                if (FMLClientHandler.instance().getClient().field_71441_e == null) break;
                if (!(FMLClientHandler.instance().getClient().field_71462_r instanceof GuiShuttleSelection)) {
                    gui = new GuiShuttleSelection(GuiCelestialSelection.MapMode.TRAVEL, possibleCelestialBodies);
                    gui.spaceStationMap = spaceStationData;
                    FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)gui);
                    break;
                }
                gui = (GuiShuttleSelection)FMLClientHandler.instance().getClient().field_71462_r;
                gui.setPossibleBodies(possibleCelestialBodies);
                gui.spaceStationMap = spaceStationData;
                break;
            }
            case C_UPDATE_MOTHERSHIP_LIST: {
                GuiScreen guiScreen;
                NBTTagCompound nbt = (NBTTagCompound)this.data.get(0);
                if (mData == null) {
                    TickHandlerServer.mothershipData = mData = new MothershipWorldData("ARMothershipData");
                }
                if (!((guiScreen = FMLClientHandler.instance().getClient().field_71462_r) instanceof GuiShuttleSelection)) break;
                GuiShuttleSelection guiShuttleSelection = (GuiShuttleSelection)guiScreen;
                guiShuttleSelection.mothershipListUpdated();
                break;
            }
            case C_NEW_MOTHERSHIP_CREATED: {
                NBTTagCompound nbt = (NBTTagCompound)this.data.get(0);
                Mothership motherShip = Mothership.createFromNBT(nbt);
                motherShip = TickHandlerServer.mothershipData.addMothership(motherShip);
                GuiScreen guiScreen = FMLClientHandler.instance().getClient().field_71462_r;
                if (!(guiScreen instanceof GuiARCelestialSelection)) break;
                GuiARCelestialSelection guiARCelestialSelection = (GuiARCelestialSelection)guiScreen;
                guiARCelestialSelection.newMothershipCreated(motherShip);
                break;
            }
            case C_MOTHERSHIP_CREATION_FAILED: {
                GuiScreen guiScreen = FMLClientHandler.instance().getClient().field_71462_r;
                if (!(guiScreen instanceof GuiARCelestialSelection)) break;
                GuiARCelestialSelection guiARCelestialSelection = (GuiARCelestialSelection)guiScreen;
                guiARCelestialSelection.mothershipCreationFailed();
                break;
            }
            case C_MOTHERSHIP_TRANSIT_STARTED: {
                Mothership motherShip = mData.getByMothershipId((Integer)this.data.get(0));
                CelestialBody targetBody = Mothership.findBodyByNamePath((String)this.data.get(1));
                long travelTime = (Long)this.data.get(2);
                motherShip.startTransit(targetBody, travelTime);
                GuiScreen spaceStationData = FMLClientHandler.instance().getClient().field_71462_r;
                if (!(spaceStationData instanceof GuiShuttleSelection)) break;
                GuiShuttleSelection guiShuttleSelection = (GuiShuttleSelection)spaceStationData;
                guiShuttleSelection.mothershipPositionChanged(motherShip);
                break;
            }
            case C_MOTHERSHIP_TRANSIT_FAILED: {
                break;
            }
            case C_MOTHERSHIP_TRANSIT_ENDED: {
                Mothership motherShip = mData.getByMothershipId((Integer)this.data.get(0));
                motherShip.getWorldProviderClient().endTransit();
                GuiScreen spaceStationData = FMLClientHandler.instance().getClient().field_71462_r;
                if (!(spaceStationData instanceof GuiShuttleSelection)) break;
                GuiShuttleSelection guiShuttleSelection = (GuiShuttleSelection)spaceStationData;
                guiShuttleSelection.mothershipPositionChanged(motherShip);
                break;
            }
            case C_MOTHERSHIP_DATA: {
                int dimId = (Integer)this.data.get(0);
                NBTTagCompound nbt = (NBTTagCompound)this.data.get(1);
                WorldProvider playerWorldProvider = player.func_130014_f_().field_73011_w;
                if (playerWorldProvider.field_76574_g != dimId || !(playerWorldProvider instanceof MothershipWorldProvider)) break;
                MothershipWorldProvider mothershipProvider = (MothershipWorldProvider)playerWorldProvider;
                mothershipProvider.readFromNBT(nbt);
                GuiScreen guiScreen = FMLClientHandler.instance().getClient().field_71462_r;
                if (!(guiScreen instanceof GuiMothershipSelection)) break;
                GuiMothershipSelection guiMothershipSelection = (GuiMothershipSelection)guiScreen;
                guiMothershipSelection.mothershipUpdateRecieved();
                break;
            }
            case C_ADD_MOTHERSHIP_PLAYER_FAILED: {
                if (!(FMLClientHandler.instance().getClient().field_71462_r instanceof GuiMothershipSettings)) break;
                String msg = (String)this.data.get(0);
                String name = (String)this.data.get(1);
                ((GuiMothershipSettings)FMLClientHandler.instance().getClient().field_71462_r).mothershipOperationFailed(GCCoreUtil.translateWithFormat((String)msg, (Object[])new Object[]{name}));
                break;
            }
            case C_MOTHERSHIP_SETTINGS_CHANGED: {
                GuiScreen str;
                int mothershipId = (Integer)this.data.get(0);
                NBTTagCompound nbt = (NBTTagCompound)this.data.get(1);
                Mothership mShip = TickHandlerServer.mothershipData.getByMothershipId(mothershipId);
                mShip.readSettingsFromNBT(nbt);
                if (player.field_70170_p.field_73011_w.field_76574_g != mShip.getDimensionID() || !((str = FMLClientHandler.instance().getClient().field_71462_r) instanceof GuiMothershipSettings)) break;
                GuiMothershipSettings guiMothershipSettings = (GuiMothershipSettings)str;
                guiMothershipSettings.mothershipResponsePacketRecieved();
                break;
            }
            case C_TELEPORT_SHUTTLE_PERMISSION_ERROR: {
                GuiScreen str = FMLClientHandler.instance().getClient().field_71462_r;
                if (!(str instanceof GuiShuttleSelection)) break;
                GuiShuttleSelection guiShuttleSelection = (GuiShuttleSelection)str;
                String owner = (String)this.data.get(0);
                guiShuttleSelection.showMessageBox(GCCoreUtil.translate((String)"gui.message.mothership.permissionError"), GCCoreUtil.translateWithFormat((String)"gui.message.mothership.notAllowed", (Object[])new Object[]{owner}));
                break;
            }
        }
    }

    private PlayerID getPlayerIdByName(WorldServer world, String name) {
        EntityPlayer otherPlayer = world.func_72924_a(name);
        if (otherPlayer == null) {
            return null;
        }
        return new PlayerID(otherPlayer);
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase == null) {
            return;
        }
        GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)playerBase);
        switch (this.type) {
            case S_TELEPORT_SHUTTLE: {
                try {
                    int dim = (Integer)this.data.get(0);
                    AmunRa.LOGGER.info("Will teleport to ({})", new Object[]{dim});
                    if (!(playerBase.field_70170_p instanceof WorldServer)) break;
                    Mothership mShip = TickHandlerServer.mothershipData.getByDimensionId(dim);
                    if (mShip != null && playerBase.field_71093_bK != dim && !mShip.isPlayerLandingPermitted((EntityPlayer)playerBase)) {
                        AmunRa.packetPipeline.sendTo(new PacketSimpleAR(EnumSimplePacket.C_TELEPORT_SHUTTLE_PERMISSION_ERROR, mShip.getOwner().getName()), playerBase);
                        return;
                    }
                    WorldServer world = (WorldServer)playerBase.field_70170_p;
                    ShuttleTeleportHelper.transferEntityToDimension((Entity)playerBase, dim, world);
                    stats.teleportCooldown = 10;
                    GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_CLOSE_GUI, new Object[0]), playerBase);
                }
                catch (Exception e) {
                    AmunRa.LOGGER.error("Error occurred when attempting to transfer entity to dimension: " + this.data.get(0), (Throwable)e);
                }
                break;
            }
            case S_CANCEL_SHUTTLE: {
                if (!(playerBase.field_70170_p instanceof WorldServer)) break;
                if (playerBase.field_70154_o instanceof EntityShuttleFake) {
                    WorldServer world = (WorldServer)playerBase.field_70170_p;
                    ShuttleTeleportHelper.transferEntityToDimension((Entity)playerBase, world.field_73011_w.field_76574_g, world);
                    stats.teleportCooldown = 10;
                }
                GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_CLOSE_GUI, new Object[0]), playerBase);
                break;
            }
            case S_CREATE_MOTHERSHIP: {
                String bodyName = (String)this.data.get(0);
                CelestialBody targetBody = Mothership.findBodyByNamePath(bodyName);
                boolean isSuccessful = false;
                if (Mothership.canBeOrbited(targetBody) && (AmunRa.config.maxNumMotherships < 0 || TickHandlerServer.mothershipData.getNumMothershipsForPlayer((EntityPlayer)playerBase) < AmunRa.config.maxNumMotherships) && (playerBase.field_71075_bZ.field_75098_d || RecipeHelper.mothershipRecipe.matches((EntityPlayer)playerBase, true))) {
                    TickHandlerServer.mothershipData.registerNewMothership((EntityPlayer)playerBase, targetBody);
                    isSuccessful = true;
                }
                if (isSuccessful) break;
                AmunRa.packetPipeline.sendTo(new PacketSimpleAR(EnumSimplePacket.C_MOTHERSHIP_CREATION_FAILED, new Object[0]), playerBase);
                break;
            }
            case S_MOTHERSHIP_TRANSIT_START: {
                Integer mothershipId = (int)((Integer)this.data.get(0));
                String bodyName = (String)this.data.get(1);
                Mothership mShip = TickHandlerServer.mothershipData.getByMothershipId(mothershipId);
                CelestialBody targetBody = Mothership.findBodyByNamePath(bodyName);
                MothershipWorldProvider provider = mShip.getWorldProviderServer();
                if (provider != null && provider.startTransit(targetBody, false)) {
                    AmunRa.packetPipeline.sendToAll(new PacketSimpleAR(EnumSimplePacket.C_MOTHERSHIP_TRANSIT_STARTED, mothershipId, bodyName, mShip.getTotalTravelTime()));
                    break;
                }
                AmunRa.packetPipeline.sendToDimension(new PacketSimpleAR(EnumSimplePacket.C_MOTHERSHIP_TRANSIT_FAILED, mothershipId), mShip.getDimensionID());
                break;
            }
            case S_MOTHERSHIP_UPDATE: {
                int dimId = (Integer)this.data.get(0);
                MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
                WorldServer world = mcServer.func_71218_a(dimId);
                WorldProvider worldProvider = world.field_73011_w;
                if (!(worldProvider instanceof MothershipWorldProvider)) break;
                MothershipWorldProvider mothershipProvider = (MothershipWorldProvider)worldProvider;
                mothershipProvider.asyncSendMothershipDataToClient();
                break;
            }
            case S_SET_MOTHERSHIP_SETTINGS: {
                Integer mothershipId = (int)((Integer)this.data.get(0));
                NBTTagCompound nbt = (NBTTagCompound)this.data.get(1);
                Mothership mShip = TickHandlerServer.mothershipData.getByMothershipId(mothershipId);
                mShip.readSettingsFromNBT(nbt);
                nbt = new NBTTagCompound();
                mShip.writeSettingsToNBT(nbt);
                AmunRa.packetPipeline.sendToAll(new PacketSimpleAR(EnumSimplePacket.C_MOTHERSHIP_SETTINGS_CHANGED, mothershipId, nbt));
                TickHandlerServer.mothershipData.func_76185_a();
                break;
            }
            case S_ADD_MOTHERSHIP_PLAYER: {
                Integer mothershipId = (int)((Integer)this.data.get(0));
                String name = (String)this.data.get(1);
                int type = (Integer)this.data.get(2);
                Mothership mShip = TickHandlerServer.mothershipData.getByMothershipId(mothershipId);
                if (!(playerBase.field_70170_p instanceof WorldServer)) break;
                WorldServer world = (WorldServer)playerBase.field_70170_p;
                PlayerID playerId = this.getPlayerIdByName(world, name);
                if (playerId != null) {
                    if (playerId.isSameUser(player)) {
                        AmunRa.packetPipeline.sendTo(new PacketSimpleAR(EnumSimplePacket.C_ADD_MOTHERSHIP_PLAYER_FAILED, "tile.mothershipSettings.permission.addUserErrorSelf", name), playerBase);
                        break;
                    }
                    if (type == 0) {
                        mShip.addPlayerToListLanding(playerId);
                    } else if (type == 1) {
                        mShip.addPlayerToListUsage(playerId);
                    }
                    NBTTagCompound nbt = new NBTTagCompound();
                    mShip.writeSettingsToNBT(nbt);
                    AmunRa.packetPipeline.sendToAll(new PacketSimpleAR(EnumSimplePacket.C_MOTHERSHIP_SETTINGS_CHANGED, mothershipId, nbt));
                    TickHandlerServer.mothershipData.func_76185_a();
                    break;
                }
                AmunRa.packetPipeline.sendTo(new PacketSimpleAR(EnumSimplePacket.C_ADD_MOTHERSHIP_PLAYER_FAILED, "tile.mothershipSettings.permission.addUserError", name), playerBase);
                break;
            }
            case S_DOCK_OPERATION: {
                int x = (Integer)this.data.get(0);
                int y = (Integer)this.data.get(1);
                int z = (Integer)this.data.get(2);
                int op = (Integer)this.data.get(3);
                TileEntity tileEntity = playerBase.field_70170_p.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityShuttleDock)) break;
                TileEntityShuttleDock tileShuttleDock = (TileEntityShuttleDock)tileEntity;
                tileShuttleDock.performDockOperation(op, playerBase);
                break;
            }
            case S_HYDROPONICS_OPERATION: {
                int x = (Integer)this.data.get(0);
                int y = (Integer)this.data.get(1);
                int z = (Integer)this.data.get(2);
                int op = (Integer)this.data.get(3);
                TileEntity tileEntity = playerBase.field_70170_p.func_147438_o(x, y, z);
                if (!(tileEntity instanceof TileEntityHydroponics)) break;
                TileEntityHydroponics tileHydroponics = (TileEntityHydroponics)tileEntity;
                tileHydroponics.performOperation(op, playerBase);
                break;
            }
            case S_ARTIFICIAL_GRAVITY_SETTINGS: {
                BlockVec3 pos = (BlockVec3)this.data.get(0);
                BlockVec3 min = (BlockVec3)this.data.get(1);
                BlockVec3 max = (BlockVec3)this.data.get(2);
                double strength = (Double)this.data.get(3);
                AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
                TileEntity tileEntity = pos.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityGravitation)) break;
                TileEntityGravitation tileGravitation = (TileEntityGravitation)tileEntity;
                tileGravitation.setGravityBox(box);
                tileGravitation.setGravityForce(strength);
                tileGravitation.updateEnergyConsumption();
                tileEntity.func_70296_d();
                playerBase.field_70170_p.func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                break;
            }
        }
    }

    public void func_148837_a(PacketBuffer data) {
        this.decodeInto(null, (ByteBuf)data);
    }

    public void func_148840_b(PacketBuffer data) {
        this.encodeInto(null, (ByteBuf)data);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler handler) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum EnumSimplePacket {
        S_TELEPORT_SHUTTLE(Side.SERVER, Integer.class),
        S_CANCEL_SHUTTLE(Side.SERVER, new Class[0]),
        S_CREATE_MOTHERSHIP(Side.SERVER, String.class),
        S_MOTHERSHIP_TRANSIT_START(Side.SERVER, Integer.class, String.class),
        S_MOTHERSHIP_UPDATE(Side.SERVER, Integer.class),
        S_SET_MOTHERSHIP_SETTINGS(Side.SERVER, Integer.class, NBTTagCompound.class),
        S_ADD_MOTHERSHIP_PLAYER(Side.SERVER, Integer.class, String.class, Integer.class),
        S_DOCK_OPERATION(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class),
        S_HYDROPONICS_OPERATION(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class),
        S_ARTIFICIAL_GRAVITY_SETTINGS(Side.SERVER, BlockVec3.class, BlockVec3.class, BlockVec3.class, Double.class),
        C_OPEN_SHUTTLE_GUI(Side.CLIENT, String.class, String.class),
        C_UPDATE_MOTHERSHIP_LIST(Side.CLIENT, NBTTagCompound.class),
        C_NEW_MOTHERSHIP_CREATED(Side.CLIENT, NBTTagCompound.class),
        C_MOTHERSHIP_CREATION_FAILED(Side.CLIENT, new Class[0]),
        C_MOTHERSHIP_TRANSIT_STARTED(Side.CLIENT, Integer.class, String.class, Long.class),
        C_MOTHERSHIP_TRANSIT_FAILED(Side.CLIENT, Integer.class),
        C_MOTHERSHIP_TRANSIT_ENDED(Side.CLIENT, Integer.class),
        C_MOTHERSHIP_DATA(Side.CLIENT, Integer.class, NBTTagCompound.class),
        C_ADD_MOTHERSHIP_PLAYER_FAILED(Side.CLIENT, String.class, String.class),
        C_MOTHERSHIP_SETTINGS_CHANGED(Side.CLIENT, Integer.class, NBTTagCompound.class),
        C_TELEPORT_SHUTTLE_PERMISSION_ERROR(Side.CLIENT, String.class),
        C_TELEPORT_SHUTTLE_FAIL(Side.CLIENT, String.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private EnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

