/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.tile;

import cpw.mods.fml.relauncher.Side;
import de.katzenpapst.amunra.client.sound.ISoundableTile;
import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.mob.DamageSourceAR;
import de.katzenpapst.amunra.mothership.fueldisplay.MothershipFuelRequirements;
import de.katzenpapst.amunra.tile.ITileMothershipEngine;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineBooster;
import de.katzenpapst.amunra.vec.Vector3int;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import net.minecraft.block.Block;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityMothershipEngineAbstract
extends TileBaseElectricBlockWithInventory
implements ITileMothershipEngine,
IFluidHandler,
ISidedInventory,
IInventory,
ISoundableTile {
    protected Fluid fuel;
    protected int numBoosters = 0;
    protected final int tankCapacity = 12000;
    protected final int exhaustCheckLength = 5;
    protected boolean needsUpdate = true;
    protected boolean loadedFuelLastTick = false;
    protected boolean isInUseForTransit = false;
    protected boolean shouldPlaySound = false;
    protected boolean soundStarted = false;
    protected boolean isObstructed = false;
    protected AxisAlignedBB exhaustBB = null;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    protected ItemStack[] containingItems;
    public static final int MAX_LENGTH = 10;
    protected BlockMetaPair boosterBlock;
    protected PositionedSoundRecord leSound;

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.fuelTank.getCapacity());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.containingItems = this.readStandardItemsFromNBT(compound);
        if (compound.func_74764_b("numBoosters")) {
            this.numBoosters = compound.func_74762_e("numBoosters");
        }
        this.fuelTank.setCapacity(this.getTankCapacity());
        if (compound.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(compound.func_74775_l("fuelTank"));
        }
        if (compound.func_74764_b("needsUpdate")) {
            this.needsUpdate = compound.func_74767_n("needsUpdate");
        }
        if (compound.func_74764_b("usedForTransit")) {
            this.isInUseForTransit = compound.func_74767_n("usedForTransit");
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeStandardItemsToNBT(compound);
        if (this.fuelTank.getFluid() != null) {
            compound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        compound.func_74768_a("numBoosters", this.numBoosters);
        compound.func_74757_a("needsUpdate", this.needsUpdate);
        compound.func_74757_a("usedForTransit", this.isInUseForTransit);
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    protected abstract int getTankCapacity();

    public Vector3 getCenterPosition() {
        return new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
    }

    public boolean isObstructed() {
        this.checkBlocksInWay();
        return this.isObstructed;
    }

    public Vector3 getExhaustDirection() {
        switch (this.getRotationMeta()) {
            case 0: {
                return new Vector3(0.0, 0.0, -1.0);
            }
            case 1: {
                return new Vector3(1.0, 0.0, 0.0);
            }
            case 2: {
                return new Vector3(0.0, 0.0, 1.0);
            }
            case 3: {
                return new Vector3(-1.0, 0.0, 0.0);
            }
        }
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getExhaustPosition(double scale) {
        double random1 = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.1f * scale;
        double random2 = this.field_145850_b.field_73012_v.nextGaussian() * (double)0.1f * scale;
        double offset = 0.4;
        Vector3 result = new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        switch (this.getRotationMeta()) {
            case 0: {
                result.x += random1;
                result.y += random2;
                result.z -= 0.4;
                break;
            }
            case 1: {
                result.x += 0.4;
                result.y += random1;
                result.z += random2;
                break;
            }
            case 2: {
                result.x += random1;
                result.y += random2;
                result.z += 0.4;
                break;
            }
            case 3: {
                result.x -= 0.4;
                result.y += random1;
                result.z += random2;
            }
        }
        return result;
    }

    protected void startSound() {
        this.shouldPlaySound = true;
        this.soundStarted = true;
    }

    protected void stopSound() {
        this.shouldPlaySound = false;
        this.soundStarted = false;
    }

    protected AxisAlignedBB getExhaustAABB() {
        Vector3 exDir = this.getExhaustDirection();
        Vector3 startPos = this.getCenterPosition();
        Vector3 minVec = new Vector3(0.0, 0.0, 0.0);
        Vector3 maxVec = new Vector3(0.0, 0.0, 0.0);
        minVec.y = startPos.y - 0.5;
        maxVec.y = startPos.y + 0.5;
        if (exDir.x != 0.0) {
            minVec.z = startPos.z - 0.5;
            maxVec.z = startPos.z + 0.5;
            if (exDir.x < 0.0) {
                minVec.x = startPos.x - (double)this.exhaustCheckLength - 0.5;
                maxVec.x = startPos.x - 0.5;
            } else {
                minVec.x = startPos.x + 0.5;
                maxVec.x = startPos.x + 0.5 + (double)this.exhaustCheckLength;
            }
        } else if (exDir.z != 0.0) {
            minVec.x = startPos.x - 0.5;
            maxVec.x = startPos.x + 0.5;
            if (exDir.z < 0.0) {
                minVec.z = startPos.z - (double)this.exhaustCheckLength - 0.5;
                maxVec.z = startPos.z - 0.5;
            } else {
                minVec.z = startPos.z + 0.5;
                maxVec.z = startPos.z + 0.5 + (double)this.exhaustCheckLength;
            }
        } else {
            return null;
        }
        return AxisAlignedBB.func_72330_a((double)minVec.x, (double)minVec.y, (double)minVec.z, (double)maxVec.x, (double)maxVec.y, (double)maxVec.z);
    }

    protected void checkBlocksInWay() {
        Vector3 exDir = this.getExhaustDirection();
        Vector3 blockPos = new Vector3((TileEntity)this);
        this.isObstructed = false;
        for (int i = 0; i < this.exhaustCheckLength; ++i) {
            blockPos.translate(exDir);
            Block b = blockPos.getBlock((IBlockAccess)this.field_145850_b);
            if (b.isAir((IBlockAccess)this.field_145850_b, blockPos.intX(), blockPos.intY(), blockPos.intZ())) continue;
            this.isObstructed = true;
            return;
        }
    }

    protected void checkEntitiesInWay() {
        if (this.exhaustBB == null) {
            this.exhaustBB = this.getExhaustAABB();
            if (this.exhaustBB == null) {
                return;
            }
        }
        Vector3 myPos = this.getCenterPosition();
        Vector3 exhaustDir = this.getExhaustDirection();
        List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, this.exhaustBB);
        if (list != null) {
            for (EntityLivingBase entity : list) {
                entity.func_70015_d(5);
                Vector3 entityPos = new Vector3((Entity)entity);
                double factor = entityPos.distance(myPos);
                entityPos = exhaustDir.clone().scale(0.2 / factor);
                float damage = (float)(10.0 / factor);
                entity.func_70097_a(DamageSourceAR.dsEngine, damage);
                entity.func_70024_g(entityPos.x, entityPos.y, entityPos.z);
            }
        }
    }

    protected void spawnParticles() {
    }

    protected abstract boolean isItemFuel(ItemStack var1);

    protected void processFluids() {
        this.loadedFuelLastTick = false;
        ItemStack canister = this.containingItems[0];
        if (canister != null && this.isItemFuel(canister)) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)canister);
            int fluidAmount = this.fuelTank.getFluid() == null ? 0 : this.fuelTank.getFluid().amount;
            int spaceForFluid = this.fuelTank.getCapacity() - fluidAmount;
            if (canister.func_77973_b() instanceof IFluidContainerItem) {
                FluidStack drained = ((IFluidContainerItem)canister.func_77973_b()).drain(canister, spaceForFluid, true);
                if (drained != null && drained.amount > 0) {
                    ItemStack canisterNew;
                    this.fuelTank.fill(new FluidStack(this.fuel, drained.amount), true);
                    liquid = ((IFluidContainerItem)canister.func_77973_b()).getFluid(canister);
                    if ((liquid == null || liquid.amount == 0) && (canisterNew = FluidContainerRegistry.drainFluidContainer((ItemStack)canister)) != null) {
                        this.containingItems[0] = canisterNew;
                    }
                }
            } else {
                int capacity = FluidContainerRegistry.getContainerCapacity((ItemStack)canister);
                if (spaceForFluid >= capacity) {
                    this.fuelTank.fill(new FluidStack(this.fuel, capacity), true);
                    ItemStack canisterNew = FluidContainerRegistry.drainFluidContainer((ItemStack)canister);
                    if (canisterNew != null) {
                        this.containingItems[0] = canisterNew;
                    }
                }
            }
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isInUseForTransit) {
            if (!this.soundStarted) {
                this.startSound();
            }
            this.spawnParticles();
            this.checkEntitiesInWay();
        } else {
            if (this.soundStarted) {
                this.stopSound();
            }
            this.exhaustBB = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.needsUpdate) {
                this.updateMultiblock();
                this.needsUpdate = false;
            }
            this.processFluids();
        }
    }

    public boolean canUpdate() {
        return true;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public int getRotationMeta(int meta) {
        return (meta & 0xC) >> 2;
    }

    public int getRotationMeta() {
        return (this.func_145832_p() & 0xC) >> 2;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        int metadata = this.getRotationMeta();
        return !CoordHelper.rotateForgeDirection(ForgeDirection.NORTH, metadata).equals((Object)from);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (this.canFill(from, resource.getFluid())) {
            used = this.fuelTank.fill(resource, doFill);
        }
        return used;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        int metadata = this.getRotationMeta();
        if (CoordHelper.rotateForgeDirection(ForgeDirection.NORTH, metadata).equals((Object)from)) {
            return null;
        }
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
    }

    public boolean func_145818_k_() {
        return true;
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return this.func_94041_b(p_102007_1_, p_102007_2_);
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return p_102008_1_ == 0;
    }

    public Vector3int getLastBoosterPosition() {
        switch (this.getRotationMeta()) {
            case 0: {
                return new Vector3int(this.field_145851_c, this.field_145848_d, this.field_145849_e + this.numBoosters);
            }
            case 1: {
                return new Vector3int(this.field_145851_c - this.numBoosters, this.field_145848_d, this.field_145849_e);
            }
            case 2: {
                return new Vector3int(this.field_145851_c, this.field_145848_d, this.field_145849_e - this.numBoosters);
            }
            case 3: {
                return new Vector3int(this.field_145851_c + this.numBoosters, this.field_145848_d, this.field_145849_e);
            }
        }
        return new Vector3int(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack var3;
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count) {
            var3 = this.containingItems[index];
            this.containingItems[index] = null;
        } else {
            var3 = this.containingItems[index].func_77979_a(count);
            if (this.containingItems[index].field_77994_a == 0) {
                this.containingItems[index] = null;
            }
        }
        return var3;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack var2 = this.containingItems[index];
            this.containingItems[index] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0) {
            return true;
        }
        Vector3int lastBooster = this.getLastBoosterPosition();
        if (lastBooster.x == this.field_145851_c) {
            float minZ = Math.min(lastBooster.z, this.field_145849_e);
            float maxZ = Math.max(lastBooster.z, this.field_145849_e);
            if (player.field_70161_v < (double)minZ) {
                return (double)(this.field_145851_c * this.field_145851_c) + Math.pow((double)minZ - player.field_70161_v, 2.0) <= 64.0;
            }
            if (player.field_70161_v > (double)maxZ) {
                return (double)(this.field_145851_c * this.field_145851_c) + Math.pow(player.field_70161_v - (double)maxZ, 2.0) <= 64.0;
            }
            return Math.abs(player.field_70165_t - (double)this.field_145851_c) <= 8.0;
        }
        float minX = Math.min(lastBooster.x, this.field_145851_c);
        float maxX = Math.max(lastBooster.x, this.field_145851_c);
        if (player.field_70165_t < (double)minX) {
            return (double)(this.field_145849_e * this.field_145849_e) + Math.pow((double)minX - player.field_70165_t, 2.0) <= 64.0;
        }
        if (player.field_70165_t > (double)maxX) {
            return (double)(this.field_145849_e * this.field_145849_e) + Math.pow(player.field_70165_t - (double)maxX, 2.0) <= 64.0;
        }
        return Math.abs(player.field_70161_v - (double)this.field_145849_e) <= 8.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int getNumBoosters() {
        return this.numBoosters;
    }

    public BlockMetaPair getBoosterBlock() {
        return this.boosterBlock;
    }

    protected boolean attachBooster(int x, int y, int z, boolean notifyClient) {
        BlockMetaPair booster = this.getBoosterBlock();
        Block worldBlock = this.field_145850_b.func_147439_a(x, y, z);
        int worldMeta = this.field_145850_b.func_72805_g(x, y, z);
        TileEntity worldTile = this.field_145850_b.func_147438_o(x, y, z);
        if (!booster.getBlock().equals(worldBlock) || booster.getMetadata() != worldMeta || worldTile == null || !(worldTile instanceof TileEntityMothershipEngineBooster) || ((TileEntityMothershipEngineBooster)worldTile).hasMaster()) {
            return false;
        }
        ((TileEntityMothershipEngineBooster)worldTile).setMaster(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ++this.numBoosters;
        if (notifyClient) {
            this.updateBooster(x, y, z);
        }
        return true;
    }

    protected void updateBooster(int x, int y, int z) {
        TileEntity worldTile = this.field_145850_b.func_147438_o(x, y, z);
        if (worldTile != null) {
            worldTile.func_70296_d();
            this.field_145850_b.func_147471_g(x, y, z);
        }
    }

    protected boolean detachBooster(int x, int y, int z, boolean notifyClient) {
        BlockMetaPair booster = this.getBoosterBlock();
        Block worldBlock = this.field_145850_b.func_147439_a(x, y, z);
        int worldMeta = this.field_145850_b.func_72805_g(x, y, z);
        TileEntity worldTile = this.field_145850_b.func_147438_o(x, y, z);
        if (!(booster.getBlock().equals(worldBlock) && booster.getMetadata() == worldMeta && worldTile != null && worldTile instanceof TileEntityMothershipEngineBooster && ((TileEntityMothershipEngineBooster)worldTile).isMaster(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
            return false;
        }
        ((TileEntityMothershipEngineBooster)worldTile).clearMaster();
        if (notifyClient) {
            this.updateBooster(x, y, z);
        }
        return true;
    }

    public boolean isPartOfMultiBlock(int x, int y, int z) {
        switch (this.getRotationMeta()) {
            case 0: {
                return this.field_145851_c == x && this.field_145848_d == y && this.field_145849_e + this.numBoosters >= z && this.field_145849_e + 1 <= z;
            }
            case 1: {
                return this.field_145849_e == z && this.field_145848_d == y && this.field_145851_c - this.numBoosters <= x && this.field_145851_c - 1 >= x;
            }
            case 2: {
                return this.field_145851_c == x && this.field_145848_d == y && this.field_145849_e - this.numBoosters <= z && this.field_145849_e - 1 >= z;
            }
            case 3: {
                return this.field_145849_e == z && this.field_145848_d == y && this.field_145851_c + this.numBoosters >= x && this.field_145851_c + 1 <= x;
            }
        }
        return false;
    }

    public void resetMultiblock() {
        this.resetMultiblockInternal(true);
    }

    protected void resetMultiblockInternal(boolean notifyClient) {
        if (this.numBoosters == 0) {
            this.numBoosters = 10;
        }
        switch (this.getRotationMeta()) {
            case 0: {
                for (int i = 0; i < this.numBoosters; ++i) {
                    this.detachBooster(this.field_145851_c, this.field_145848_d, this.field_145849_e + i + 1, notifyClient);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.numBoosters; ++i) {
                    this.detachBooster(this.field_145851_c - i - 1, this.field_145848_d, this.field_145849_e, notifyClient);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.numBoosters; ++i) {
                    this.detachBooster(this.field_145851_c, this.field_145848_d, this.field_145849_e - i - 1, notifyClient);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.numBoosters; ++i) {
                    this.detachBooster(this.field_145851_c + i + 1, this.field_145848_d, this.field_145849_e, notifyClient);
                }
                break;
            }
        }
        this.numBoosters = 0;
        this.fuelTank.setCapacity(0);
    }

    public void scheduleUpdate() {
        this.needsUpdate = true;
    }

    public void updateMultiblock() {
        int prevNumBlocks = this.numBoosters;
        this.resetMultiblockInternal(false);
        this.createMultiblockInternal(false);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.notifyClientAboutBoosters(Math.max(prevNumBlocks, this.numBoosters));
    }

    protected void notifyClientAboutBoosters(int prevNumBoosters) {
        switch (this.getRotationMeta()) {
            case 0: {
                for (int i = 0; i < prevNumBoosters; ++i) {
                    this.updateBooster(this.field_145851_c, this.field_145848_d, this.field_145849_e + i + 1);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < prevNumBoosters; ++i) {
                    this.updateBooster(this.field_145851_c - i - 1, this.field_145848_d, this.field_145849_e);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < prevNumBoosters; ++i) {
                    this.updateBooster(this.field_145851_c, this.field_145848_d, this.field_145849_e - i - 1);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < prevNumBoosters; ++i) {
                    this.updateBooster(this.field_145851_c + i + 1, this.field_145848_d, this.field_145849_e);
                }
                break;
            }
        }
    }

    public void createMultiblock() {
        this.createMultiblockInternal(true);
    }

    protected void createMultiblockInternal(boolean notifyClient) {
        this.numBoosters = 0;
        switch (this.getRotationMeta()) {
            case 0: {
                for (int i = 0; i < 10 && this.attachBooster(this.field_145851_c, this.field_145848_d, this.field_145849_e + i + 1, notifyClient); ++i) {
                }
                break;
            }
            case 1: {
                for (int i = 0; i < 10 && this.attachBooster(this.field_145851_c - i - 1, this.field_145848_d, this.field_145849_e, notifyClient); ++i) {
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 10 && this.attachBooster(this.field_145851_c, this.field_145848_d, this.field_145849_e - i - 1, notifyClient); ++i) {
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 10 && this.attachBooster(this.field_145851_c + i + 1, this.field_145848_d, this.field_145849_e, notifyClient); ++i) {
                }
                break;
            }
        }
        this.fuelTank.setCapacity(this.getTankCapacity());
        if (this.fuelTank.getCapacity() < this.fuelTank.getFluidAmount()) {
            this.fuelTank.drain(this.fuelTank.getFluidAmount() - this.fuelTank.getCapacity(), true);
        }
    }

    @Override
    public void beginTransit(long duration) {
        this.isInUseForTransit = true;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public abstract MothershipFuelRequirements getFuelRequirements(long var1);

    @Override
    public void endTransit() {
        this.isInUseForTransit = false;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean isInUse() {
        return this.isInUseForTransit;
    }

    public void setDisabled(int index, boolean disabled) {
        if (!this.isInUse()) {
            super.setDisabled(index, disabled);
        }
    }

    public ForgeDirection getElectricInputDirection() {
        return null;
    }

    public ItemStack getBatteryInSlot() {
        return null;
    }

    @Override
    public boolean isDonePlaying() {
        return !this.isInUseForTransit;
    }

    @Override
    public abstract double getThrust();

    public void slowDischarge() {
    }

    @Override
    public abstract boolean canRunForDuration(long var1);

    @Override
    public int getDirection() {
        return this.getRotationMeta(this.func_145832_p());
    }

    @Override
    public boolean isEnabled() {
        return !this.getDisabled(0) && !this.isObstructed();
    }

    public void updateFacing() {
        this.resetMultiblock();
        this.scheduleUpdate();
        super.updateFacing();
    }
}

