/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world;

import de.katzenpapst.amunra.vec.Vector3int;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldHelper {
    public static BlockMetaPair getBlockMetaPair(World world, int x, int y, int z) {
        return new BlockMetaPair(world.func_147439_a(x, y, z), (byte)world.func_72805_g(x, y, z));
    }

    public static boolean isBlockMetaPair(World world, int x, int y, int z, BlockMetaPair bmp) {
        return world.func_147439_a(x, y, z) == bmp.getBlock() && world.func_72805_g(x, y, z) == bmp.getMetadata();
    }

    public static void dropItemInWorld(World world, ItemStack stack, double x, double y, double z, double motionX, double motionY, double motionZ) {
        EntityItem itemEntity = new EntityItem(world, x, y, z, new ItemStack(stack.func_77973_b(), stack.field_77994_a, stack.func_77960_j()));
        if (stack.func_77942_o()) {
            itemEntity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        itemEntity.field_70159_w = motionX;
        itemEntity.field_70181_x = motionY;
        itemEntity.field_70179_y = motionZ;
        world.func_72838_d((Entity)itemEntity);
    }

    public static void dropItemInWorld(World world, ItemStack stack, double x, double y, double z) {
        WorldHelper.dropItemInWorld(world, stack, x, y, z, 0.0, 0.0, 0.0);
    }

    public static void dropItemInWorld(World world, ItemStack stack, Entity atEntity) {
        WorldHelper.dropItemInWorld(world, stack, atEntity.field_70165_t, atEntity.field_70163_u, atEntity.field_70161_v, 0.0, 0.0, 0.0);
    }

    public static void setFireToBlock(World worldObj, int x, int y, int z, double fromX, double fromY, double fromZ) {
        double deltaX = (double)x + 0.5 - fromX;
        double deltaY = (double)y + 0.5 - fromY;
        double deltaZ = (double)z + 0.5 - fromZ;
        double deltaXabs = Math.abs(deltaX);
        double deltaYabs = Math.abs(deltaY);
        double deltaZabs = Math.abs(deltaZ);
        if (deltaXabs > deltaYabs) {
            if (deltaXabs > deltaZabs) {
                if (deltaX < 0.0) {
                    WorldHelper.setBlockIfFree(worldObj, x + 1, y, z, (Block)Blocks.field_150480_ab, 0);
                } else {
                    WorldHelper.setBlockIfFree(worldObj, x - 1, y, z, (Block)Blocks.field_150480_ab, 0);
                }
            } else if (deltaZ < 0.0) {
                WorldHelper.setBlockIfFree(worldObj, x, y, z + 1, (Block)Blocks.field_150480_ab, 0);
            } else {
                WorldHelper.setBlockIfFree(worldObj, x, y, z - 1, (Block)Blocks.field_150480_ab, 0);
            }
        } else if (deltaYabs > deltaZabs) {
            if (deltaY < 0.0) {
                WorldHelper.setBlockIfFree(worldObj, x, y + 1, z, (Block)Blocks.field_150480_ab, 0);
            } else {
                WorldHelper.setBlockIfFree(worldObj, x, y - 1, z, (Block)Blocks.field_150480_ab, 0);
            }
        } else if (deltaZ < 0.0) {
            WorldHelper.setBlockIfFree(worldObj, x, y, z + 1, (Block)Blocks.field_150480_ab, 0);
        } else {
            WorldHelper.setBlockIfFree(worldObj, x, y, z - 1, (Block)Blocks.field_150480_ab, 0);
        }
    }

    public static void setBlockIfFree(World worldObj, int x, int y, int z, Block block, int meta) {
        Block old = worldObj.func_147439_a(x, y, z);
        if (old == Blocks.field_150350_a) {
            worldObj.func_147465_d(x, y, z, block, meta, 3);
        }
    }

    public static boolean isSolid(World worldObj, int x, int y, int z, boolean checkTop) {
        Block b = worldObj.func_147439_a(x, y, z);
        if (checkTop) {
            return World.func_147466_a((IBlockAccess)worldObj, (int)x, (int)y, (int)z);
        }
        return !b.func_149655_b((IBlockAccess)worldObj, x, y, z) && b.func_149688_o().func_76220_a();
    }

    public static boolean isSolid(World worldObj, int x, int y, int z) {
        return WorldHelper.isSolid(worldObj, x, y, z, false);
    }

    public static boolean isNonSolid(World worldObj, int x, int y, int z) {
        Block b = worldObj.func_147439_a(x, y, z);
        return b.isAir((IBlockAccess)worldObj, x, y, z) || b.func_149655_b((IBlockAccess)worldObj, x, y, z) && !b.func_149688_o().func_76224_d() && !b.func_149688_o().func_76220_a();
    }

    public static Vector3int getHighestNonEmptyBlock(World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (int y = maxY; y >= minY; --y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (WorldHelper.isNonSolid(world, x, y, z)) continue;
                    return new Vector3int(x, y, z);
                }
            }
        }
        return null;
    }
}

