/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.me;

import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import com.glodblock.github.client.me.FluidRepo;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import com.glodblock.github.util.FluidSorters;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class EssentiaRepo
extends FluidRepo {
    public EssentiaRepo(IScrollSource src, ISortSource sortSrc) {
        super(src, sortSrc);
    }

    @Override
    public void updateView() {
        Pattern m;
        String innerSearch;
        this.view.clear();
        this.dsp.clear();
        this.view.ensureCapacity(this.list.size());
        this.dsp.ensureCapacity(this.list.size());
        Enum viewMode = this.sortSrc.getSortDisplay();
        Enum searchMode = AEConfig.instance.settings.getSetting(Settings.SEARCH_MODE);
        if (searchMode == SearchBoxMode.NEI_AUTOSEARCH || searchMode == SearchBoxMode.NEI_MANUAL_SEARCH) {
            this.updateNEI(this.searchString);
        }
        if ((innerSearch = this.searchString).startsWith("@")) {
            innerSearch = innerSearch.substring(1);
        }
        try {
            m = Pattern.compile(innerSearch.toLowerCase(), 2);
        }
        catch (Throwable ignore) {
            try {
                m = Pattern.compile(Pattern.quote(innerSearch.toLowerCase()), 2);
            }
            catch (Throwable __) {
                return;
            }
        }
        for (IAEItemStack is : this.list) {
            Object fluid;
            if (this.myPartitionList != null && !this.myPartitionList.isListed((IAEStack)is) || viewMode == ViewItems.CRAFTABLE && !is.isCraftable()) continue;
            if (viewMode == ViewItems.CRAFTABLE) {
                is = is.copy();
                is.setStackSize(0L);
            }
            if (viewMode == ViewItems.STORED && is.getStackSize() == 0L || !AspectUtil.isEssentiaGas((Fluid)(fluid = ItemFluidDrop.getAeFluidStack(is).getFluid())) || !m.matcher(fluid.getLocalizedName().toLowerCase()).find()) continue;
            this.view.add(is);
        }
        Enum SortBy = this.sortSrc.getSortBy();
        Enum SortDir2 = this.sortSrc.getSortDir();
        FluidSorters.setDirection((SortDir)SortDir2);
        FluidSorters.init();
        if (SortBy == SortOrder.MOD) {
            this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_MOD);
        } else if (SortBy == SortOrder.AMOUNT) {
            this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_SIZE);
        } else if (SortBy == SortOrder.INVTWEAKS) {
            this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_INV_TWEAKS);
        } else {
            this.view.sort(FluidSorters.CONFIG_BASED_SORT_BY_NAME);
        }
        for (IAEItemStack is : this.view) {
            this.dsp.add(is.getItemStack());
        }
        Iterator it1 = this.view.iterator();
        while (it1.hasNext()) {
            IAEFluidStack fluid = ItemFluidDrop.getAeFluidStack((IAEItemStack)it1.next());
            if (AspectUtil.isEssentiaGas(fluid)) continue;
            it1.remove();
        }
        Iterator it2 = this.dsp.iterator();
        while (it2.hasNext()) {
            FluidStack fluid = ItemFluidDrop.getFluidStack((ItemStack)it2.next());
            if (AspectUtil.isEssentiaGas(fluid)) continue;
            it2.remove();
        }
    }
}

