/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.render;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import com.glodblock.github.common.block.BlockFluidBuffer;
import com.glodblock.github.common.tile.TileFluidBuffer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

public class RenderBlockFluidBuffer
extends BaseBlockRender<BlockFluidBuffer, TileFluidBuffer> {
    public RenderBlockFluidBuffer() {
        super(false, 20.0);
    }

    public boolean renderInWorld(BlockFluidBuffer block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TileFluidBuffer ti = (TileFluidBuffer)block.getTileEntity(world, x, y, z);
        BlockRenderInfo info = block.getRendererInstance();
        this.renderFluid(ti, x, y, z, renderer);
        boolean fz = super.renderInWorld((AEBaseBlock)block, world, x, y, z, renderer);
        info.setTemporaryRenderIcon(null);
        return fz;
    }

    private void renderFluid(TileFluidBuffer tileEntity, double x, double y, double z, RenderBlocks renderer) {
        Fluid storedFluid;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (tileEntity != null && tileEntity.getFluidStack() != null && (storedFluid = tileEntity.getFluidStack().getFluid()) != null) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Block id = Block.func_149729_e((int)FluidRegistry.WATER.getID());
            IIcon fluidIcon = storedFluid.getIcon();
            if (fluidIcon == null) {
                fluidIcon = FluidRegistry.LAVA.getIcon();
            }
            tessellator.func_78369_a((float)(storedFluid.getColor() >> 16 & 0xFF) / 255.0f, (float)(storedFluid.getColor() >> 8 & 0xFF) / 255.0f, (float)(storedFluid.getColor() & 0xFF) / 255.0f, 1.0f);
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_147768_a(id, x, y, z, fluidIcon);
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_147806_b(id, x, y, z, fluidIcon);
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_147761_c(id, x, y, z, fluidIcon);
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_147734_d(id, x, y, z, fluidIcon);
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_147798_e(id, x, y, z, fluidIcon);
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_147764_f(id, x, y, z, fluidIcon);
            GL11.glDisable((int)3042);
        }
    }
}

