/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.tile.inventory.BiggerAppEngInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import com.glodblock.github.client.textures.FCPartsTexture;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.base.FCFluidEncodeTerminal;
import com.glodblock.github.inventory.gui.GuiType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PartFluidPatternTerminal
extends FCFluidEncodeTerminal {
    private static final FCPartsTexture FRONT_BRIGHT_ICON = FCPartsTexture.PartFluidPatternTerminal_Bright;
    private static final FCPartsTexture FRONT_DARK_ICON = FCPartsTexture.PartFluidPatternTerminal_Colored;
    private static final FCPartsTexture FRONT_COLORED_ICON = FCPartsTexture.PartFluidPatternTerminal_Dark;

    public PartFluidPatternTerminal(ItemStack is) {
        super(is);
        this.crafting = new BiggerAppEngInventory((IAEAppEngInventory)this, 9);
        this.output = new BiggerAppEngInventory((IAEAppEngInventory)this, 3);
        this.prioritize = false;
        this.inverted = false;
        this.activePage = 0;
    }

    @Override
    public GuiType getGui() {
        return GuiType.FLUID_PATTERN_TERMINAL;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ICraftingPatternItem pattern;
        ICraftingPatternDetails details;
        ItemStack is;
        if (inv == this.pattern && slot == 1 && (is = inv.func_70301_a(1)) != null && is.func_77973_b() instanceof ICraftingPatternItem && (details = (pattern = (ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getHost().getTile().func_145831_w())) != null) {
            ItemStack packet;
            IAEItemStack item;
            int i;
            IAEItemStack[] inItems = details.getInputs();
            IAEItemStack[] outItems = details.getOutputs();
            this.setCraftingRecipe(details.isCraftable());
            this.setSubstitution(details.canSubstitute());
            if (newStack != null) {
                NBTTagCompound data = newStack.func_77978_p();
                this.setCombineMode(data.func_74762_e("combine") == 1);
                this.setBeSubstitute(details.canBeSubstitute());
            }
            for (i = 0; i < this.crafting.func_70302_i_(); ++i) {
                this.crafting.func_70299_a(i, null);
            }
            for (i = 0; i < this.output.func_70302_i_(); ++i) {
                this.output.func_70299_a(i, null);
            }
            for (i = 0; i < this.crafting.func_70302_i_() && i < inItems.length; ++i) {
                if (inItems[i] == null) continue;
                item = inItems[i];
                if (item != null && item.getItem() instanceof ItemFluidDrop) {
                    packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item.getItemStack()));
                    this.crafting.func_70299_a(i, packet);
                    continue;
                }
                this.crafting.func_70299_a(i, item == null ? null : item.getItemStack());
            }
            for (i = 0; i < this.output.func_70302_i_() && i < outItems.length; ++i) {
                if (outItems[i] == null) continue;
                item = outItems[i];
                if (item != null && item.getItem() instanceof ItemFluidDrop) {
                    packet = ItemFluidPacket.newStack(ItemFluidDrop.getFluidStack(item.getItemStack()));
                    this.output.func_70299_a(i, packet);
                    continue;
                }
                this.output.func_70299_a(i, item == null ? null : item.getItemStack());
            }
        }
        if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
        this.getHost().markForSave();
    }

    private void fixCraftingRecipes() {
        if (this.craftingMode) {
            for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
                ItemStack is = this.crafting.func_70301_a(x);
                if (is == null) continue;
                is.field_77994_a = 1;
            }
        }
    }

    @Override
    public void setCraftingRecipe(boolean craftingMode) {
        super.setCraftingRecipe(craftingMode);
        this.fixCraftingRecipes();
    }

    @Override
    public void setPrioritization(boolean canPrioritize) {
        this.prioritize = false;
    }

    @Override
    public boolean isPrioritize() {
        return false;
    }

    @Override
    public boolean isInverted() {
        return false;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.inverted = false;
    }

    @Override
    public int getActivePage() {
        return 0;
    }

    @Override
    public void setActivePage(int activePage) {
        this.activePage = 0;
    }

    @Override
    public FCPartsTexture getFrontBright() {
        return FRONT_BRIGHT_ICON;
    }

    @Override
    public FCPartsTexture getFrontColored() {
        return FRONT_COLORED_ICON;
    }

    @Override
    public FCPartsTexture getFrontDark() {
        return FRONT_DARK_ICON;
    }

    @Override
    public boolean isLightSource() {
        return false;
    }
}

