/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.extracells;

import com.glodblock.github.common.item.FCBaseItem;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ProxyItem
extends FCBaseItem {
    protected final String name;
    protected final Map<Integer, ProxyItemEntry> replacements;

    public ProxyItem(String ec2itemName) {
        this.name = ec2itemName;
        this.replacements = new HashMap<Integer, ProxyItemEntry>();
        this.func_77655_b("ec2placeholder." + this.name);
    }

    @Override
    public FCBaseItem register() {
        GameRegistry.registerItem((Item)this, (String)("ec2placeholder." + this.name), (String)"ae2fc");
        return this;
    }

    protected void addMetaReplacement(int srcMeta, Item replacement, int targetMeta) {
        this.replacements.put(srcMeta, new ProxyItemEntry(replacement, targetMeta));
    }

    protected void addMetaReplacement(int srcMeta, ProxyItemEntry replacement) {
        this.replacements.put(srcMeta, replacement);
    }

    public boolean func_77614_k() {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean p_77624_4_) {
        int meta = stack.func_77960_j();
        ProxyItemEntry itemRepl = this.replacements.get(meta);
        if (itemRepl != null) {
            info.add(EnumChatFormatting.RED + "Extra Cells Placeholder for:");
            info.add(EnumChatFormatting.AQUA + itemRepl.replacement.func_77658_a());
            info.add(EnumChatFormatting.GOLD + "Put in your inventory to get a replacement.");
            info.add(EnumChatFormatting.GOLD + "It will disappear if no replacement was found.");
            info.add(EnumChatFormatting.RED + "Report missing conversions on the Github.");
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int p_77663_4_, boolean p_77663_5_) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack s = player.field_71071_by.func_70301_a(i);
                if (s != stack) continue;
                int meta = stack.func_77960_j();
                ProxyItemEntry r = this.replacements.get(meta);
                if (r == null) {
                    player.field_71071_by.func_70299_a(i, null);
                    break;
                }
                ItemStack replaceStack = new ItemStack(r.replacement, stack.field_77994_a, r.replacementMeta);
                if (stack.func_77942_o()) {
                    replaceStack.func_77982_d(r.replaceNBT(stack.func_77978_p()));
                }
                player.field_71071_by.func_70299_a(i, replaceStack);
                break;
            }
        }
    }

    protected static class ProxyStorageEntry
    extends ProxyItemEntry {
        public final long maxBytes;
        public final int bytesPerType;
        public final double idleDrain;
        public final int types;

        protected ProxyStorageEntry(Item replacement, int meta, long kilobytes, int bytesPerType, double idleDrain) {
            super(replacement, meta);
            this.maxBytes = kilobytes * 1024L;
            this.bytesPerType = bytesPerType;
            this.idleDrain = idleDrain;
            this.types = 63;
        }

        protected ProxyStorageEntry(Item replacement, long kilobytes, int bytesPerType, double idleDrain, int types) {
            super(replacement, 0);
            this.maxBytes = kilobytes * 1024L;
            this.bytesPerType = bytesPerType;
            this.idleDrain = idleDrain;
            this.types = types;
        }

        @Override
        NBTTagCompound replaceNBT(NBTTagCompound compound) {
            if (compound != null && compound.func_74764_b("ecc")) {
                compound.func_82580_o("ecc");
            }
            return compound;
        }
    }

    protected static class ProxyItemEntry {
        protected final Item replacement;
        protected final int replacementMeta;

        protected ProxyItemEntry(Item replacement, int replacementMeta) {
            this.replacement = replacement;
            this.replacementMeta = replacementMeta;
        }

        NBTTagCompound replaceNBT(NBTTagCompound compound) {
            System.out.println(compound);
            return compound;
        }
    }
}

