/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.category;

import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Module;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Entity;
import forge.com.gitlab.cdagaming.craftpresence.config.category.Gui;
import forge.com.gitlab.cdagaming.craftpresence.impl.HashMapBuilder;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.io.Serializable;
import java.util.Map;

public class Advanced
extends Module
implements Serializable {
    private static final long serialVersionUID = 6035241954568785784L;
    private static final Advanced DEFAULT = new Advanced();
    public boolean enablePerGui = false;
    public boolean enablePerItem = false;
    public boolean enablePerEntity = false;
    public boolean renderTooltips = true;
    public boolean formatWords = true;
    public boolean debugMode = false;
    public boolean verboseMode = false;
    public int refreshRate = 2;
    public int roundSize = 3;
    public boolean includeExtraGuiClasses = false;
    public boolean allowPlaceholderPreviews = false;
    public Gui guiSettings = new Gui();
    public Map<String, String> itemMessages = new HashMapBuilder<String, String>().put("default", ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.advanced.item_messages", new Object[0])).build();
    public Entity entitySettings = new Entity();
    public boolean allowEndpointIcons = true;
    public String serverIconEndpoint = "https://api.mcsrvstat.us/icon/{server.address.short}";
    public String playerSkinEndpoint = "https://mc-heads.net/avatar/{getOrDefault(player.uuid.short, player.name)}";

    public Advanced(Advanced other) {
        this.transferFrom(other);
    }

    public Advanced() {
    }

    @Override
    public Advanced getDefaults() {
        return new Advanced(DEFAULT);
    }

    @Override
    public Advanced copy() {
        return new Advanced(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Advanced && !this.equals(target)) {
            Advanced data = (Advanced)target;
            this.enablePerGui = data.enablePerGui;
            this.enablePerItem = data.enablePerItem;
            this.enablePerEntity = data.enablePerEntity;
            this.renderTooltips = data.renderTooltips;
            this.formatWords = data.formatWords;
            this.debugMode = data.debugMode;
            this.verboseMode = data.verboseMode;
            this.refreshRate = data.refreshRate;
            this.roundSize = data.roundSize;
            this.includeExtraGuiClasses = data.includeExtraGuiClasses;
            this.allowPlaceholderPreviews = data.allowPlaceholderPreviews;
            this.guiSettings = new Gui(data.guiSettings);
            this.itemMessages = data.itemMessages;
            this.entitySettings = new Entity(data.entitySettings);
            this.allowEndpointIcons = data.allowEndpointIcons;
            this.serverIconEndpoint = data.serverIconEndpoint;
            this.playerSkinEndpoint = data.playerSkinEndpoint;
        }
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(Advanced.class, (Object)this, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(Advanced.class, (Object)this, value, name);
    }
}

