/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.updater;

import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ScrollPane;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.TextDisplayWidget;
import forge.com.gitlab.cdagaming.craftpresence.utils.updater.ModUpdaterUtils;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;

public class UpdateInfoGui
extends ExtendedScreen {
    private final ModUpdaterUtils modUpdater;
    private TextDisplayWidget infoPane;
    private ExtendedButtonControl downloadButton;
    private ExtendedButtonControl checkButton;

    public UpdateInfoGui(GuiScreen parentScreen, ModUpdaterUtils modUpdater) {
        super(parentScreen);
        this.modUpdater = modUpdater;
    }

    @Override
    public void initializeUi() {
        this.checkButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, "gui.config.message.button.checkForUpdates", () -> {
            this.resetNotes();
            this.modUpdater.checkForUpdates(this::updateNotes);
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.back", () -> this.openScreen(this.parentScreen), new String[0]));
        this.downloadButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 101, this.getScreenHeight() - 26, 95, 20, "gui.config.message.button.download", () -> UrlUtils.openUrl(this.modUpdater.downloadUrl), new String[0]));
        ScrollPane childFrame = this.addControl(new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 32));
        this.infoPane = childFrame.addWidget(new TextDisplayWidget((ExtendedScreen)childFrame, 0, 0, this.getScreenWidth()));
        this.updateNotes();
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.downloadButton.setControlEnabled(this.modUpdater.currentState == ModUpdaterUtils.UpdateState.OUTDATED || this.modUpdater.currentState == ModUpdaterUtils.UpdateState.BETA_OUTDATED);
        this.checkButton.setControlEnabled(this.modUpdater.currentState != ModUpdaterUtils.UpdateState.PENDING);
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        this.renderCenteredString(mainTitle, (float)this.getScreenWidth() / 2.0f, 10.0f, 0xFFFFFF);
        this.renderCenteredString(subTitle, (float)this.getScreenWidth() / 2.0f, 20.0f, 0xFFFFFF);
        super.preRender();
    }

    @Override
    public void postRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String subTitle = ModUtils.TRANSLATOR.translate("gui.config.title.changes", this.modUpdater.currentState.getDisplayName());
        if (RenderUtils.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0, this.getStringWidth(mainTitle), this.getFontHeight())) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title", "v2.0.7", CraftPresence.CONFIG._schemaVersion)));
        }
        if (RenderUtils.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(subTitle) / 2.0f, 20.0, this.getStringWidth(subTitle), this.getFontHeight())) {
            this.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.changes", "1.7.10")));
        }
        super.postRender();
    }

    private void resetNotes() {
        String notice = ModUtils.TRANSLATOR.translate("gui.config.message.changelog", new Object[0]) + '\n' + "  N/A";
        this.infoPane.setMessage(notice);
    }

    private void updateNotes() {
        if (this.modUpdater.changelogData.size() > 0) {
            StringBuilder notice = new StringBuilder();
            notice.append(ModUtils.TRANSLATOR.translate("gui.config.message.changelog", new Object[0]));
            for (Map.Entry<String, String> entry : this.modUpdater.changelogData.entrySet()) {
                notice.append('\n').append("  ").append(entry.getKey()).append(":").append('\n').append(entry.getValue()).append('\n').append(' ');
            }
            this.infoPane.setMessage(notice.toString());
        } else {
            this.resetNotes();
        }
    }
}

