/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.hidden;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import java.util.WeakHashMap;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.hidden.BlockHidden;
import mods.railcraft.common.blocks.hidden.TileHidden;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Timer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TrailTicker {
    private static final int TICKS_PER_MARKER = 30;
    private final Map<EntityPlayer, WorldCoordinate> lastPosition = new WeakHashMap<EntityPlayer, WorldCoordinate>();
    private final Map<EntityPlayer, Timer> timers = new WeakHashMap<EntityPlayer, Timer>();

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.field_70170_p == null) {
            return;
        }
        Timer timer = this.timers.get(player);
        if (timer == null) {
            timer = new Timer();
            this.timers.put(player, timer);
        }
        if (!timer.hasTriggered(player.field_70170_p, 30)) {
            return;
        }
        String username = Railcraft.proxy.getPlayerUsername(player);
        if (username == null || username.startsWith("[")) {
            return;
        }
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        WorldServer world = DimensionManager.getWorld((int)player.field_70170_p.field_73011_w.field_76574_g);
        boolean success = this.trySetMarker((World)world, x, y, z, player);
        for (int i = 0; i < 8 && !success; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)MiscTools.RANDOM.nextInt(6));
            int newX = MiscTools.getXOnSide(x, dir);
            int newY = MiscTools.getYOnSide(y, dir);
            int newZ = MiscTools.getZOnSide(z, dir);
            success = this.trySetMarker((World)world, newX, newY, newZ, player);
        }
    }

    private boolean trySetMarker(World world, int x, int y, int z, EntityPlayer player) {
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        if (block == Blocks.field_150350_a) {
            world.func_147465_d(x, y, z, (Block)BlockHidden.getBlock(), 0, 6);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileHidden) {
                TileHidden hidden = (TileHidden)tile;
                hidden.timestamp = System.currentTimeMillis();
                hidden.colorSeed = (long)Railcraft.proxy.getPlayerUsername(player).hashCode() * 50021L;
                WorldCoordinate last = this.lastPosition.get(player);
                if (last != null) {
                    hidden.lastMarker = last;
                }
                hidden.sendUpdateToClient();
                this.lastPosition.put(player, new WorldCoordinate(world.field_73011_w.field_76574_g, x, y, z));
                return true;
            }
        }
        return block == BlockHidden.getBlock();
    }
}

