/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.BuildCraftCore;
import buildcraft.core.StackAtPosition;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.IBuildingItemsProvider;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class RenderBuildingItems {
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem = new RenderItem(){

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };
    private Item buildToolItem;
    private int buildToolGlList;

    public RenderBuildingItems() {
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    public void render(TileEntity tile, double x, double y, double z) {
        IBuildingItemsProvider provider = (IBuildingItemsProvider)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)(-tile.field_145851_c), (double)(-tile.field_145848_d), (double)(-tile.field_145849_e));
        if (provider.getBuilders() != null) {
            for (BuildingItem i : provider.getBuilders()) {
                this.doRenderItem(i, 1.0f);
            }
        }
        GL11.glPopMatrix();
    }

    public void renderToList(ItemStack stack, int list) {
        GL11.glNewList((int)list, (int)4865);
        float renderScale = 0.7f;
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(stack);
        this.customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glEndList();
    }

    private void doRenderItem(BuildingItem i, float light) {
        if (this.buildToolItem == null) {
            this.buildToolItem = Item.func_150898_a((Block)BuildCraftCore.buildToolBlock);
            this.buildToolGlList = GL11.glGenLists((int)1);
            this.renderToList(new ItemStack(this.buildToolItem), this.buildToolGlList);
        }
        if (i == null) {
            return;
        }
        i.displayUpdate();
        for (StackAtPosition s : i.getStacks()) {
            if (!s.display) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)s.pos.x), (float)((float)s.pos.y + 0.25f), (float)((float)s.pos.z));
            if (s.stack.func_77973_b() == this.buildToolItem) {
                GL11.glCallList((int)this.buildToolGlList);
            } else if (!s.generatedListId) {
                s.generatedListId = true;
                s.glListId = GL11.glGenLists((int)1);
                this.renderToList(s.stack, s.glListId);
            } else {
                GL11.glCallList((int)s.glListId);
            }
            GL11.glPopMatrix();
        }
    }
}

