/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class GuiResearchBrowserVisitor
extends ClassVisitor {
    private static final String TARGET_INTERNAL_NAME = "thaumcraft/client/gui/GuiResearchBrowser";

    public GuiResearchBrowserVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    private static boolean isMouseClickedMethod(String name) {
        return LoadingPlugin.dev ? "mouseClicked".equals(name) : "func_73864_a".equals(name);
    }

    private static boolean isDrawScreenMethod(String name) {
        return LoadingPlugin.dev ? "drawScreen".equals(name) : "func_73863_a".equals(name);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        FieldAccessDeflector mv = new FieldAccessDeflector(this.api, super.visitMethod(access, name, desc, signature, exceptions));
        if ("genResearchBackground".equals(name) && "(IIF)V".equals(desc)) {
            TC4Transformer.log.debug("Visiting genResearchBackground(IIF)V");
            return new GenResearchBackgroundVisitor(this.api, new ConstantToDynamicReplacer(this.api, new LimitResearchCategoryToPageVisitor(this.api, mv, 1), 9, "getTabPerSide", 1));
        }
        if ("updateResearch".equals(name) && "()V".equals(desc)) {
            TC4Transformer.log.debug("Visiting updateResearch()V");
            return new UpdateResearchVisitor(this.api, new LimitResearchCategoryToPageVisitor(this.api, mv, 1));
        }
        if (GuiResearchBrowserVisitor.isMouseClickedMethod(name) && "(III)V".equals(desc) || GuiResearchBrowserVisitor.isDrawScreenMethod(name) && "(IIF)V".equals(desc)) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new ConstantToDynamicReplacer(this.api, new ConstantToDynamicReplacer(this.api, new LimitResearchCategoryToPageVisitor(this.api, mv, 1), 9, "getTabPerSide"), 280, "getTabIconDistance");
        }
        return mv;
    }

    private static class ConstantToDynamicReplacer
    extends MethodVisitor {
        private final int maxReplacement;
        private final int toReplace;
        private final String target;
        private int replaced = 0;

        public ConstantToDynamicReplacer(int api, MethodVisitor mv, int toReplace, String target) {
            this(api, mv, toReplace, target, 1);
        }

        public ConstantToDynamicReplacer(int api, MethodVisitor mv, int toReplace, String target, int maxReplacement) {
            super(api, mv);
            this.maxReplacement = maxReplacement;
            this.toReplace = toReplace;
            this.target = target;
        }

        public void visitIntInsn(int opcode, int operand) {
            if (this.replaced < this.maxReplacement && operand == this.toReplace) {
                TC4Transformer.log.debug("Replacing constant {} with {}()I", new Object[]{this.toReplace, this.target});
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", this.target, "()I", false);
                ++this.replaced;
            } else {
                super.visitIntInsn(opcode, operand);
            }
        }
    }

    private static class LimitResearchCategoryToPageVisitor
    extends MethodVisitor {
        private final int maxReplacement;
        private int replaced = 0;

        public LimitResearchCategoryToPageVisitor(int api, MethodVisitor mv, int maxReplacement) {
            super(api, mv);
            this.maxReplacement = maxReplacement;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (this.replaced < this.maxReplacement && opcode == 178 && "thaumcraft/api/research/ResearchCategories".equals(owner) && "researchCategories".equals(name) && "Ljava/util/LinkedHashMap;".equals(desc)) {
                TC4Transformer.log.debug("Replacing ResearchCategories.researchCategories with getTabsOnCurrentPage()");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, GuiResearchBrowserVisitor.TARGET_INTERNAL_NAME, "player", "Ljava/lang/String;");
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "getTabsOnCurrentPage", "(Ljava/lang/String;)Ljava/util/LinkedHashMap;", false);
                ++this.replaced;
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }
    }

    private static class FieldAccessDeflector
    extends MethodVisitor {
        private static final Map<String, String> TARGET_FIELDS = ImmutableMap.of((Object)"paneWidth", (Object)"getResearchBrowserWidth", (Object)"paneHeight", (Object)"getResearchBrowserHeight");
        private int widthReplaced = 0;

        public FieldAccessDeflector(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            String target;
            if (opcode == 180 && GuiResearchBrowserVisitor.TARGET_INTERNAL_NAME.equals(owner) && (target = TARGET_FIELDS.get(name)) != null && "I".equals(desc)) {
                TC4Transformer.log.debug("Replaced GETFIELD {} to INVOKESTATIC {}", new Object[]{name, target});
                super.visitInsn(87);
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", target, "()I", false);
            } else {
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public void visitIntInsn(int opcode, int operand) {
            if (operand == 224 && this.widthReplaced < 2) {
                TC4Transformer.log.debug("Replacing inner width 224 with getResearchBrowserWidth() - 2 * BORDER_WIDTH");
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "getResearchBrowserWidth", "()I", false);
                super.visitIntInsn(16, 32);
                super.visitInsn(100);
                ++this.widthReplaced;
            } else if (operand == 196) {
                TC4Transformer.log.debug("Replacing inner height 196 with getResearchBrowserHeight() - 2 * BORDER_HEIGHT");
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "getResearchBrowserHeight", "()I", false);
                super.visitIntInsn(16, 34);
                super.visitInsn(100);
            } else {
                super.visitIntInsn(opcode, operand);
            }
        }
    }

    private static class GenResearchBackgroundVisitor
    extends MethodVisitor {
        private int counterPaneWidth = 0;
        private int counterParticleDraw = 0;
        private boolean borderDrawChanged = false;
        private boolean found112 = false;
        private boolean backgroundDrawChanged = false;

        public GenResearchBackgroundVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        private static boolean isDrawTexturedModalRect(String methodName) {
            return LoadingPlugin.dev ? "drawTexturedModalRect".equals(methodName) : "func_73729_b".equals(methodName);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (!this.found112 && operand == 112) {
                TC4Transformer.log.debug("Found 112");
                this.found112 = true;
            } else if (operand == 264) {
                TC4Transformer.log.debug("Replacing 264 with getTabDistance()");
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "getTabDistance", "()I", false);
                return;
            }
            super.visitIntInsn(opcode, operand);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            super.visitFieldInsn(opcode, owner, name, desc);
            if (opcode == 180 && GuiResearchBrowserVisitor.TARGET_INTERNAL_NAME.equals(owner) && "paneWidth".equals(name) && "I".equals(desc)) {
                ++this.counterPaneWidth;
                if (this.counterPaneWidth > 2) {
                    TC4Transformer.log.warn("GuiResearchBrowser has been changed by other people! Things are not going to work right!");
                }
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.found112 && !this.backgroundDrawChanged && opcode == 182 && owner.equals(GuiResearchBrowserVisitor.TARGET_INTERNAL_NAME) && GenResearchBackgroundVisitor.isDrawTexturedModalRect(name) && desc.equals("(IIIIII)V")) {
                this.backgroundDrawChanged = true;
                TC4Transformer.log.debug("Deflecting drawTexturedModalRect to drawResearchBrowserBackground");
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "drawResearchBrowserBackground", "(Lthaumcraft/client/gui/GuiResearchBrowser;IIIIII)V", false);
            } else if (!this.borderDrawChanged && this.counterPaneWidth == 2 && opcode == 182 && owner.equals(GuiResearchBrowserVisitor.TARGET_INTERNAL_NAME) && GenResearchBackgroundVisitor.isDrawTexturedModalRect(name) && desc.equals("(IIIIII)V")) {
                this.borderDrawChanged = true;
                TC4Transformer.log.debug("Deflecting drawTexturedModalRect to drawResearchBrowserBorders");
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "drawResearchBrowserBorders", "(Lthaumcraft/client/gui/GuiResearchBrowser;IIIIII)V", false);
            } else if (opcode == 184 && owner.equals("thaumcraft/client/lib/UtilsFX") && name.equals("drawTexturedQuad") && desc.equals("(IIIIIID)V") && this.counterParticleDraw++ == 1) {
                TC4Transformer.log.debug("Deflecting drawTexturedQuad to drawResearchCategoryHintParticles");
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "drawResearchCategoryHintParticles", "(IIIIIIDLthaumcraft/client/gui/GuiResearchBrowser;)V", false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        public void visitEnd() {
            if (this.counterParticleDraw < 2) {
                TC4Transformer.log.warn("MISSED HINT PARTICLE REDIRECT. This fix will not work!");
            } else if (this.counterParticleDraw > 2) {
                TC4Transformer.log.warn("WEIRD HINT PARTICLE REDIRECT. This fix will most likely not work!");
            }
            if (!this.borderDrawChanged) {
                TC4Transformer.log.warn("MISSED BORDER DRAW INJECT. Research browser resizing will not work!");
            }
            if (!this.backgroundDrawChanged) {
                TC4Transformer.log.warn("MISSED BACKGROUND DRAW INJECT. Research browser resizing will not work!");
            }
            super.visitEnd();
        }
    }

    private static class UpdateResearchVisitor
    extends MethodVisitor {
        public UpdateResearchVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 179 && GuiResearchBrowserVisitor.TARGET_INTERNAL_NAME.equals(owner) && name.startsWith("guiMap") && "I".equals(desc)) {
                String side = name.substring(6);
                TC4Transformer.log.debug("Injecting modify callhook getNewGuiMap{}() before PUTSTATIC {}", new Object[]{side, name});
                super.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhook", "getNewGuiMap" + side, "(I)I", false);
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }
}

