/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.events;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import makeo.gadomancy.api.GadomancyApi;
import makeo.gadomancy.api.golems.AdditionalGolemType;
import makeo.gadomancy.api.golems.cores.AdditionalGolemCore;
import makeo.gadomancy.api.golems.events.GolemDropPlacerEvent;
import makeo.gadomancy.api.golems.events.PlacerCreateGolemEvent;
import makeo.gadomancy.common.Gadomancy;
import makeo.gadomancy.common.data.DataAchromatic;
import makeo.gadomancy.common.data.SyncDataHolder;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.entities.golems.ItemAdditionalGolemPlacer;
import makeo.gadomancy.common.entities.golems.nbt.ExtendedGolemProperties;
import makeo.gadomancy.common.registration.RegisteredGolemStuff;
import makeo.gadomancy.common.registration.RegisteredPotions;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.EnumGolemType;
import thaumcraft.common.entities.golems.ItemGolemPlacer;
import thaumcraft.common.items.wands.ItemWandCasting;

public class EventHandlerGolem {
    private final Map<EntityGolemBase, EntityPlayer> markedGolems = new HashMap<EntityGolemBase, EntityPlayer>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void on(EntityEvent.EntityConstructing e) {
        if (e.entity instanceof EntityGolemBase) {
            EntityGolemBase golem = (EntityGolemBase)e.entity;
            golem.registerExtendedProperties("gadomancy", (IExtendedEntityProperties)new ExtendedGolemProperties(golem));
            golem.func_70096_w().func_75682_a(ModConfig.golemDatawatcherId, (Object)"");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void on(EntityEvent.EnteringChunk event) {
        ExtendedGolemProperties props;
        EntityGolemBase golem;
        if (event.entity instanceof EntityGolemBase && GadomancyApi.isAdditionalGolemType((golem = (EntityGolemBase)event.entity).getGolemType()) && (props = (ExtendedGolemProperties)event.entity.getExtendedProperties("gadomancy")).shouldUpdateHealth()) {
            props.resetUpdateHealth();
            golem.func_70606_j(props.getHealth());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void on(EntityJoinWorldEvent event) {
        AdditionalGolemType type;
        EntityItem item;
        ItemStack stack;
        EntityGolemBase golem;
        ExtendedGolemProperties props;
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityGolemBase && (props = (ExtendedGolemProperties)(golem = (EntityGolemBase)event.entity).getExtendedProperties("gadomancy")) != null) {
            props.setWrapperIfNeeded();
        }
        if (event.entity instanceof EntityItem && (stack = (item = (EntityItem)event.entity).func_92059_d()).func_77973_b() == ConfigItems.itemGolemPlacer && (type = GadomancyApi.getAdditionalGolemType(EnumGolemType.getType((int)stack.func_77960_j()))) != null) {
            ItemStack fakePlacer = new ItemStack(type.getPlacerItem());
            fakePlacer.func_77982_d(stack.func_77978_p());
            fakePlacer.func_77964_b(stack.func_77960_j());
            item.func_92058_a(fakePlacer);
        }
        if (!event.world.field_72995_K && event.entity instanceof EntityLivingBase && ((EntityLivingBase)event.entity).func_70644_a((Potion)RegisteredPotions.ACHROMATIC)) {
            ((DataAchromatic)SyncDataHolder.getDataServer("AchromaticData")).handleApplication((EntityLivingBase)event.entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void on(PlayerInteractEvent e) {
        ItemStack itemInHand;
        if (!e.world.field_72995_K && e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (itemInHand = e.entityPlayer.func_70694_bm()) != null && (itemInHand.func_77973_b() instanceof ItemGolemPlacer || itemInHand.func_77973_b() instanceof ItemAdditionalGolemPlacer)) {
            int entityId = Entity.field_70152_a;
            if (itemInHand.func_77973_b().onItemUseFirst(itemInHand, e.entityPlayer, e.world, e.x, e.y, e.z, e.face, 0.0f, 0.0f, 0.0f)) {
                e.setCanceled(true);
                Entity entity = e.world.func_73045_a(entityId);
                if (entity != null && entity instanceof EntityGolemBase) {
                    EntityGolemBase golem = (EntityGolemBase)entity;
                    golem.getEntityData().func_74782_a("gadomancy", NBTHelper.getPersistentData(itemInHand).func_74737_b());
                    MinecraftForge.EVENT_BUS.post((Event)new PlacerCreateGolemEvent(e.entityPlayer, golem, itemInHand));
                    ExtendedGolemProperties props = (ExtendedGolemProperties)golem.getExtendedProperties("gadomancy");
                    if (props != null) {
                        props.updateGolemCore();
                        props.updateGolem();
                    }
                    if (RegisteredGolemStuff.upgradeRunicShield.hasUpgrade(golem)) {
                        RegisteredGolemStuff.upgradeRunicShield.getCharge(golem);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void on(PlaySoundAtEntityEvent event) {
        EntityGolemBase golem;
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityGolemBase && event.name.equals("thaumcraft:zap") && event.volume == 0.5f && event.pitch == 1.0f && this.markedGolems.containsKey(golem = (EntityGolemBase)event.entity)) {
            EntityPlayer player = this.markedGolems.get(golem);
            this.markedGolems.remove(golem);
            AdditionalGolemCore core = GadomancyApi.getAdditionalGolemCore(golem);
            boolean movedPlacer = false;
            boolean movedCore = core == null || !player.func_70093_af();
            for (EntityItem entityItem : golem.capturedDrops) {
                ItemStack item = entityItem.func_92059_d();
                if (!movedCore && item.func_77973_b() == ConfigItems.itemGolemCore) {
                    entityItem.func_92058_a(core.getItem());
                }
                if (!movedPlacer && item.func_77973_b() instanceof ItemGolemPlacer || item.func_77973_b() instanceof ItemAdditionalGolemPlacer) {
                    NBTTagCompound persistent = (NBTTagCompound)NBTHelper.getPersistentData((Entity)golem).func_74737_b();
                    if (player.func_70093_af()) {
                        persistent.func_82580_o("Core");
                    }
                    NBTHelper.getData(item).func_74782_a("gadomancy", (NBTBase)persistent);
                    event.entity.func_70106_y();
                    entityItem.func_92058_a(item);
                    MinecraftForge.EVENT_BUS.post((Event)new GolemDropPlacerEvent(player, entityItem, golem));
                    movedPlacer = true;
                }
                event.entity.field_70170_p.func_72838_d((Entity)entityItem);
            }
            golem.capturedDrops.clear();
            golem.captureDrops = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void on(AttackEntityEvent event) {
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == ConfigItems.itemGolemBell && event.target instanceof EntityGolemBase && !event.target.field_70170_p.field_72995_K && !event.target.field_70128_L) {
            event.target.captureDrops = true;
            this.markedGolems.put((EntityGolemBase)event.target, event.entityPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void on(LivingHurtEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityGolemBase) {
            EntityGolemBase golem = (EntityGolemBase)event.entity;
            if (event.ammount > 0.0f && RegisteredGolemStuff.upgradeRunicShield.hasUpgrade(golem)) {
                event.ammount = RegisteredGolemStuff.upgradeRunicShield.absorb(golem, event.ammount, event.source);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void on(EntityInteractEvent event) {
        ItemStack heldItem = event.entityPlayer.func_70694_bm();
        if (event.target instanceof EntityGolemBase) {
            EntityGolemBase golem = (EntityGolemBase)event.target;
            if (golem.getCore() < 0) {
                if (heldItem != null) {
                    AdditionalGolemCore core = null;
                    for (AdditionalGolemCore entry : GadomancyApi.getAdditionalGolemCores()) {
                        if (!entry.getItem().func_77969_a(heldItem)) continue;
                        core = entry;
                        break;
                    }
                    if (core != null && heldItem.field_77994_a > 0) {
                        GadomancyApi.setAdditionalGolemCore(golem, core);
                        event.setCanceled(true);
                        if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                            --heldItem.field_77994_a;
                        }
                    }
                }
            } else {
                AdditionalGolemCore core;
                if (!event.target.field_70170_p.field_72995_K && (heldItem == null || heldItem.func_77973_b() != ConfigItems.itemGolemBell && heldItem.func_77973_b() != ConfigItems.itemGolemUpgrade && heldItem.func_77973_b() != ConfigItems.itemGolemDecoration && !(heldItem.func_77973_b() instanceof ItemWandCasting)) && (core = GadomancyApi.getAdditionalGolemCore(golem)) != null) {
                    if (core.hasGui() && !core.openGui(event.entityPlayer, golem)) {
                        event.entityPlayer.openGui((Object)Gadomancy.instance, 0, golem.field_70170_p, golem.func_145782_y(), 0, 0);
                    }
                    event.setCanceled(true);
                }
                if (heldItem != null && heldItem.func_77973_b() == ConfigItems.itemGolemBell && (core = GadomancyApi.getAdditionalGolemCore(golem)) != null && !core.hasMarkers()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void on(ItemTooltipEvent event) {
        if (event.itemStack != null && (event.itemStack.func_77973_b() instanceof ItemGolemPlacer || event.itemStack.func_77973_b() instanceof ItemAdditionalGolemPlacer)) {
            AdditionalGolemCore core;
            if (RegisteredGolemStuff.upgradeRunicShield.hasUpgrade(event.itemStack)) {
                event.toolTip.add("\u00a76" + StatCollector.func_74838_a((String)"item.runic.charge") + " +" + RegisteredGolemStuff.upgradeRunicShield.getChargeLimit(event.itemStack));
            }
            if ((core = GadomancyApi.getAdditionalGolemCore(event.itemStack)) != null) {
                String searchStr = StatCollector.func_74838_a((String)"item.ItemGolemCore.name");
                for (int i = 0; i < event.toolTip.size(); ++i) {
                    String line = (String)event.toolTip.get(i);
                    if (!line.contains(searchStr)) continue;
                    int index = line.indexOf(167, searchStr.length()) + 2;
                    event.toolTip.remove(i);
                    event.toolTip.add(i, line.substring(0, index) + StatCollector.func_74838_a((String)core.getUnlocalizedName()));
                    break;
                }
            }
        }
    }
}

