/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer.helper;

import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.ModLogger;
import com.carpentersblocks.util.registry.FeatureRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.RenderBlockFluid;
import org.apache.logging.log4j.Level;
import sun.reflect.Reflection;

@SideOnly(value=Side.CLIENT)
public class RoutableFluidsHelper {
    public static final Class[] liquidClasses = new Class[]{BlockLiquid.class, IFluidBlock.class};
    private static final int CALLER_SUN = 0;
    private static final int CALLER_SEC = 1;
    private static int callMethod = -1;

    public static Class getCallerClass() {
        if (callMethod < 0) {
            try {
                Reflection.getCallerClass((int)2);
                callMethod = 0;
            }
            catch (Exception E) {
                try {
                    new SecurityManager(){
                        Class clazz = this.getClassContext()[2];
                    };
                    callMethod = 1;
                }
                catch (Exception E1) {
                    FeatureRegistry.enableRoutableFluids = false;
                    ModLogger.log(Level.WARN, "Routable fluids failed: %s", E1.getMessage());
                }
            }
        }
        switch (callMethod) {
            case 0: {
                return Reflection.getCallerClass((int)4);
            }
            case 1: {
                return new SecurityManager(){
                    Class clazz = this.getClassContext()[4];
                }.clazz;
            }
        }
        return null;
    }

    public static boolean render(TEBase TE, RenderBlocks renderBlocks, int x, int y, int z) {
        Class<?> clazz_YP = renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).getClass();
        for (Class clazz : liquidClasses) {
            if (!clazz.isAssignableFrom(clazz_YP)) continue;
            return false;
        }
        ItemStack itemStack = RoutableFluidsHelper.getFluidBlock(renderBlocks.field_147845_a, x, y, z);
        if (itemStack != null) {
            Block block = BlockProperties.toBlock(itemStack);
            int metadata = itemStack.func_77960_j();
            if (block.func_149701_w() == MinecraftForgeClient.getRenderPass() && !block.hasTileEntity(metadata)) {
                if (block instanceof BlockLiquid) {
                    RoutableFluidsHelper.renderLiquidSurface(TE, renderBlocks, itemStack, x, y, z);
                } else {
                    RenderBlockFluid.instance.renderWorldBlock(renderBlocks.field_147845_a, x, y, z, block, 0, renderBlocks);
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack getFluidBlock(IBlockAccess blockAccess, int x, int y, int z) {
        int[][] offsetXZ = new int[][]{{0, -1}, {0, 1}, {-1, 0}, {1, 0}, {-1, -1}, {-1, 1}, {1, 1}, {1, -1}};
        ForgeDirection[][][] route = new ForgeDirection[][][]{{{ForgeDirection.NORTH}}, {{ForgeDirection.SOUTH}}, {{ForgeDirection.WEST}}, {{ForgeDirection.EAST}}, {{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST}, {ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH}}, {{ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.WEST}, {ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.SOUTH}}, {{ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.EAST}, {ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH}}, {{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST}, {ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH}}};
        for (int idx = 0; idx < offsetXZ.length; ++idx) {
            Block block = blockAccess.func_147439_a(x + offsetXZ[idx][0], y, z + offsetXZ[idx][1]);
            Class<?> clazz_offset = block.getClass();
            boolean isLiquid = false;
            for (Class clazz : liquidClasses) {
                if (!clazz.isAssignableFrom(clazz_offset)) continue;
                isLiquid = true;
                break;
            }
            if (!isLiquid) continue;
            if (idx < 4) {
                if (blockAccess.isSideSolid(x, y, z, route[idx][0][0], false)) continue;
                return new ItemStack(block, blockAccess.func_72805_g(x + offsetXZ[idx][0], y, z + offsetXZ[idx][1]));
            }
            for (int routeIdx = 0; routeIdx < 2; ++routeIdx) {
                int[] bridgeXZ;
                if (blockAccess.isSideSolid(x, y, z, route[idx][routeIdx][0], false) || blockAccess.isSideSolid((bridgeXZ = new int[]{x + route[idx][routeIdx][0].offsetX, z + route[idx][routeIdx][0].offsetZ})[0], y, bridgeXZ[1], route[idx][routeIdx][1], false) || blockAccess.isSideSolid(bridgeXZ[0], y, bridgeXZ[1], route[idx][routeIdx][2], false)) continue;
                return new ItemStack(block, blockAccess.func_72805_g(x + offsetXZ[idx][0], y, z + offsetXZ[idx][1]));
            }
        }
        return null;
    }

    public static void renderLiquidSurface(TEBase TE, RenderBlocks renderBlocks, ItemStack itemStack, int x, int y, int z) {
        double v_XZPN;
        double u_XZPN;
        double v_XZPP;
        double u_XZPP;
        double v_XZNP;
        double u_XZNP;
        double v_XZNN;
        double u_XZNN;
        Tessellator tessellator = Tessellator.field_78398_a;
        Block block = BlockProperties.toBlock(itemStack);
        Material material = block.func_149688_o();
        double offset = 0.001f;
        IIcon icon = renderBlocks.func_147787_a(block, 1, itemStack.func_77960_j());
        float flowDir = -1000.0f;
        if (block instanceof BlockLiquid) {
            flowDir = (float)BlockLiquid.func_149802_a((IBlockAccess)renderBlocks.field_147845_a, (int)x, (int)y, (int)z, (Material)material);
        } else if (block instanceof BlockFluidBase) {
            flowDir = (float)BlockFluidBase.getFlowDirection((IBlockAccess)renderBlocks.field_147845_a, (int)x, (int)y, (int)z);
        }
        if (flowDir > -999.0f) {
            icon = renderBlocks.func_147787_a(block, 2, itemStack.func_77960_j());
        }
        if (flowDir < -999.0f) {
            u_XZNN = icon.func_94214_a(0.0);
            v_XZNN = icon.func_94207_b(0.0);
            u_XZNP = u_XZNN;
            v_XZNP = icon.func_94207_b(16.0);
            u_XZPP = icon.func_94214_a(16.0);
            v_XZPP = v_XZNP;
            u_XZPN = u_XZPP;
            v_XZPN = v_XZNN;
        } else {
            float sinDir = MathHelper.func_76126_a((float)flowDir) * 0.25f;
            float cosDir = MathHelper.func_76134_b((float)flowDir) * 0.25f;
            u_XZNN = icon.func_94214_a((double)(8.0f + (-cosDir - sinDir) * 16.0f));
            v_XZNN = icon.func_94207_b((double)(8.0f + (-cosDir + sinDir) * 16.0f));
            u_XZNP = icon.func_94214_a((double)(8.0f + (-cosDir + sinDir) * 16.0f));
            v_XZNP = icon.func_94207_b((double)(8.0f + (cosDir + sinDir) * 16.0f));
            u_XZPP = icon.func_94214_a((double)(8.0f + (cosDir + sinDir) * 16.0f));
            v_XZPP = icon.func_94207_b((double)(8.0f + (cosDir - sinDir) * 16.0f));
            u_XZPN = icon.func_94214_a((double)(8.0f + (cosDir - sinDir) * 16.0f));
            v_XZPN = icon.func_94207_b((double)(8.0f + (-cosDir - sinDir) * 16.0f));
        }
        double height_XZNN = (double)renderBlocks.func_147729_a(x, y, z, material) - offset;
        double height_XZNP = (double)renderBlocks.func_147729_a(x, y, z + 1, material) - offset;
        double height_XZPN = (double)renderBlocks.func_147729_a(x + 1, y, z, material) - offset;
        double height_XZPP = (double)renderBlocks.func_147729_a(x + 1, y, z + 1, material) - offset;
        int colorMultiplier = block.func_149720_d(renderBlocks.field_147845_a, x, y, z);
        float red = (float)(colorMultiplier >> 16 & 0xFF) / 255.0f;
        float green = (float)(colorMultiplier >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colorMultiplier & 0xFF) / 255.0f;
        tessellator.func_78380_c(block.func_149677_c(renderBlocks.field_147845_a, x, y, z));
        tessellator.func_78386_a(red, green, blue);
        tessellator.func_78374_a((double)x, (double)y + height_XZNN, (double)z, u_XZNN, v_XZNN);
        tessellator.func_78374_a((double)x, (double)y + height_XZNP, (double)(z + 1), u_XZNP, v_XZNP);
        tessellator.func_78374_a((double)(x + 1), (double)y + height_XZPP, (double)(z + 1), u_XZPP, v_XZPP);
        tessellator.func_78374_a((double)(x + 1), (double)y + height_XZPN, (double)z, u_XZPN, v_XZPN);
        tessellator.func_78374_a((double)x, (double)y + height_XZNN, (double)z, u_XZNN, v_XZNN);
        tessellator.func_78374_a((double)(x + 1), (double)y + height_XZPN, (double)z, u_XZPN, v_XZPN);
        tessellator.func_78374_a((double)(x + 1), (double)y + height_XZPP, (double)(z + 1), u_XZPP, v_XZPP);
        tessellator.func_78374_a((double)x, (double)y + height_XZNP, (double)(z + 1), u_XZNP, v_XZNP);
    }
}

