/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.N2ConfigApi.api.core;

import com.n247s.N2ConfigApi.api.N2ConfigApi;
import com.n247s.N2ConfigApi.api.core.ConfigFile;
import com.n247s.N2ConfigApi.api.core.ConfigSection;
import com.n247s.N2ConfigApi.api.core.DefaultConfigFile;
import com.n247s.N2ConfigApi.api.core.InitConfigObjectManager;
import com.n247s.N2ConfigApi.api.networking.N2ConfigApiMessageHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;

public class ConfigHandler {
    private static final Logger log = N2ConfigApi.log;
    private static final HashMap<ConfigFile, File> fileList = new HashMap();
    private static final List<ConfigFile> backupList = new ArrayList<ConfigFile>();

    /*
     * Enabled aggressive block sorting
     */
    public static boolean registerConfigFile(ConfigFile configFile, File targetDirectory) {
        File newFile;
        ProxySide side = configFile.getProxySide();
        if (!side.isEffectiveSide(FMLCommonHandler.instance().getEffectiveSide())) {
            return false;
        }
        String fileName = configFile.getFileName() + ".cfg";
        if (targetDirectory != null) {
            if (!targetDirectory.isDirectory()) {
                log.catching((Throwable)new IllegalArgumentException("File " + targetDirectory.getPath() + " isn't a ConfigurationDirectory!"));
                return false;
            }
            newFile = new File(targetDirectory, fileName);
        } else {
            newFile = new File(N2ConfigApi.getConfigDir(), fileName);
        }
        for (ConfigFile currentFile : fileList.keySet()) {
            if (currentFile.getFileName() != configFile.getFileName()) continue;
            log.catching((Throwable)new IllegalArgumentException("Filename " + configFile.getFileName() + " already exist!"));
            return false;
        }
        if (!fileList.containsKey(configFile)) {
            if (ConfigHandler.getConfigFileFromName(configFile.getFileName()) != null) return true;
            fileList.put(configFile, newFile);
            return true;
        }
        log.warn("ConfigFile is already registered!");
        return false;
    }

    public static boolean removeConfigurationFile(String fileName) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return false;
        }
        boolean isSuccessFull = false;
        final ConfigFile configFile = ConfigHandler.getConfigFileFromName(fileName);
        isSuccessFull = ConfigHandler.removeConfigFile(configFile);
        if (isSuccessFull) {
            N2ConfigApiMessageHandler.syncDeleteConfigFile((List<ConfigFile>)new ArrayList<ConfigFile>(){
                {
                    this.add(configFile);
                }
            }, null);
        }
        return isSuccessFull;
    }

    public static void requestConfigFileDeletion(String fileName) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return;
        }
        final ConfigFile configFile = ConfigHandler.getConfigFileFromName(fileName);
        if (configFile != null) {
            // empty if block
        }
        N2ConfigApiMessageHandler.syncDeleteConfigFile((List<ConfigFile>)new ArrayList<ConfigFile>(){
            {
                this.add(configFile);
            }
        }, Minecraft.func_71410_x().field_71439_g.func_110124_au());
    }

    public static boolean removeConfigFile(ConfigFile configFile) {
        if (configFile != null && (FMLCommonHandler.instance().getEffectiveSide().isServer() || configFile.getProxySide().isClient()) && InitConfigObjectManager.removeConfigFile(configFile.getFileName())) {
            fileList.remove(configFile);
            return true;
        }
        return false;
    }

    public static void syncConfigFile(String fileName) {
        ConfigHandler.syncConfigFile(ConfigHandler.getConfigFileFromName(fileName));
    }

    public static void syncConfigFile(final ConfigFile configFile) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (configFile.getProxySide().isCommon()) {
            if (configFile.haveSectionChanged()) {
                ConfigHandler.syncFullConfigFile(configFile);
            } else {
                N2ConfigApiMessageHandler.syncValues((List<ConfigFile>)new ArrayList<ConfigFile>(){
                    {
                        this.add(configFile);
                    }
                }, null);
            }
        } else {
            log.catching((Throwable)new IllegalArgumentException("ConfigFile " + configFile.getFileName() + " is not a FileSide.Common type File!"));
        }
    }

    public static void SyncConfigFiles(List<ConfigFile> configFiles) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        ArrayList<ConfigFile> configFileList = new ArrayList<ConfigFile>();
        for (ConfigFile currentFile : configFiles) {
            if (!currentFile.getProxySide().isCommon()) continue;
            if (currentFile.haveSectionChanged()) {
                ConfigHandler.syncFullConfigFile(currentFile);
                continue;
            }
            configFileList.add(currentFile);
        }
        N2ConfigApiMessageHandler.syncValues(configFileList, null);
    }

    private static void syncFullConfigFile(ConfigFile configFile) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            N2ConfigApiMessageHandler.syncFullConfigFile(configFile, null);
        }
    }

    public static void forceCompleteSync(UUID playerID) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        for (ConfigFile currentFile : fileList.keySet()) {
            if (!currentFile.getProxySide().isCommon()) continue;
            N2ConfigApiMessageHandler.syncFullConfigFile(currentFile, playerID);
        }
    }

    public static void requestFullConfigFileSync(String fileName) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return;
        }
        ConfigFile configFile = ConfigHandler.getConfigFileFromName(fileName);
        if (configFile != null) {
            N2ConfigApiMessageHandler.syncFullConfigFile(configFile, Minecraft.func_71410_x().field_71439_g.func_110124_au());
        } else {
            log.catching((Throwable)new NullPointerException("Couldn't find ConfigFile " + fileName));
        }
    }

    public static void requestConfigFileValueSync(String fileName) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return;
        }
        final ConfigFile configFile = ConfigHandler.getConfigFileFromName(fileName);
        if (configFile != null) {
            N2ConfigApiMessageHandler.syncValues((List<ConfigFile>)new ArrayList<ConfigFile>(){
                {
                    this.add(configFile);
                }
            }, Minecraft.func_71410_x().field_71439_g.func_110124_au());
        } else {
            log.catching((Throwable)new NullPointerException("Couldn't find ConfigFile " + fileName));
        }
    }

    public static void backupConfigFile(String fileName) {
        ConfigFile configFile;
        if (backupList.isEmpty()) {
            DefaultConfigFile namesConfig = new DefaultConfigFile("2N4$7B@cNq", "");
            namesConfig.addNewStringSection("ConfigFileNames", null, "", false);
            backupList.add(namesConfig);
        }
        if ((configFile = ConfigHandler.getConfigFileFromName(fileName)) != null) {
            backupList.add(configFile);
        } else {
            ConfigSection section = backupList.get(0).getSubSection("ConfigFileNames");
            section.setDefaultValue((String)section.getDefaultValue() + ";" + fileName);
        }
    }

    public static void cleanUpTempServerFiles() {
        if (backupList.isEmpty()) {
            return;
        }
        String configNames = (String)backupList.get(0).getSubSection("ConfigFileNames").getDefaultValue();
        String[] nameArray = configNames.split(";");
        for (String currentName : nameArray) {
            ConfigHandler.removeConfigFile(ConfigHandler.getConfigFileFromName(currentName));
        }
        backupList.remove(0);
        for (ConfigFile currentFile : backupList) {
            ConfigFile sConfigFile = ConfigHandler.getConfigFileFromName(currentFile.getFileName());
            File file = fileList.get(sConfigFile);
            fileList.remove(sConfigFile);
            fileList.put(currentFile, file);
            currentFile.readAndSaveConfigValues();
        }
        backupList.clear();
    }

    private static void loadAndCheckAllConfigFiles() {
        try {
            ConfigHandler.generateAllFiles();
            for (ConfigFile current : fileList.keySet()) {
                List invalidSections = current.checkConfigFile();
                if (invalidSections != null) {
                    current.regenerateConfigFile(invalidSections);
                }
                current.readAndSaveConfigValues();
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public static boolean loadAndCheckConfigFile(String configFileName) {
        try {
            ConfigFile configFile = ConfigHandler.getConfigFileFromName(configFileName);
            if (configFile == null) {
                return false;
            }
            if (!configFile.getProxySide().isEffectiveSide(FMLCommonHandler.instance().getEffectiveSide())) {
                return false;
            }
            configFile.generateFile();
            configFile.readAndSaveConfigValues();
            ConfigHandler.generateSingleFile(configFile);
            List invalidSections = configFile.checkConfigFile();
            configFile.regenerateConfigFile(invalidSections);
            if (configFile.getProxySide().isCommon() && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                ConfigHandler.syncFullConfigFile(configFile);
            }
            return true;
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            return false;
        }
    }

    public static boolean loadConfigFile(String configFileName) {
        try {
            ConfigFile configFile = ConfigHandler.getConfigFileFromName(configFileName);
            if (configFile == null) {
                return false;
            }
            if (!configFile.getProxySide().isEffectiveSide(FMLCommonHandler.instance().getEffectiveSide())) {
                return false;
            }
            configFile.generateFile();
            configFile.readAndSaveConfigValues();
            ConfigHandler.generateSingleFile(configFile);
            if (configFile.getProxySide().isCommon() && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                ConfigHandler.syncFullConfigFile(configFile);
            }
            return true;
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            return false;
        }
    }

    public static boolean loadAndCheckConfigFileList(String[] configFileNames) {
        boolean checkSuccessful = true;
        try {
            for (int i = 0; i < configFileNames.length; ++i) {
                if (ConfigHandler.loadAndCheckConfigFile(configFileNames[i])) continue;
                checkSuccessful = false;
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
        return checkSuccessful;
    }

    public static boolean loadConfigFileList(String[] configFileNames) {
        boolean checkSuccessful = true;
        for (String configName : configFileNames) {
            if (ConfigHandler.loadConfigFile(configName)) continue;
            checkSuccessful = false;
        }
        return checkSuccessful;
    }

    public static File generateSingeFile(String originalFileName, FileType fileType, File originalFile, File targetDirectory) throws IOException {
        File target = null;
        if (targetDirectory != null) {
            if (targetDirectory.isDirectory()) {
                target = targetDirectory;
            } else {
                log.error("File isn't generated. Couldn't resolve targetDirectory!");
            }
        } else {
            log.error("File isn't generated. Couldn't resolve targetDirectory!");
        }
        File newFile = null;
        switch (fileType) {
            case Original: {
                newFile = originalFile;
                break;
            }
            case BackUp: {
                newFile = new File(target, originalFileName.substring(0, originalFileName.lastIndexOf(".") - 1) + "_BackUp.txt");
                break;
            }
            case Temp: {
                newFile = new File(target, originalFileName.substring(0, originalFileName.lastIndexOf(".") - 1) + "_Temp.tmp");
                break;
            }
            case Clone: {
                int i = 1;
                if (ConfigHandler.getConfigFileFromName(originalFileName) == null) {
                    newFile = new File(target, originalFileName);
                    break;
                }
                while ((newFile = new File(target, originalFileName + "_copy_" + i + originalFile.getName().substring(originalFileName.length(), originalFile.getName().length()))).exists()) {
                    ++i;
                }
                break;
            }
        }
        if (newFile.exists()) {
            newFile.delete();
        }
        newFile.createNewFile();
        if (fileType != FileType.Original) {
            ConfigHandler.copyFile(originalFile, newFile);
        }
        return newFile;
    }

    public static File generateSingleFileFromConfigFile(ConfigFile configFile, FileType fileType, File targetDirectory) throws IOException {
        return ConfigHandler.generateSingleFileFromConfigFile(null, configFile, fileType, targetDirectory);
    }

    public static File generateSingleFileFromConfigFile(String fileName, ConfigFile configFile, FileType fileType, File targetDirectory) {
        File file;
        if (configFile.getProxySide().isEffectiveSide(FMLCommonHandler.instance().getEffectiveSide()) || configFile.getProxySide().isClient() && configFile.isConnected()) {
            return null;
        }
        if (ConfigHandler.getConfigFileFromName(configFile.getFileName()) == null) {
            log.catching((Throwable)new IllegalArgumentException("ConfigFile " + configFile.getFileName() + " couldn't be found!"));
            return null;
        }
        File target = null;
        File originalFile = ConfigHandler.getFileFromConfigFile(configFile);
        String originalFileName = configFile.getFileName();
        target = targetDirectory == null ? originalFile.getParentFile() : targetDirectory;
        try {
            if (fileType.equals((Object)FileType.Clone)) {
                ConfigFile newConfigurationFile = configFile.CloneConfigurationFileInstance();
                if (fileName != null) {
                    newConfigurationFile.setFileName(fileName);
                    ConfigHandler.registerConfigFile(newConfigurationFile, target);
                    file = ConfigHandler.generateSingeFile(fileName, FileType.Original, ConfigHandler.getFileFromConfigFile(newConfigurationFile), target);
                } else {
                    file = ConfigHandler.generateSingeFile(fileName, FileType.Clone, ConfigHandler.getFileFromConfigFile(configFile), target);
                    newConfigurationFile.setFileName(file.getName().substring(0, file.getName().length() - 4));
                    ConfigHandler.registerConfigFile(newConfigurationFile, target);
                }
                newConfigurationFile.readAndSaveConfigValues();
            } else {
                file = ConfigHandler.generateSingeFile(originalFileName, fileType, originalFile, target);
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
            return null;
        }
        return file;
    }

    private static void generateAllFiles() throws IOException {
        for (ConfigFile currentConfigFile : fileList.keySet()) {
            if (currentConfigFile == null) continue;
            File file = ConfigHandler.getFileFromConfigFile(currentConfigFile);
            File dir = file.getParentFile();
            File dirtemp = N2ConfigApi.getTempDir(dir);
            dir.mkdirs();
            dirtemp.mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            currentConfigFile.generateFile();
            if (currentConfigFile.getIsWritten()) continue;
            currentConfigFile.writeAllSections();
        }
    }

    private static void generateSingleFile(ConfigFile configFile) throws IOException {
        if (!configFile.getProxySide().isEffectiveSide(FMLCommonHandler.instance().getEffectiveSide()) || configFile.isConnected()) {
            return;
        }
        if (ConfigHandler.getConfigFileFromName(configFile.getFileName()) == null) {
            log.catching((Throwable)new IllegalArgumentException("ConfigFile " + configFile.getFileName() + " Couldn't be found!"));
            return;
        }
        if (configFile != null) {
            File file = ConfigHandler.getFileFromConfigFile(configFile);
            File dir = file.getParentFile();
            File dirtemp = N2ConfigApi.getTempDir(dir);
            dir.mkdirs();
            dirtemp.mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            if (!configFile.getIsWritten()) {
                configFile.writeAllSections();
            }
        }
    }

    public static void copyFile(File oldFile, File copyFile) {
        try {
            if (oldFile != null && copyFile != null) {
                String readedLine;
                BufferedReader reader = new BufferedReader(new FileReader(oldFile));
                BufferedWriter writer = new BufferedWriter(new FileWriter(copyFile));
                while ((readedLine = reader.readLine()) != null) {
                    writer.append(readedLine);
                    writer.newLine();
                    writer.flush();
                }
                writer.close();
                reader.close();
            }
        }
        catch (Exception e) {
            log.catching((Throwable)e);
        }
    }

    public static File getFileFromConfigFile(ConfigFile configFile) {
        return fileList.get(configFile);
    }

    public static ConfigFile getConfigFileFromName(String configFileName) {
        for (ConfigFile file : fileList.keySet()) {
            if (!file.getFileName().equals(configFileName)) continue;
            return file;
        }
        return null;
    }

    public BufferedWriter getWriter(File file) throws IOException {
        return new BufferedWriter(new FileWriter(file));
    }

    public BufferedReader getReader(File file) throws IOException {
        return new BufferedReader(new FileReader(file));
    }

    public void closeWriter(BufferedWriter writer) throws IOException {
        writer.flush();
        writer.close();
    }

    public void closeReader(BufferedReader reader) throws IOException {
        reader.close();
    }

    public static enum ProxySide {
        Client,
        Server,
        Common;


        public boolean isEffectiveSide(Side proxySide) {
            switch (this) {
                case Client: {
                    return proxySide.isClient();
                }
                case Server: {
                    return proxySide.isServer();
                }
                case Common: {
                    return true;
                }
            }
            return false;
        }

        public boolean isServer() {
            return this == Server;
        }

        public boolean isClient() {
            return this == Client;
        }

        public boolean isCommon() {
            return this == Common;
        }
    }

    public static enum FileType {
        Original,
        BackUp,
        Temp,
        Clone;

    }
}

