/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.util.GT_LanguageManager;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ModularArmourUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles"), @Optional.Interface(iface="baubles.api.BaubleType", modid="Baubles")})
public class BaseBauble
extends Item
implements IBauble {
    private BaubleType mThisBauble;
    private List<String> damageNegations = new ArrayList<String>();
    Multimap<String, AttributeModifier> attributes = HashMultimap.create();

    public BaseBauble(BaubleType type, String displayName) {
        this.mThisBauble = type;
        Utils.registerEvent((Object)this);
        this.func_77625_d(1);
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.func_77655_b(Utils.sanitizeString(displayName.toLowerCase()));
        GT_LanguageManager.addStringLocalization((String)("gtplusplus." + this.func_77658_a() + ".name"), (String)displayName);
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public BaseBauble(BaubleType type, String unlocalName, int register) {
        this.mThisBauble = type;
        Utils.registerEvent((Object)this);
        this.func_77625_d(1);
        this.func_77637_a(AddToCreativeTab.tabMisc);
    }

    public String func_77653_i(ItemStack tItem) {
        String key = "gtplusplus." + this.func_77658_a() + ".name";
        if (key.equals(GT_LanguageManager.getTranslation((String)key))) {
            return super.func_77653_i(tItem).replaceAll(".name", "");
        }
        return GT_LanguageManager.getTranslation((String)key);
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && this.getCorrectBauble(player = (EntityPlayer)event.entityLiving) != null && this.damageNegations.contains(event.source.field_76373_n)) {
            event.setCanceled(true);
        }
    }

    public boolean addDamageNegation(DamageSource damageSource) {
        return this.addDamageNegation(damageSource, null);
    }

    public boolean addDamageNegation(DamageSource damageSource, ItemStack aStack) {
        return this.damageNegations.add(damageSource.field_76373_n);
    }

    public void clearDamageNegation() {
        this.damageNegations.clear();
    }

    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return EntityPlayer.class.isInstance(arg1);
    }

    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return EntityPlayer.class.isInstance(arg1);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return this.mThisBauble;
    }

    public boolean SetBaubleType(ModularArmourUtils.BT arg0) {
        return this.SetBaubleType(arg0.getType());
    }

    public boolean SetBaubleType(BaubleType arg0) {
        BaubleType temp = this.mThisBauble;
        this.mThisBauble = arg0;
        return this.mThisBauble != temp;
    }

    public void onEquipped(ItemStack stack, EntityLivingBase entity) {
        if (entity != null && EntityPlayer.class.isInstance(entity)) {
            this.onEquippedOrLoadedIntoWorld(stack, entity);
            BaseBauble.setPlayerHashcode(stack, entity.hashCode());
        }
    }

    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (BaseBauble.getPlayerHashcode(stack) != player.hashCode()) {
            this.onEquippedOrLoadedIntoWorld(stack, player);
            BaseBauble.setPlayerHashcode(stack, player.hashCode());
        }
    }

    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        this.fillModifiers(this.attributes, stack);
        player.func_110140_aT().func_111147_b(this.attributes);
    }

    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        this.fillModifiers(this.attributes, stack);
        player.func_110140_aT().func_111148_a(this.attributes);
    }

    void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
    }

    public ItemStack getCorrectBauble(EntityPlayer player) {
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
        ItemStack stack1 = baubles.func_70301_a(1);
        ItemStack stack2 = baubles.func_70301_a(2);
        return this.isCorrectBauble(stack1) ? stack1 : (this.isCorrectBauble(stack2) ? stack2 : null);
    }

    private boolean isCorrectBauble(ItemStack stack) {
        return stack != null && stack.func_77973_b() == this;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public static UUID getBaubleUUID(ItemStack stack) {
        long most = NBTUtils.getLong(stack, "baubleUUIDMost");
        if (most == 0L) {
            UUID uuid = UUID.randomUUID();
            NBTUtils.setLong(stack, "baubleUUIDMost", uuid.getMostSignificantBits());
            NBTUtils.setLong(stack, "baubleUUIDLeast", uuid.getLeastSignificantBits());
            return BaseBauble.getBaubleUUID(stack);
        }
        long least = NBTUtils.getLong(stack, "baubleUUIDLeast");
        return new UUID(most, least);
    }

    public static int getPlayerHashcode(ItemStack stack) {
        return NBTUtils.getInteger(stack, "mPlayerHashcode");
    }

    public static void setPlayerHashcode(ItemStack stack, int hash) {
        NBTUtils.setInteger(stack, "mPlayerHashcode", hash);
    }
}

