/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkDebugger {
    public static final Map<Integer, Pair<String, String>> mChunkTicketsMap = new LinkedHashMap<Integer, Pair<String, String>>();
    public static final Map<String, Pair<String, String>> mChunksLoadedByModsMap = new LinkedHashMap<String, Pair<String, String>>();

    public static void storeTicketToCache(ForgeChunkManager.Ticket aTicket, World aWorld) {
        mChunkTicketsMap.put(aTicket.hashCode(), new Pair<String, String>(aTicket.getModId(), "" + aTicket.world.field_73011_w.field_76574_g));
        Logger.REFLECTION("Ticket created by " + aTicket.getModId() + " for dimension " + aTicket.world.field_73011_w.field_76574_g);
    }

    public static void storeLoadChunkToCache(ForgeChunkManager.Ticket aTicket, ChunkCoordIntPair aChunk) {
        mChunksLoadedByModsMap.put(aChunk.toString(), new Pair<String, String>(aTicket.getModId(), aChunk.toString()));
        Logger.REFLECTION("Chunk Loaded by " + aTicket.getModId() + " at position " + aChunk.toString() + " for dimension " + aTicket.world.field_73011_w.field_76574_g);
    }

    public static void removeTicketFromCache(ForgeChunkManager.Ticket aTicket) {
        Pair<String, String> aPair = mChunkTicketsMap.get(aTicket.hashCode());
        String aKey = aPair.getKey();
        if (aKey == null) {
            aKey = "Invalid ModId";
        }
        Logger.REFLECTION("Ticket released by " + aKey + " for dimension " + aTicket.world.field_73011_w.field_76574_g);
        mChunkTicketsMap.remove(aTicket.hashCode());
    }

    public static void removeLoadedChunkFromCache(ChunkCoordIntPair aChunk) {
        if (aChunk == null || aChunk.toString() == null) {
            return;
        }
        Pair<String, String> aPair = mChunksLoadedByModsMap.get(aChunk.toString());
        if (aPair == null) {
            return;
        }
        String aKey = aPair.getKey();
        String aValue = aPair.getValue();
        if (aKey != null && aValue != null) {
            Logger.REFLECTION("Chunk Unloaded by " + aKey + " at position " + aChunk.toString() + "");
        }
        mChunksLoadedByModsMap.remove(aChunk.toString());
    }
}

