/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.tileentities.boilers.GT_MetaTileEntity_Boiler;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.gui.GTPP_UITextures;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import org.apache.commons.lang3.ArrayUtils;

public class GT_MetaTileEntity_Boiler_Base
extends GT_MetaTileEntity_Boiler {
    private final int steamPerSecond;
    private final int tier;

    public GT_MetaTileEntity_Boiler_Base(int aID, String aNameRegional, int tier) {
        super(aID, "electricboiler." + tier + ".tier.single", aNameRegional, "Produces " + CORE.ConfigSwitches.boilerSteamPerSecond * tier + "L of Steam per second", new ITexture[0]);
        this.steamPerSecond = CORE.ConfigSwitches.boilerSteamPerSecond * tier;
        this.tier = tier;
    }

    public GT_MetaTileEntity_Boiler_Base(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.steamPerSecond = CORE.ConfigSwitches.boilerSteamPerSecond * aTier;
        this.tier = aTier;
    }

    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Produces " + this.getPollution() + " pollution/sec", "Consumes fuel only when temperature is less than 100C", "Fuel with burn time greater than 500 is more efficient.", "Doesn't explode if there's no water", CORE.GT_Tooltip.get()});
    }

    public ITexture getOverlayIcon() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.BOILER_FRONT);
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    protected GT_RenderedTexture getCasingTexture() {
        if (this.tier == 1) {
            return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_LV_SIDE);
        }
        if (this.tier == 2) {
            return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_MV_SIDE);
        }
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_HV_SIDE);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.tier][aColor + 1], this.getCasingTexture()};
    }

    public ITexture[] getBack(byte aColor) {
        return this.getSides(aColor);
    }

    public ITexture[] getBottom(byte aColor) {
        return this.getSides(aColor);
    }

    public ITexture[] getTop(byte aColor) {
        return this.getSides(aColor);
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.tier][aColor + 1], this.getCasingTexture()};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return this.getFront(aColor);
    }

    public ITexture[] getBackActive(byte aColor) {
        return this.getSides(aColor);
    }

    public ITexture[] getBottomActive(byte aColor) {
        return this.getBottom(aColor);
    }

    public ITexture[] getTopActive(byte aColor) {
        return this.getTop(aColor);
    }

    public ITexture[] getSidesActive(byte aColor) {
        return this.getSides(aColor);
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isFacingValid(ForgeDirection side) {
        return side.offsetY == 0;
    }

    public int maxProgresstime() {
        return 1000 + 250 * this.tier;
    }

    public boolean isElectric() {
        return false;
    }

    public int getCapacity() {
        return 16000 + 16000 * this.tier;
    }

    public int getSteamCapacity() {
        return 2 * this.getCapacity();
    }

    protected int getProductionPerSecond() {
        return this.steamPerSecond;
    }

    protected int getMaxTemperature() {
        return this.maxProgresstime();
    }

    protected int getEnergyConsumption() {
        return 2;
    }

    protected int getCooldownInterval() {
        return 40;
    }

    protected int getHeatUpRate() {
        return 10;
    }

    protected void updateFuel(IGregTechTileEntity tile, long ticks) {
        ItemStack fuelStack = this.mInventory[2];
        if (fuelStack == null) {
            return;
        }
        int burnTime = GT_MetaTileEntity_Boiler_Base.getBurnTime(fuelStack);
        if (burnTime > 0 && this.mTemperature <= 101) {
            this.consumeFuel(tile, fuelStack, burnTime);
        }
    }

    protected void produceSteam(int aAmount) {
        super.produceSteam(aAmount);
        if (this.mSteam.amount > this.getSteamCapacity()) {
            this.sendSound((byte)1);
            this.mSteam.amount = this.getSteamCapacity();
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        return new FluidTankInfo[]{new FluidTankInfo(this.mFluid, this.getCapacity()), new FluidTankInfo(this.mSteam, this.getSteamCapacity())};
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == 1 || aIndex == 3;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex == 2;
    }

    protected int getPollution() {
        return (int)((double)CORE.ConfigSwitches.basePollutionPerSecondBoiler * CORE.ConfigSwitches.pollutionReleasedByTierBoiler[this.tier]);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boiler_Base(this.mName, this.tier, this.mDescriptionArray, this.mTextures);
    }

    protected void onDangerousWaterLack(IGregTechTileEntity tile, long ticks) {
    }

    private static int getBurnTime(ItemStack stack) {
        int burnTime = GameRegistry.getFuelValue((ItemStack)stack);
        if (burnTime <= 0) {
            burnTime = TileEntityFurnace.func_145952_a((ItemStack)stack);
        }
        return burnTime;
    }

    public void consumeFuel(IGregTechTileEntity tile, ItemStack fuel, int burnTime) {
        this.mProcessingEnergy += burnTime / 10;
        this.mTemperature += burnTime / 500;
        tile.func_70298_a(2, 1);
        if (tile.getRandomNumber(3) == 0) {
            if (fuel.func_82833_r().toLowerCase().contains("charcoal") || fuel.func_82833_r().toLowerCase().contains("coke")) {
                tile.addStackToSlot(3, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Ash, (long)1L));
            } else {
                tile.addStackToSlot(3, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)1L));
            }
        }
    }

    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aCover) {
        if (side != this.getBaseMetaTileEntity().getFrontFacing()) {
            return true;
        }
        return super.allowCoverOnSide(side, aCover);
    }

    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.DEFAULT;
    }

    protected IDrawable[] getFuelSlotBackground() {
        return new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTPP_UITextures.OVERLAY_SLOT_COAL};
    }

    protected IDrawable[] getAshSlotBackground() {
        return new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_DUST};
    }

    public int getTitleColor() {
        return (Integer)this.COLOR_TITLE.get();
    }

    protected IDrawable getOverlaySlotIn() {
        return GT_UITextures.OVERLAY_SLOT_IN;
    }

    protected IDrawable getOverlaySlotOut() {
        return GT_UITextures.OVERLAY_SLOT_OUT;
    }

    protected IDrawable getOverlaySlotCanister() {
        return GTPP_UITextures.OVERLAY_SLOT_CANISTER_DARK;
    }

    protected UITexture getProgressbarEmpty() {
        return GTPP_UITextures.PROGRESSBAR_BOILER_EMPTY;
    }

    protected UITexture getProgressbarFuel() {
        return GTPP_UITextures.PROGRESSBAR_FUEL;
    }
}

