/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_MassFabricator
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_MassFabricator>
implements ISurvivalConstructable {
    public static int sUUAperUUM = 1;
    public static int sUUASpeedBonus = 4;
    public static int sDurationMultiplier = 3200;
    public int mMatterProduced = 0;
    public int mScrapProduced = 0;
    public int mAmplifierProduced = 0;
    public int mScrapUsed = 0;
    public int mAmplifierUsed = 0;
    public static String mCasingName1 = "Matter Fabricator Casing";
    public static String mCasingName2 = "Containment Casing";
    public static String mCasingName3 = "Matter Generation Coil";
    private int mMode = 0;
    private static final int MODE_SCRAP = 1;
    private static final int MODE_UU = 0;
    public static boolean sRequiresUUA = false;
    private static FluidStack[] mUU = new FluidStack[2];
    private static ItemStack[] mScrap = new ItemStack[2];
    private int mCasing;
    private static IStructureDefinition<GregtechMetaTileEntity_MassFabricator> STRUCTURE_DEFINITION = null;
    public static boolean sInit = false;

    public int getAmplifierUsed() {
        return this.mAmplifierUsed;
    }

    public int getMatterProduced() {
        return this.mMatterProduced;
    }

    public int getScrapProduced() {
        return this.mScrapProduced;
    }

    public GregtechMetaTileEntity_MassFabricator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_MassFabricator(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Mass Fabricator / Recycler";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Matter Fabricator").addInfo("Speed: +0% | EU Usage: 80%").addInfo("Parallel: Scrap = 64 | UU = 8 * Tier").addInfo("Produces UU-A, UU-M & Scrap").addInfo("Change mode with screwdriver").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(5, 4, 5, true).addController("Front Center").addCasingInfoMin(mCasingName3, 9, false).addCasingInfoMin(mCasingName2, 24, false).addCasingInfoMin(mCasingName1, 40, false).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active_Animated;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Animated;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(9);
    }

    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        sDurationMultiplier = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUM_Duration_Multiplier", sDurationMultiplier);
        sUUAperUUM = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_per_UUM", sUUAperUUM);
        sUUASpeedBonus = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Speed_Bonus", sUUASpeedBonus);
        sRequiresUUA = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Requirement", sRequiresUUA);
    }

    public boolean checkRecipe(ItemStack aStack) {
        ArrayList tItems = this.getStoredInputs();
        ArrayList tFluids = this.getStoredFluids();
        ItemStack[] tItemInputs = tItems.toArray(new ItemStack[tItems.size()]);
        FluidStack[] tFluidInputs = tFluids.toArray(new FluidStack[tFluids.size()]);
        GregtechMetaTileEntity_MassFabricator.init();
        return this.checkRecipeGeneric(tItemInputs, tFluidInputs, 4, 80L, 0, 10000);
    }

    public static void init() {
        if (!sInit) {
            if (mScrap[0] == null) {
                GregtechMetaTileEntity_MassFabricator.mScrap[0] = ItemUtils.getSimpleStack(ItemUtils.getItemFromFQRN("IC2:itemScrap"));
            }
            if (mScrap[1] == null) {
                GregtechMetaTileEntity_MassFabricator.mScrap[1] = ItemUtils.getSimpleStack(ItemUtils.getItemFromFQRN("IC2:itemScrapbox"));
            }
            if (mUU[0] == null) {
                GregtechMetaTileEntity_MassFabricator.mUU[0] = Materials.UUAmplifier.getFluid(100L);
            }
            if (mUU[1] == null) {
                GregtechMetaTileEntity_MassFabricator.mUU[1] = Materials.UUMatter.getFluid(100L);
            }
            sInit = true;
        }
    }

    public IStructureDefinition<GregtechMetaTileEntity_MassFabricator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CC~CC", "CHHHC", "CHHHC", "CHHHC", "CCCCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_MassFabricator.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.GTPP_INDEX(9)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)9))})).addElement('H', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)8)).addElement('G', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)15)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 2, 3, 0) && this.mCasing >= 40 && this.checkHatch();
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiMassFabricator;
    }

    @Override
    public int getAmountOfOutputs() {
        return 10;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_MassFabricator(this.mName);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return this.mMode == 1 ? GT_Recipe.GT_Recipe_Map.sRecyclerRecipes : GTPP_Recipe.GTPP_Recipe_Map.sMatterFab2Recipes;
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        if (this.mMode == 1) {
            return this.checkRecipeScrap(aItemInputs, aFluidInputs, this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), aSpeedBonusPercent, aOutputChanceRoll);
        }
        return this.checkRecipeUU(aItemInputs, aFluidInputs, this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), aSpeedBonusPercent, aOutputChanceRoll);
    }

    public boolean checkRecipeScrap(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        ItemStack[] itemStackArray;
        if (aItemInputs == null || aItemInputs.length <= 0) {
            return false;
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        ItemStack aPotentialOutput = GT_ModHandler.getRecyclerOutput((ItemStack)GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aItemInputs[0]}), (int)0);
        ItemStack[] itemStackArray2 = new ItemStack[]{GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aItemInputs[0]})};
        if (aPotentialOutput == null) {
            itemStackArray = null;
        } else {
            ItemStack[] itemStackArray3 = new ItemStack[1];
            itemStackArray = itemStackArray3;
            itemStackArray3[0] = aPotentialOutput;
        }
        GTPP_Recipe tRecipe = new GTPP_Recipe(false, itemStackArray2, itemStackArray, null, new int[]{2000}, null, null, 40, MaterialUtils.getVoltageForTier(1), 0);
        GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe((GT_Recipe)tRecipe).setItemInputs(aItemInputs).setFluidInputs(aFluidInputs).setAvailableEUt(tEnergy).setMaxParallel(aMaxParallelRecipes).enableConsumption().enableOutputCalculation().setController((GT_MetaTileEntity_MultiBlockBase)this);
        if (this.batchMode) {
            helper.enableBatchMode(128);
        }
        helper.build();
        if (helper.getCurrentParallel() == 0) {
            return false;
        }
        GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)tRecipe.mEUt).setEUt(tEnergy).setDuration(tRecipe.mDuration).setEUtDiscount((float)aEUPercent / 100.0f).setSpeedBoost(100.0f / (100.0f + (float)aSpeedBonusPercent)).setParallel(helper.getCurrentParallel()).calculate();
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = (int)Math.ceil((float)calculator.getDuration() * helper.getDurationMultiplier());
        this.mOutputItems = helper.getItemOutputs();
        this.mOutputFluids = helper.getFluidOutputs();
        this.updateSlots();
        this.startProcess();
        return true;
    }

    public boolean checkRecipeUU(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        GT_Recipe tRecipe;
        this.lEUt = 0L;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.mLastRecipe = tRecipe = this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        if (tRecipe == null) {
            return false;
        }
        GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe(tRecipe).setItemInputs(aItemInputs).setFluidInputs(aFluidInputs).setAvailableEUt(tEnergy).setMaxParallel(aMaxParallelRecipes).enableConsumption().enableOutputCalculation().setEUtModifier((float)aEUPercent / 100.0f).setController((GT_MetaTileEntity_MultiBlockBase)this);
        if (this.batchMode) {
            helper.enableBatchMode(128);
        }
        helper.build();
        if (helper.getCurrentParallel() == 0) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt((long)tRecipe.mEUt).setEUt(tEnergy).setDuration(tRecipe.mDuration).setEUtDiscount((float)aEUPercent / 100.0f).setSpeedBoost(100.0f / (100.0f + (float)aSpeedBonusPercent)).setParallel((int)Math.floor((float)helper.getCurrentParallel() / helper.getDurationMultiplier())).enablePerfectOC().calculate();
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = (int)Math.ceil((float)calculator.getDuration() * helper.getDurationMultiplier());
        this.mOutputItems = helper.getItemOutputs();
        this.mOutputFluids = helper.getFluidOutputs();
        int aMatterProduced = 0;
        int aAmplifierProduced = 0;
        int aScrapUsed = 0;
        int aAmplifierUsed = 0;
        for (int i = 0; i < helper.getCurrentParallel(); ++i) {
            for (ItemStack itemStack : tRecipe.mInputs) {
                if (itemStack == null || !GT_Utility.areStacksEqual((ItemStack)itemStack, (ItemStack)mScrap[0], (boolean)true)) continue;
                aScrapUsed += itemStack.field_77994_a;
            }
            for (ItemStack itemStack : tRecipe.mFluidInputs) {
                if (itemStack == null || !GT_Utility.areFluidsEqual((FluidStack)itemStack, (FluidStack)mUU[0], (boolean)true)) continue;
                aAmplifierUsed += itemStack.amount;
            }
            for (ItemStack itemStack : tRecipe.mFluidOutputs) {
                if (itemStack != null && GT_Utility.areFluidsEqual((FluidStack)itemStack, (FluidStack)mUU[0], (boolean)true)) {
                    aAmplifierProduced += itemStack.amount;
                }
                if (itemStack == null || !GT_Utility.areFluidsEqual((FluidStack)itemStack, (FluidStack)mUU[1], (boolean)true)) continue;
                aMatterProduced += itemStack.amount;
            }
        }
        this.mMatterProduced += aMatterProduced;
        this.mAmplifierProduced += aAmplifierProduced;
        this.mScrapUsed += aScrapUsed;
        this.mAmplifierUsed += aAmplifierUsed;
        this.updateSlots();
        this.startProcess();
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mMode == 1 ? 64 : 8 * Math.max(1, GT_Utility.getTier((long)this.getMaxInputVoltage()));
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 80;
    }

    @Override
    public void onModeChangeByScrewdriver(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int aMode = this.mMode + 1;
        if (aMode > 1) {
            this.mMode = 0;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Matter/AmpliFabricator");
        } else if (aMode == 1) {
            this.mMode = 1;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Recycler");
        } else {
            this.mMode = 1;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Recycler");
        }
        this.mLastRecipe = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mScrapProduced", this.mScrapProduced);
        aNBT.func_74768_a("mAmplifierProduced", this.mAmplifierProduced);
        aNBT.func_74768_a("mMatterProduced", this.mMatterProduced);
        aNBT.func_74768_a("mScrapUsed", this.mScrapUsed);
        aNBT.func_74768_a("mAmplifierUsed", this.mAmplifierUsed);
        aNBT.func_74768_a("mMode", this.mMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mScrapProduced = aNBT.func_74762_e("mScrapProduced");
        this.mAmplifierProduced = aNBT.func_74762_e("mAmplifierProduced");
        this.mMatterProduced = aNBT.func_74762_e("mMatterProduced");
        this.mScrapUsed = aNBT.func_74762_e("mScrapUsed");
        this.mAmplifierUsed = aNBT.func_74762_e("mAmplifierUsed");
        this.mMode = aNBT.func_74762_e("mMode");
        super.loadNBTData(aNBT);
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)((Column)screenElements.widget(TextWidget.dynamicString(() -> "Scrap Made: " + this.mScrapProduced).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()))).widget(TextWidget.dynamicString(() -> "Scrap Used: " + this.mScrapUsed).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()))).widget(TextWidget.dynamicString(() -> "UUA Made: " + this.mAmplifierProduced).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()))).widget(TextWidget.dynamicString(() -> "UUA Used: " + this.mAmplifierUsed).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()))).widget(TextWidget.dynamicString(() -> "UUM Made: " + this.mMatterProduced).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0 && this.getBaseMetaTileEntity().isActive()));
    }
}

