/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Turbine;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MTE_LargeTurbine_Plasma
extends GregtechMetaTileEntity_LargerTurbineBase {
    private static final HashSet<Fluid> BLACKLIST = new HashSet();

    public GT_MTE_LargeTurbine_Plasma(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MTE_LargeTurbine_Plasma(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MTE_LargeTurbine_Plasma(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 4;
    }

    @Override
    public int getCasingTextureIndex() {
        return 60;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return true;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GT_Recipe tFuel = GT_Recipe.GT_Recipe_Map.sPlasmaFuels.findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        try {
            ArrayList<GT_MetaTileEntity_Hatch_Turbine> aEmptyTurbineRotorHatches = this.getEmptyTurbineAssemblies();
            if (aEmptyTurbineRotorHatches.size() > 0) {
                this.log("Found " + aEmptyTurbineRotorHatches.size() + " Assemblies without Turbine.");
                block2: for (GT_MetaTileEntity_Hatch_Turbine gT_MetaTileEntity_Hatch_Turbine : aEmptyTurbineRotorHatches) {
                    ArrayList<ItemStack> aTurbines = this.getAllBufferedTurbines();
                    for (ItemStack aTurbineItem : aTurbines) {
                        if (aTurbineItem == null || !gT_MetaTileEntity_Hatch_Turbine.insertTurbine(aTurbineItem.func_77946_l())) continue;
                        boolean aDidDeplete = this.depleteTurbineFromStock(aTurbineItem);
                        this.log("Put Turbine into Assembly - " + aDidDeplete);
                        continue block2;
                    }
                }
            }
            if (this.getEmptyTurbineAssemblies().size() > 0 || !this.areAllTurbinesTheSame()) {
                this.log("BAD RETURN - 1");
                this.stopMachine();
                return false;
            }
            ArrayList tFluids = this.getStoredFluids();
            if (tFluids.size() > 0) {
                for (FluidStack fluid : tFluids) {
                    if (fluid == null || !BLACKLIST.contains(fluid.getFluid())) continue;
                    return false;
                }
                if (this.baseEff == 0 || this.optFlow == 0L || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                    this.counter = 0;
                    float f = 0.0f;
                    float aTotalOptimalFlow = 0.0f;
                    ItemStack aStack = this.getFullTurbineAssemblies().get(0).getTurbine();
                    f += (float)GT_Utility.safeInt((long)((long)((5.0f + ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolCombatDamage(aStack)) * 1000.0f)));
                    double aEUPerTurbine = (double)((aTotalOptimalFlow += (float)GT_Utility.safeInt((long)((long)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolStats(aStack).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mToolSpeed * 50.0f)))) * 40.0f) * 0.0105 * (double)GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mPlasmaMultiplier * (double)(50.0f + 10.0f * ((GT_MetaGenerated_Tool)aStack.func_77973_b()).getToolCombatDamage(aStack));
                    if ((aTotalOptimalFlow *= (float)this.getSpeedMultiplier()) < 0.0f) {
                        this.log("Int overflow, report to issue tracker");
                        aTotalOptimalFlow = 100.0f;
                    }
                    this.flowMultipliers[0] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mSteamMultiplier;
                    this.flowMultipliers[1] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mGasMultiplier;
                    this.flowMultipliers[2] = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mPlasmaMultiplier;
                    this.baseEff = MathUtils.roundToClosestInt(f);
                    this.optFlow = MathUtils.roundToClosestInt(aTotalOptimalFlow);
                    this.euPerTurbine = MathUtils.roundToClosestInt(aEUPerTurbine);
                    if (this.optFlow <= 0L || this.baseEff <= 0) {
                        this.stopMachine();
                        return false;
                    }
                } else {
                    ++this.counter;
                }
            }
            int n = this.fluidIntoPower(tFluids, this.optFlow, this.baseEff, this.flowMultipliers);
            int fuelValue = this.getFuelValue(new FluidStack((FluidStack)tFluids.get(0), 0));
            float magicValue = (float)fuelValue * 0.005f * ((float)fuelValue * 0.005f);
            float efficiencyLoss = Math.min(1.0f, magicValue / (float)this.euPerTurbine);
            int n2 = (int)((float)n * efficiencyLoss);
            long difference = (long)n2 - this.lEUt;
            int maxChangeAllowed = Math.max(10, GT_Utility.safeInt((long)(Math.abs(difference) / 100L)));
            if (Math.abs(difference) > (long)maxChangeAllowed) {
                int change = maxChangeAllowed * (difference > 0L ? 1 : -1);
                this.lEUt += (long)change;
            } else {
                this.lEUt = n2;
            }
            if (this.lEUt <= 0L) {
                this.lEUt = 0L;
                this.mEfficiency = 0;
                this.log("Running checkRecipeGeneric(bad-2)");
                return false;
            }
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10;
            this.startProcess();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, long aOptFlow, int aBaseEff, float[] flowMultipliers) {
        if (aFluids.size() >= 1) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            actualOptimalFlow = GT_Utility.safeInt((long)((long)Math.ceil((double)(aOptFlow *= 800L) * (double)flowMultipliers[2] / (double)fuelValue)));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GT_Utility.safeInt((long)((long)((float)actualOptimalFlow * 1.25f)));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            String fn = FluidRegistry.getFluidName((FluidStack)firstFuelType);
            String[] nameSegments = fn.split("\\.", 2);
            if (nameSegments.length == 2) {
                String outputName = nameSegments[1];
                FluidStack output = FluidRegistry.getFluidStack((String)outputName, (int)totalFlow);
                if (output == null) {
                    output = FluidRegistry.getFluidStack((String)("molten." + outputName), (int)totalFlow);
                }
                if (output != null) {
                    this.addOutput(output);
                }
            }
            if (totalFlow <= 0) {
                return 0;
            }
            tEU = GT_Utility.safeInt((long)((long)((double)fuelValue / 20.0 * (double)totalFlow)));
            if (totalFlow == actualOptimalFlow) {
                tEU = GT_Utility.safeInt((long)((long)((double)aBaseEff / 10000.0 * (double)tEU)));
            } else {
                double efficiency = 1.0 - (double)Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
                tEU = (int)((double)tEU * efficiency);
                tEU = GT_Utility.safeInt((long)((long)((double)aBaseEff / 10000.0 * (double)tEU)));
            }
            return tEU;
        }
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public String getMachineType() {
        return "Large Plasma Turbine";
    }

    @Override
    protected String getTurbineType() {
        return "Plasma";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced Plasma Turbine Casing";
    }

    @Override
    protected ITexture getTextureFrontFace() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_TU5);
    }

    @Override
    protected ITexture getTextureFrontFaceActive() {
        return new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.LARGETURBINE_TU_ACTIVE5);
    }
}

