/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.item;

import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.inventory.InventoryCopterPack;
import com.darkona.adventurebackpack.item.ItemAdventure;
import com.darkona.adventurebackpack.network.GUIPacket;
import com.darkona.adventurebackpack.network.messages.EntityParticlePacket;
import com.darkona.adventurebackpack.proxy.ClientProxy;
import com.darkona.adventurebackpack.reference.GeneralReference;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.TipUtils;
import com.darkona.adventurebackpack.util.Wearing;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;

public class ItemCopterPack
extends ItemAdventure {
    public static byte OFF_MODE = 0;
    public static byte NORMAL_MODE = 1;
    public static byte HOVER_MODE = (byte)2;
    private float fuelSpent;

    public ItemCopterPack() {
        this.func_77655_b("copterPack");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(BackpackUtils.createCopterStack());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltips, boolean advanced) {
        FluidTank fuelTank = new FluidTank(16000);
        NBTTagCompound copterTag = BackpackUtils.getWearableCompound(stack);
        if (GuiScreen.func_146272_n()) {
            fuelTank.readFromNBT(copterTag.func_74775_l("fuelTank"));
            tooltips.add(TipUtils.l10n("copter.tank.fuel") + ": " + TipUtils.tankTooltip(fuelTank));
            tooltips.add(TipUtils.l10n("copter.rate.fuel") + ": " + TipUtils.fuelConsumptionTooltip(fuelTank));
            TipUtils.shiftFooter(tooltips);
        } else if (!GuiScreen.func_146271_m()) {
            tooltips.add(TipUtils.holdShift());
        }
        if (GuiScreen.func_146271_m()) {
            tooltips.add(TipUtils.l10n("max.altitude") + ": " + TipUtils.whiteFormat("250 ") + TipUtils.l10n("meters"));
            tooltips.add(TipUtils.pressShiftKeyFormat(TipUtils.actionKeyFormat()) + TipUtils.l10n("copter.key.onoff1"));
            tooltips.add(TipUtils.l10n("copter.key.onoff2") + " " + TipUtils.l10n("on"));
            tooltips.add(TipUtils.pressKeyFormat(TipUtils.actionKeyFormat()) + TipUtils.l10n("copter.key.hover1"));
            tooltips.add(TipUtils.l10n("copter.key.hover2"));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            ModNetwork.net.sendToServer((IMessage)new GUIPacket.GUImessage(2, 1));
        }
        return stack;
    }

    @Override
    public void onEquipped(World world, EntityPlayer player, ItemStack stack) {
        BackpackUtils.getWearableCompound(stack).func_74774_a("status", OFF_MODE);
    }

    @Override
    public void onEquippedUpdate(World world, EntityPlayer player, ItemStack stack) {
        InventoryCopterPack inv = new InventoryCopterPack(Wearing.getWearingCopter(player));
        inv.func_70295_k_();
        boolean canElevate = true;
        float fuelConsumption = 0.0f;
        if (inv.getStatus() != OFF_MODE) {
            if (player.func_70090_H()) {
                inv.setStatus(OFF_MODE);
                inv.dirtyStatus();
                if (!world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.copterpack.cantwater", new Object[0]));
                }
                return;
            }
            if (inv.getFuelTank().getFluidAmount() == 0) {
                canElevate = false;
                if (player.field_70122_E) {
                    inv.setStatus(OFF_MODE);
                    inv.dirtyStatus();
                    if (!world.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.copterpack.off", new Object[0]));
                    }
                    return;
                }
                if (inv.getStatus() == HOVER_MODE) {
                    inv.setStatus(NORMAL_MODE);
                    inv.dirtyStatus();
                    if (!world.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("adventurebackpack:messages.copterpack.outoffuel", new Object[0]));
                    }
                    return;
                }
            }
        }
        if (inv.getStatus() != OFF_MODE) {
            fuelConsumption += 1.0f;
            if (inv.getStatus() == NORMAL_MODE) {
                if (!player.field_70122_E && !player.func_70093_af() && player.field_70181_x < 0.0) {
                    player.field_70181_x *= 0.6;
                }
                if (player.func_70093_af()) {
                    player.field_70181_x = -0.3;
                }
            }
            if (inv.getStatus() == HOVER_MODE) {
                if (player.func_70093_af()) {
                    player.field_70181_x = -0.3;
                } else {
                    fuelConsumption *= 2.0f;
                    player.field_70181_x = 0.0;
                }
            }
            player.field_70143_R = 0.0f;
            if (!world.field_72995_K) {
                ModNetwork.sendToNearby(new EntityParticlePacket.Message(1, (Entity)player), player);
            }
            float factor = 0.05f;
            if (!player.field_70122_E) {
                this.pushEntities(world, player, 0.2f);
                player.func_70060_a(player.field_70702_br, player.field_70701_bs, factor);
            } else {
                this.pushEntities(world, player, factor + 0.4f);
            }
            if (world.field_72995_K && Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d() && inv.canConsumeFuel((int)Math.ceil(fuelConsumption * 2.0f)) && canElevate) {
                ItemCopterPack.elevate(player, stack);
            }
            if (!player.field_70122_E && player.field_70181_x > 0.0) {
                fuelConsumption *= 2.0f;
            }
            int ticks = inv.getTickCounter() - 1;
            FluidTank tank = inv.getFuelTank();
            if (tank.getFluid() != null && GeneralReference.isValidFuel(tank.getFluid().getFluid().getName())) {
                fuelConsumption *= GeneralReference.getFuelRate(tank.getFluid().getFluid().getName()).floatValue();
            }
            if (ticks <= 0) {
                inv.setTickCounter(3);
                inv.consumeFuel(this.getFuelSpent(fuelConsumption));
                inv.dirtyTanks();
            } else {
                inv.setTickCounter(ticks);
            }
        }
        inv.func_70305_f();
    }

    private int getFuelSpent(float f) {
        this.fuelSpent = (f += this.fuelSpent) % 1.0f;
        return (int)(f - this.fuelSpent);
    }

    private static void elevate(EntityPlayer player, ItemStack copter) {
        if (player.field_70163_u < 100.0) {
            player.field_70181_x = Math.max(player.field_70181_x, 0.18);
        } else if (player.field_70163_u < 250.0) {
            player.field_70181_x = 0.18 - (player.field_70163_u - 100.0) / 1000.0;
        } else if (player.field_70163_u >= 250.0) {
            player.field_70181_x += 0.0;
        }
    }

    private void pushEntities(World world, EntityPlayer player, float speed) {
        double posX = player.field_70165_t;
        double posY = player.field_70163_u;
        double posZ = player.field_70161_v;
        List groundItems = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)posX, (double)posY, (double)posZ, (double)(posX + 1.0), (double)(posY + 1.0), (double)(posZ + 1.0)).func_72314_b(4.0, 4.0, 4.0));
        for (EntityItem groundItem : groundItems) {
            if (groundItem.func_70090_H()) continue;
            if (groundItem.field_70165_t > posX) {
                groundItem.field_70159_w = speed;
            }
            if (groundItem.field_70165_t < posX) {
                groundItem.field_70159_w = -speed;
            }
            if (groundItem.field_70161_v > posZ) {
                groundItem.field_70179_y = speed;
            }
            if (groundItem.field_70161_v < posZ) {
                groundItem.field_70179_y = -speed;
            }
            if (!(groundItem.field_70163_u < posY)) continue;
            groundItem.field_70181_x -= (double)speed;
        }
    }

    @Override
    public void onUnequipped(World world, EntityPlayer player, ItemStack stack) {
        BackpackUtils.getWearableCompound(stack).func_74774_a("status", OFF_MODE);
    }

    @Override
    public void onPlayerDeath(World world, EntityPlayer player, ItemStack stack) {
        this.onUnequipped(world, player, stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getWearableModel(ItemStack wearable) {
        return ClientProxy.modelCopterPack.setWearable(wearable);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getWearableTexture(ItemStack wearable) {
        return Resources.modelTextures("copterPack");
    }
}

