/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.malisis.core.network.MalisisMessage;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisMessage
public class DigicodeMessage
implements IMessageHandler<Packet, IMessage> {
    public DigicodeMessage() {
        MalisisDoors.network.registerMessage((IMessageHandler)this, Packet.class, Side.SERVER);
    }

    public IMessage onMessage(Packet message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, message.x, message.y, message.z);
        if (te == null) {
            return null;
        }
        te.openOrCloseDoor();
        if (te.getDescriptor().getAutoCloseTime() > 0 && !te.isOpened()) {
            world.func_147464_a(message.x, message.y, message.z, world.func_147439_a(message.x, message.y, message.z), te.getDescriptor().getAutoCloseTime() + te.getDescriptor().getOpeningTime());
        }
        return null;
    }

    public static void send(DoorTileEntity te) {
        MalisisDoors.network.sendToServer((IMessage)new Packet(te));
    }

    public static class Packet
    implements IMessage {
        private int x;
        private int y;
        private int z;

        public Packet(DoorTileEntity te) {
            this.x = te.field_145851_c;
            this.y = te.field_145848_d;
            this.z = te.field_145849_e;
        }

        public Packet() {
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.y);
            buf.writeInt(this.z);
        }
    }
}

