/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseRenderTarget;
import gcewing.architecture.Vector3;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BaseGLRenderTarget
extends BaseRenderTarget {
    public static boolean debugGL = false;
    protected boolean usingLightmap;
    protected int glMode;
    protected int emissiveMode;
    protected int texturedMode;

    public BaseGLRenderTarget() {
        super(0.0, 0.0, 0.0, null);
    }

    public void start(boolean usingLightmap) {
        this.usingLightmap = usingLightmap;
        if (debugGL) {
            System.out.printf("BaseGLRenderTarget: glPushAttrib()\n", new Object[0]);
        }
        GL11.glPushAttrib((int)266304);
        if (debugGL) {
            System.out.printf("BaseGLRenderTarget: glEnable(GL_RESCALE_NORMAL)\n", new Object[0]);
        }
        GL11.glEnable((int)32826);
        GL11.glShadeModel((int)7425);
        this.glMode = 0;
        this.emissiveMode = -1;
        this.texturedMode = -1;
        this.texture = null;
    }

    @Override
    public void setTexture(BaseModClient.ITexture tex) {
        if (this.texture != tex) {
            super.setTexture(tex);
            ResourceLocation loc = tex.location();
            if (loc != null) {
                this.setGLMode(0);
                if (debugGL) {
                    System.out.printf("BaseGLRenderTarget: bindTexture(%s)\n", loc);
                }
                BaseModClient.bindTexture(loc);
            }
            this.setTexturedMode(!tex.isSolid());
            this.setEmissiveMode(tex.isEmissive());
        }
    }

    protected void setEmissiveMode(boolean state) {
        int mode;
        int n = mode = state ? 1 : 0;
        if (this.emissiveMode != mode) {
            if (debugGL) {
                System.out.printf("BaseGLRenderTarget: glSetEnabled(GL_LIGHTING, %s)\n", !state);
            }
            this.glSetEnabled(2896, !state);
            if (this.usingLightmap) {
                this.setLightmapEnabled(!state);
            }
            this.emissiveMode = mode;
        }
    }

    protected void setTexturedMode(boolean state) {
        int mode;
        int n = mode = state ? 1 : 0;
        if (this.texturedMode != mode) {
            this.setGLMode(0);
            if (debugGL) {
                System.out.printf("BaseGLRenderTarget: glSetEnabled(GL_TEXTURE_2D, %s)\n", state);
            }
            this.glSetEnabled(3553, state);
            this.texturedMode = mode;
        }
    }

    protected void setLightmapEnabled(boolean state) {
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        this.glSetEnabled(3553, state);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    protected void glSetEnabled(int mode, boolean state) {
        if (state) {
            GL11.glEnable((int)mode);
        } else {
            GL11.glDisable((int)mode);
        }
    }

    @Override
    protected void rawAddVertex(Vector3 p, double u, double v) {
        if (debugGL) {
            System.out.printf("BaseGLRenderTarget: rawAddVertex: %s %s normal %s rgba (%.2f,%.2f.%.2f,%.2f) uv (%.4f,%.4f)\n", this.vertexCount, p, this.normal, Float.valueOf(this.r()), Float.valueOf(this.g()), Float.valueOf(this.b()), Float.valueOf(this.a()), u, v);
        }
        this.setGLMode(this.verticesPerFace);
        GL11.glColor4f((float)this.r(), (float)this.g(), (float)this.b(), (float)this.a());
        GL11.glNormal3d((double)this.normal.x, (double)this.normal.y, (double)this.normal.z);
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex3d((double)p.x, (double)p.y, (double)p.z);
    }

    protected void setGLMode(int mode) {
        if (this.glMode != mode) {
            if (this.glMode != 0) {
                if (debugGL) {
                    System.out.printf("BaseGLRenderTarget: glEnd()\n", new Object[0]);
                }
                GL11.glEnd();
            }
            this.glMode = mode;
            switch (this.glMode) {
                case 0: {
                    break;
                }
                case 3: {
                    if (debugGL) {
                        System.out.printf("BaseGLRenderTarget: glBegin(GL_TRIANGLES)\n", new Object[0]);
                    }
                    GL11.glBegin((int)4);
                    break;
                }
                case 4: {
                    if (debugGL) {
                        System.out.printf("BaseGLRenderTarget: glBegin(GL_QUADS)\n", new Object[0]);
                    }
                    GL11.glBegin((int)7);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid glMode %s", this.glMode));
                }
            }
        }
    }

    @Override
    public void finish() {
        this.setGLMode(0);
        this.setEmissiveMode(false);
        this.setTexturedMode(true);
        if (debugGL) {
            System.out.printf("BaseGLRenderTarget: glPopAttrib()\n", new Object[0]);
        }
        GL11.glPopAttrib();
        super.finish();
    }
}

