/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import com.google.gson.Gson;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;

public class BaseModel
implements BaseModClient.IModel {
    public double[] bounds;
    public Face[] faces;
    public double[][] boxes;
    static Gson gson = new Gson();

    public static BaseModel fromResource(ResourceLocation location) {
        String path = String.format("/assets/%s/%s", location.func_110624_b(), location.func_110623_a());
        InputStream in = BaseModel.class.getResourceAsStream(path);
        if (in == null) {
            throw new RuntimeException(String.format("Cannot find resource %s", path));
        }
        BaseModel model = (BaseModel)gson.fromJson((Reader)new InputStreamReader(in), BaseModel.class);
        model.prepare();
        return model;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return AxisAlignedBB.func_72330_a((double)this.bounds[0], (double)this.bounds[1], (double)this.bounds[2], (double)this.bounds[3], (double)this.bounds[4], (double)this.bounds[5]);
    }

    void prepare() {
        for (Face face : this.faces) {
            double[][] p = face.vertices;
            int[] t = face.triangles[0];
            face.normal = Vector3.unit(Vector3.sub(p[t[1]], p[t[0]]).cross(Vector3.sub(p[t[2]], p[t[0]])));
        }
    }

    @Override
    public void addBoxesToList(Trans3 t, List list) {
        if (this.boxes != null && this.boxes.length > 0) {
            for (int i = 0; i < this.boxes.length; ++i) {
                this.addBoxToList(this.boxes[i], t, list);
            }
        } else {
            this.addBoxToList(this.bounds, t, list);
        }
    }

    protected void addBoxToList(double[] b, Trans3 t, List list) {
        t.addBox(b[0], b[1], b[2], b[3], b[4], b[5], list);
    }

    @Override
    public void render(Trans3 t, BaseModClient.IRenderTarget renderer, BaseModClient.ITexture ... textures) {
        Vector3 p = null;
        Vector3 n = null;
        for (Face face : this.faces) {
            BaseModClient.ITexture tex;
            int k = face.texture;
            if (k >= textures.length) {
                k = textures.length - 1;
            }
            if ((tex = textures[k]) == null) continue;
            renderer.setTexture(tex);
            for (int[] tri : face.triangles) {
                renderer.beginTriangle();
                for (int i = 0; i < 3; ++i) {
                    int j = tri[i];
                    double[] c = face.vertices[j];
                    p = t.p(c[0], c[1], c[2]);
                    n = t.v(c[3], c[4], c[5]);
                    renderer.setNormal(n);
                    renderer.addVertex(p, c[6], c[7]);
                }
                renderer.endFace();
            }
        }
    }

    public static class Face {
        int texture;
        double[][] vertices;
        int[][] triangles;
        Vector3 normal;
    }
}

