/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BaseTileInventory
extends BaseTileEntity
implements IInventory,
ISidedInventory {
    int[] allSlots;

    protected IInventory getInventory() {
        return null;
    }

    @Override
    public void readContentsFromNBT(NBTTagCompound nbt) {
        super.readContentsFromNBT(nbt);
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            NBTTagList list = nbt.func_150295_c("inventory", 10);
            int n = list.func_74745_c();
            for (int i = 0; i < n; ++i) {
                NBTTagCompound item = list.func_150305_b(i);
                int slot = item.func_74762_e("slot");
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)item);
                inventory.func_70299_a(slot, stack);
            }
        }
    }

    @Override
    public void writeContentsToNBT(NBTTagCompound nbt) {
        super.writeContentsToNBT(nbt);
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            NBTTagList list = new NBTTagList();
            int n = inventory.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null) continue;
                NBTTagCompound item = new NBTTagCompound();
                item.func_74768_a("slot", i);
                stack.func_77955_b(item);
                list.func_74742_a((NBTBase)item);
            }
            nbt.func_74782_a("inventory", (NBTBase)list);
        }
    }

    void onInventoryChanged(int slot) {
        this.func_70296_d();
    }

    public int func_70302_i_() {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int slot) {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_70301_a(slot) : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            ItemStack result = inventory.func_70298_a(slot, amount);
            this.onInventoryChanged(slot);
            return result;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            ItemStack result = inventory.func_70304_b(slot);
            this.onInventoryChanged(slot);
            return result;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.func_70299_a(slot, stack);
            this.onInventoryChanged(slot);
        }
    }

    public String func_145825_b() {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_145825_b() : "";
    }

    public int func_70297_j_() {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_70297_j_() : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        IInventory inventory = this.getInventory();
        return inventory != null ? inventory.func_70300_a(player) : true;
    }

    public void func_70295_k_() {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.func_70295_k_();
        }
    }

    public void func_70305_f() {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.func_70305_f();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            return inventory.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_145818_k_() {
        IInventory inventory = this.getInventory();
        if (inventory != null) {
            return inventory.func_145818_k_();
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        IInventory inventory = this.getInventory();
        if (inventory instanceof ISidedInventory) {
            return ((ISidedInventory)inventory).func_94128_d(side);
        }
        if (this.allSlots == null) {
            int n = this.func_70302_i_();
            this.allSlots = new int[n];
            for (int i = 0; i < n; ++i) {
                this.allSlots[i] = i;
            }
        }
        return this.allSlots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        IInventory inventory = this.getInventory();
        if (inventory instanceof ISidedInventory) {
            return ((ISidedInventory)inventory).func_102007_a(slot, stack, side);
        }
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        IInventory inventory = this.getInventory();
        if (inventory instanceof ISidedInventory) {
            return ((ISidedInventory)inventory).func_102008_b(slot, stack, side);
        }
        return true;
    }
}

