/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.common;

import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.liquid.EnderLiquidStorage;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemEnderStorage
extends ItemBlock
implements IFluidContainerItem {
    public ItemEnderStorage(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int par1) {
        return par1 >> 12;
    }

    public String getOwner(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74779_i("owner") : "global";
    }

    public int getFreq(ItemStack stack) {
        return stack.func_77960_j() & 0xFFF;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileFrequencyOwner tile = (TileFrequencyOwner)world.func_147438_o(x, y, z);
            tile.setFreq(this.getFreq(stack));
            tile.setOwner(this.getOwner(stack));
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "|" + this.func_77647_b(stack.func_77960_j());
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        if (!this.getOwner(stack).equals("global")) {
            list.add(this.getOwner(stack));
        }
    }

    private EnderLiquidStorage getLiquidStorage(ItemStack stack) {
        return (EnderLiquidStorage)EnderStorageManager.instance(FMLCommonHandler.instance().getEffectiveSide().isClient()).getStorage(this.getOwner(stack), this.getFreq(stack), "liquid");
    }

    public FluidStack getFluid(ItemStack container) {
        if (this.func_77647_b(container.func_77960_j()) == 1) {
            return this.getLiquidStorage(container).getFluid();
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        if (this.func_77647_b(container.func_77960_j()) == 1) {
            return EnderLiquidStorage.CAPACITY;
        }
        return 0;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (this.func_77647_b(container.func_77960_j()) == 1) {
            return this.getLiquidStorage(container).fill(null, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (this.func_77647_b(container.func_77960_j()) == 1) {
            return this.getLiquidStorage(container).drain(null, maxDrain, doDrain);
        }
        return null;
    }
}

