/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.renderer;

import blockrenderer6343.api.utils.BlockPosition;
import blockrenderer6343.api.utils.Position;
import blockrenderer6343.api.utils.PositionedRect;
import blockrenderer6343.api.utils.Size;
import blockrenderer6343.client.renderer.GlStateManager;
import blockrenderer6343.client.utils.ProjectionUtils;
import blockrenderer6343.client.world.TrackedDummyWorld;
import codechicken.lib.vec.Vector3;
import com.github.bartimaeusnek.bartworks.common.blocks.BW_GlasBlocks;
import gregtech.common.render.GT_Renderer_Block;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector3f;

public abstract class WorldSceneRenderer {
    public final World world;
    public final List<BlockPosition> renderedBlocks;
    private Consumer<WorldSceneRenderer> beforeRender;
    private Consumer<WorldSceneRenderer> onRender;
    private Consumer<MovingObjectPosition> onLookingAt;
    private int clearColor;
    private MovingObjectPosition lastTraceResult;
    private Vector3f eyePos = new Vector3f(0.0f, 0.0f, -10.0f);
    private Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f worldUp = new Vector3f(0.0f, 1.0f, 0.0f);
    private boolean renderAllFaces = false;

    public WorldSceneRenderer(World world) {
        this.world = world;
        this.renderedBlocks = new ArrayList<BlockPosition>();
    }

    public WorldSceneRenderer setBeforeWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.beforeRender = callback;
        return this;
    }

    public WorldSceneRenderer setOnWorldRender(Consumer<WorldSceneRenderer> callback) {
        this.onRender = callback;
        return this;
    }

    public WorldSceneRenderer addRenderedBlocks(List<BlockPosition> blocks) {
        if (blocks != null) {
            this.renderedBlocks.addAll(blocks);
        }
        return this;
    }

    public WorldSceneRenderer setOnLookingAt(Consumer<MovingObjectPosition> onLookingAt) {
        this.onLookingAt = onLookingAt;
        return this;
    }

    public void setRenderAllFaces(boolean renderAllFaces) {
        this.renderAllFaces = renderAllFaces;
    }

    public void setClearColor(int clearColor) {
        this.clearColor = clearColor;
    }

    public MovingObjectPosition getLastTraceResult() {
        return this.lastTraceResult;
    }

    public void render(int x, int y, int width, int height, int mouseX, int mouseY) {
        Vector3f hitPos;
        MovingObjectPosition result;
        PositionedRect positionedRect = this.getPositionedRect(x, y, width, height);
        PositionedRect mouse = this.getPositionedRect(mouseX, mouseY, 0, 0);
        mouseX = mouse.position.x;
        mouseY = mouse.position.y;
        this.setupCamera(positionedRect);
        this.drawWorld();
        this.lastTraceResult = null;
        if (this.onLookingAt != null && mouseX > positionedRect.position.x && mouseX < positionedRect.position.x + positionedRect.size.width && mouseY > positionedRect.position.y && mouseY < positionedRect.position.y + positionedRect.size.height && (result = this.rayTrace(hitPos = ProjectionUtils.unProject(mouseX, mouseY))) != null) {
            this.lastTraceResult = result;
            this.onLookingAt.accept(result);
        }
        WorldSceneRenderer.resetCamera();
    }

    public Vector3f getEyePos() {
        return this.eyePos;
    }

    public Vector3f getLookAt() {
        return this.lookAt;
    }

    public Vector3f getWorldUp() {
        return this.worldUp;
    }

    public void setCameraLookAt(Vector3f eyePos, Vector3f lookAt, Vector3f worldUp) {
        this.eyePos = eyePos;
        this.lookAt = lookAt;
        this.worldUp = worldUp;
    }

    public void setCameraLookAt(Vector3f lookAt, double radius, double rotationPitch, double rotationYaw) {
        this.lookAt = lookAt;
        Vector3 vecX = new Vector3(Math.cos(rotationPitch), 0.0, Math.sin(rotationPitch));
        Vector3 vecY = new Vector3(0.0, Math.tan(rotationYaw) * vecX.mag(), 0.0);
        Vector3 pos = vecX.copy().add(vecY).normalize().multiply(radius);
        this.eyePos = pos.add((double)lookAt.x, (double)lookAt.y, (double)lookAt.z).vector3f();
    }

    protected PositionedRect getPositionedRect(int x, int y, int width, int height) {
        return new PositionedRect(new Position(x, y), new Size(width, height));
    }

    public void setupCamera(PositionedRect positionedRect) {
        int x = positionedRect.getPosition().x;
        int y = positionedRect.getPosition().y;
        int width = positionedRect.getSize().width;
        int height = positionedRect.getSize().height;
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.pushAttrib();
        mc.field_71460_t.func_78483_a(0.0);
        GlStateManager.disableLighting();
        GlStateManager.enableDepth();
        GlStateManager.enableBlend();
        GlStateManager.viewport(x, y, width, height);
        this.clearView(x, y, width, height);
        GlStateManager.matrixMode(5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        float aspectRatio = (float)width / ((float)height * 1.0f);
        GLU.gluPerspective((float)60.0f, (float)aspectRatio, (float)0.1f, (float)10000.0f);
        GlStateManager.matrixMode(5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GLU.gluLookAt((float)this.eyePos.x, (float)this.eyePos.y, (float)this.eyePos.z, (float)this.lookAt.x, (float)this.lookAt.y, (float)this.lookAt.z, (float)this.worldUp.x, (float)this.worldUp.y, (float)this.worldUp.z);
    }

    public static void setGlClearColorFromInt(int colorValue, int opacity) {
        int i = (colorValue & 0xFF0000) >> 16;
        int j = (colorValue & 0xFF00) >> 8;
        int k = colorValue & 0xFF;
        GL11.glClearColor((float)((float)i / 255.0f), (float)((float)j / 255.0f), (float)((float)k / 255.0f), (float)((float)opacity / 255.0f));
    }

    protected void clearView(int x, int y, int width, int height) {
        WorldSceneRenderer.setGlClearColorFromInt(this.clearColor, this.clearColor >> 24);
        GlStateManager.clear(16640);
    }

    public static void resetCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        GlStateManager.viewport(0, 0, minecraft.field_71443_c, minecraft.field_71440_d);
        GlStateManager.matrixMode(5889);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode(5888);
        GlStateManager.popMatrix();
        GlStateManager.disableBlend();
        GlStateManager.disableDepth();
        GlStateManager.popAttrib();
    }

    protected void drawWorld() {
        if (this.beforeRender != null) {
            this.beforeRender.accept(this);
        }
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.enableCull();
        GlStateManager.enableRescaleNormal();
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_78483_a(0.0);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.disableLighting();
        GlStateManager.enableTexture2D();
        GlStateManager.enableAlpha();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        for (BlockPosition pos : this.renderedBlocks) {
            Block block = this.world.func_147439_a(pos.x, pos.y, pos.z);
            if (block.equals(Blocks.field_150350_a)) continue;
            block.func_149715_a(15.0f);
            RenderBlocks bufferBuilder = new RenderBlocks();
            bufferBuilder.field_147845_a = this.world;
            bufferBuilder.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            bufferBuilder.field_147837_f = this.renderAllFaces;
            if (block instanceof BW_GlasBlocks) {
                bufferBuilder.func_147736_d(block, pos.x, pos.y, pos.z, (float)((BW_GlasBlocks)block).getColor(this.world.func_72805_g(pos.x, pos.y, pos.z))[0] / 255.0f, (float)((BW_GlasBlocks)block).getColor(this.world.func_72805_g(pos.x, pos.y, pos.z))[1] / 255.0f, (float)((BW_GlasBlocks)block).getColor(this.world.func_72805_g(pos.x, pos.y, pos.z))[2] / 255.0f);
                continue;
            }
            if (GT_Renderer_Block.INSTANCE.renderWorldBlock((IBlockAccess)this.world, pos.x, pos.y, pos.z, block, block.func_149645_b(), bufferBuilder)) continue;
            bufferBuilder.func_147805_b(block, pos.x, pos.y, pos.z);
        }
        if (this.onRender != null) {
            this.onRender.accept(this);
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
        RenderHelper.func_74519_b();
        GlStateManager.enableLighting();
        int pass = 0;
        while (pass < 2) {
            ForgeHooksClient.setRenderPass((int)pass);
            int finalPass = pass++;
            this.renderedBlocks.forEach(blockPosition -> {
                WorldSceneRenderer.setDefaultPassRenderState(finalPass);
                TileEntity tile = this.world.func_147438_o(blockPosition.x, blockPosition.y, blockPosition.z);
                if (tile != null && tile.shouldRenderInPass(finalPass)) {
                    TileEntityRendererDispatcher.field_147556_a.func_147544_a(tile, 0.0f);
                }
            });
        }
        ForgeHooksClient.setRenderPass((int)-1);
        GlStateManager.enableDepth();
        GlStateManager.disableBlend();
        GlStateManager.depthMask(true);
    }

    public static void setDefaultPassRenderState(int pass) {
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (pass == 0) {
            GlStateManager.enableDepth();
            GlStateManager.disableBlend();
            GlStateManager.depthMask(true);
        } else {
            GlStateManager.enableBlend();
            GlStateManager.blendFunc(770, 771);
            GlStateManager.depthMask(false);
        }
    }

    public MovingObjectPosition rayTrace(Vector3f hitPos) {
        Vec3 startPos = Vec3.func_72443_a((double)this.eyePos.x, (double)this.eyePos.y, (double)this.eyePos.z);
        hitPos.scale(2.0f);
        Vec3 endPos = Vec3.func_72443_a((double)((double)hitPos.x - startPos.field_72450_a), (double)((double)hitPos.y - startPos.field_72448_b), (double)((double)hitPos.z - startPos.field_72449_c));
        return ((TrackedDummyWorld)this.world).rayTraceBlockswithTargetMap(startPos, endPos, this.renderedBlocks);
    }

    protected MovingObjectPosition screenPos2BlockPosFace(int mouseX, int mouseY, int x, int y, int width, int height) {
        GlStateManager.enableDepth();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f hitPos = ProjectionUtils.unProject(mouseX, mouseY);
        MovingObjectPosition result = this.rayTrace(hitPos);
        WorldSceneRenderer.resetCamera();
        return result;
    }

    protected Vector3f blockPos2ScreenPos(BlockPosition pos, boolean depth, int x, int y, int width, int height) {
        GlStateManager.enableDepth();
        this.setupCamera(this.getPositionedRect(x, y, width, height));
        this.drawWorld();
        Vector3f winPos = ProjectionUtils.project(pos);
        WorldSceneRenderer.resetCamera();
        return winPos;
    }
}

