/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs.paths;

import gregtech.api.graphs.Lock;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;

public class NodePath {
    protected MetaPipeEntity[] mPipes;
    public Lock lock = new Lock();

    public NodePath(MetaPipeEntity[] aCables) {
        this.mPipes = aCables;
        this.processPipes();
    }

    protected void processPipes() {
        for (MetaPipeEntity tPipe : this.mPipes) {
            BaseMetaPipeEntity basePipe = (BaseMetaPipeEntity)tPipe.getBaseMetaTileEntity();
            basePipe.setNodePath(this);
        }
    }

    public void clearPath() {
        for (MetaPipeEntity mPipe : this.mPipes) {
            BaseMetaPipeEntity tBasePipe = (BaseMetaPipeEntity)mPipe.getBaseMetaTileEntity();
            if (tBasePipe == null) continue;
            tBasePipe.setNodePath(null);
        }
    }

    public void reloadLocks() {
        for (MetaPipeEntity pipe : this.mPipes) {
            BaseMetaPipeEntity basePipe = (BaseMetaPipeEntity)pipe.getBaseMetaTileEntity();
            if (basePipe == null) continue;
            basePipe.reloadLocks();
        }
    }
}

