/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.AECableType;
import appeng.core.localization.WailaText;
import appeng.me.helpers.AENetworkProxy;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.list.array.TIntArrayList;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.GT_GUIColorOverride;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.metatileentity.IMachineCallback;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_TooltipDataCache;
import gregtech.api.util.GT_Util;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import gregtech.common.covers.CoverInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MetaTileEntity
implements IMetaTileEntity,
IMachineCallback<MetaTileEntity> {
    public final String mName;
    public final ItemStack[] mInventory;
    public final ItemStackHandler inventoryHandler;
    protected GT_GUIColorOverride colorOverride;
    protected GT_TooltipDataCache mTooltipCache = new GT_TooltipDataCache();
    public boolean doTickProfilingInThisTick = true;
    private MetaTileEntity mCallBackTile;
    private IGregTechTileEntity mBaseMetaTileEntity;
    public long mSoundRequests = 0L;
    protected Supplier<Integer> COLOR_TITLE = () -> this.getTextColorOrDefault("title", 0x404040);
    protected Supplier<Integer> COLOR_TITLE_WHITE = () -> this.getTextColorOrDefault("title_white", 0xFAFAFF);
    protected Supplier<Integer> COLOR_TEXT_WHITE = () -> this.getTextColorOrDefault("text_white", 0xFAFAFF);
    protected Supplier<Integer> COLOR_TEXT_GRAY = () -> this.getTextColorOrDefault("text_gray", 0x404040);
    protected Supplier<Integer> COLOR_TEXT_RED = () -> this.getTextColorOrDefault("text_red", 0xFF0000);

    @Override
    public ItemStackHandler getInventoryHandler() {
        return this.inventoryHandler;
    }

    public MetaTileEntity(int aID, String aBasicName, String aRegionalName, int aInvSlotCount) {
        if (GregTech_API.sPostloadStarted || !GregTech_API.sPreloadStarted) {
            throw new IllegalAccessError("This Constructor has to be called in the load Phase");
        }
        if (GregTech_API.METATILEENTITIES[aID] != null) {
            throw new IllegalArgumentException("MetaMachine-Slot Nr. " + aID + " is already occupied!");
        }
        GregTech_API.METATILEENTITIES[aID] = this;
        this.mName = aBasicName.replace(" ", "_").toLowerCase(Locale.ENGLISH);
        this.setBaseMetaTileEntity(GregTech_API.constructBaseMetaTileEntity());
        this.getBaseMetaTileEntity().setMetaTileID((short)aID);
        GT_LanguageManager.addStringLocalization("gt.blockmachines." + this.mName + ".name", aRegionalName);
        this.mInventory = new ItemStack[aInvSlotCount];
        this.inventoryHandler = new ItemStackHandler(this.mInventory);
    }

    public MetaTileEntity(String aName, int aInvSlotCount) {
        this.mInventory = new ItemStack[aInvSlotCount];
        this.mName = aName;
        this.inventoryHandler = new ItemStackHandler(this.mInventory);
        this.colorOverride = GT_GUIColorOverride.get(this.getGUITextureSet().getMainBackground().location);
    }

    @Deprecated
    public boolean isDisplaySecondaryDescription() {
        return false;
    }

    @Override
    public IGregTechTileEntity getBaseMetaTileEntity() {
        return this.mBaseMetaTileEntity;
    }

    @Override
    public void setBaseMetaTileEntity(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mBaseMetaTileEntity != null && aBaseMetaTileEntity == null) {
            this.mBaseMetaTileEntity.getMetaTileEntity().inValidate();
            this.mBaseMetaTileEntity.setMetaTileEntity(null);
        }
        this.mBaseMetaTileEntity = aBaseMetaTileEntity;
        if (this.mBaseMetaTileEntity != null) {
            this.mBaseMetaTileEntity.setMetaTileEntity(this);
        }
    }

    public boolean isValid() {
        return this.getBaseMetaTileEntity() != null && this.getBaseMetaTileEntity().getMetaTileEntity() == this && !this.getBaseMetaTileEntity().isDead();
    }

    @Override
    public ItemStack getStackForm(long aAmount) {
        return new ItemStack(GregTech_API.sBlockMachines, (int)aAmount, this.getBaseMetaTileEntity().getMetaTileID());
    }

    @Override
    public String getLocalName() {
        return GT_LanguageManager.getTranslation("gt.blockmachines." + this.mName + ".name");
    }

    @Override
    public void onServerStart() {
    }

    @Override
    public void onWorldSave(File aSaveDirectory) {
    }

    @Override
    public void onWorldLoad(File aSaveDirectory) {
    }

    @Override
    public void onConfigLoad(GT_Config aConfig) {
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aStack) {
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    @Override
    public boolean onWrenchRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().isValidFacing(wrenchingSide)) {
            this.getBaseMetaTileEntity().setFrontFacing(wrenchingSide);
            return true;
        }
        return false;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        IGregTechTileEntity gtTE;
        if (!aPlayer.func_70093_af()) {
            return false;
        }
        ForgeDirection oppositeSide = wrenchingSide.getOpposite();
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(wrenchingSide);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof GT_MetaPipeEntity_Cable) {
            return gtTE.getMetaTileEntity().onWireCutterRightClick(wrenchingSide, oppositeSide, aPlayer, aX, aY, aZ);
        }
        return false;
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        IGregTechTileEntity gtTE;
        if (!aPlayer.func_70093_af()) {
            return false;
        }
        ForgeDirection oppositeSide = wrenchingSide.getOpposite();
        TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityAtSide(wrenchingSide);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).getMetaTileEntity() instanceof GT_MetaPipeEntity_Cable) {
            return gtTE.getMetaTileEntity().onSolderingToolRightClick(wrenchingSide, oppositeSide, aPlayer, aX, aY, aZ);
        }
        return false;
    }

    @Override
    public void onExplosion() {
        GT_Log.exp.println("Machine at " + this.getBaseMetaTileEntity().getXCoord() + " | " + this.getBaseMetaTileEntity().getYCoord() + " | " + this.getBaseMetaTileEntity().getZCoord() + " DIMID: " + this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g + " exploded.");
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isClientSide() && GT_Client.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public void inValidate() {
    }

    @Override
    public void onRemoval() {
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
    }

    public void onOpenGUI() {
    }

    public void onCloseGUI() {
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        return this.onRightclick(aBaseMetaTileEntity, aPlayer);
    }

    @Override
    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
    }

    @Override
    public void onValueUpdate(byte aValue) {
    }

    @Override
    public byte getUpdateData() {
        return 0;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
    }

    @Override
    public void stopSoundLoop(byte aValue, double aX, double aY, double aZ) {
    }

    @Override
    public MetaTileEntity getCallbackBase() {
        return this.mCallBackTile;
    }

    @Override
    public void setCallbackBase(MetaTileEntity callback) {
        this.mCallBackTile = callback;
    }

    @Override
    public Class<?> getType() {
        return null;
    }

    @Override
    public final void sendSound(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)4, aIndex);
        }
    }

    @Override
    public final void sendLoopStart(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)5, aIndex);
        }
        ++this.mSoundRequests;
    }

    @Override
    public final void sendLoopEnd(byte aIndex) {
        if (!this.getBaseMetaTileEntity().hasMufflerUpgrade()) {
            this.getBaseMetaTileEntity().sendBlockEvent((byte)6, aIndex);
        }
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isPneumatic() {
        return false;
    }

    public boolean isSteampowered() {
        return false;
    }

    public SteamVariant getSteamVariant() {
        return SteamVariant.NONE;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long maxEUInput() {
        return 0L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return false;
    }

    public boolean isTransformingLowEnergy() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return true;
    }

    @Override
    public boolean setStackToZeroInsteadOfNull(int aIndex) {
        return false;
    }

    public long getEUVar() {
        return ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredEnergy;
    }

    public void setEUVar(long aEnergy) {
        if (aEnergy != ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredEnergy) {
            this.func_70296_d();
            ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredEnergy = aEnergy;
        }
    }

    public long getSteamVar() {
        return ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredSteam;
    }

    public void setSteamVar(long aSteam) {
        if (((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredSteam != aSteam) {
            this.func_70296_d();
            ((BaseMetaTileEntity)this.mBaseMetaTileEntity).mStoredSteam = aSteam;
        }
    }

    public long maxSteamStore() {
        return 0L;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public long getInputTier() {
        return GT_Utility.getTier(this.getBaseMetaTileEntity().getInputVoltage());
    }

    public long getOutputTier() {
        return GT_Utility.getTier(this.getBaseMetaTileEntity().getOutputVoltage());
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        return 0;
    }

    public int dechargerSlotStartIndex() {
        return 0;
    }

    public int dechargerSlotCount() {
        return 0;
    }

    public boolean ownerControl() {
        return false;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        return aList;
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return true;
    }

    public FluidStack getFluid() {
        return null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public int getTankPressure() {
        return 0;
    }

    public int getCapacity() {
        return 0;
    }

    public int getRealCapacity() {
        return this.getCapacity();
    }

    @Override
    public void onMachineBlockUpdate() {
    }

    @Override
    public void receiveClientEvent(byte aEventID, byte aValue) {
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isTransformerUpgradable() {
        return false;
    }

    public int getProgresstime() {
        return 0;
    }

    public int maxProgresstime() {
        return 0;
    }

    public int increaseProgress(int aProgress) {
        return 0;
    }

    public boolean hasSidedRedstoneOutputBehavior() {
        return false;
    }

    public void onFacingChange() {
    }

    public boolean isTeleporterCompatible() {
        return this.isEnetOutput() && this.getBaseMetaTileEntity().getOutputVoltage() >= 128L && this.getBaseMetaTileEntity().getUniversalEnergyCapacity() >= 500000L;
    }

    public boolean willExplodeInRain() {
        return true;
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return 0;
    }

    @Override
    public boolean acceptsRotationalEnergy(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean injectRotationalEnergy(ForgeDirection side, long aSpeed, long aEnergy) {
        return false;
    }

    @Override
    public String getSpecialVoltageToolTip() {
        return null;
    }

    @Override
    public boolean isGivingInformation() {
        return false;
    }

    @Override
    public String[] getInfoData() {
        return new String[0];
    }

    public boolean isDigitalChest() {
        return false;
    }

    public ItemStack[] getStoredItemData() {
        return null;
    }

    public void setItemCount(int aCount) {
    }

    public int getMaxItemCount() {
        return 0;
    }

    public int func_70302_i_() {
        return this.mInventory.length;
    }

    public ItemStack func_70301_a(int aIndex) {
        if (aIndex >= 0 && aIndex < this.mInventory.length) {
            return this.mInventory[aIndex];
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        IConfigurationCircuitSupport ccs;
        this.func_70296_d();
        MetaTileEntity metaTileEntity = this;
        if (metaTileEntity instanceof IConfigurationCircuitSupport && (ccs = (IConfigurationCircuitSupport)((Object)metaTileEntity)).allowSelectCircuit() && aIndex == ccs.getCircuitSlot() && aStack != null) {
            this.mInventory[aIndex] = GT_Utility.copyAmount(0L, aStack);
            return;
        }
        if (aIndex >= 0 && aIndex < this.mInventory.length) {
            this.mInventory[aIndex] = aStack;
        }
    }

    public String func_145825_b() {
        if (GregTech_API.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()] != null) {
            return GregTech_API.METATILEENTITIES[this.getBaseMetaTileEntity().getMetaTileID()].getMetaName();
        }
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.getBaseMetaTileEntity().isValidSlot(aIndex);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        ItemStack tStack = this.func_70301_a(aIndex);
        ItemStack rStack = GT_Utility.copyOrNull(tStack);
        if (tStack != null) {
            if (tStack.field_77994_a <= aAmount) {
                if (this.setStackToZeroInsteadOfNull(aIndex)) {
                    tStack.field_77994_a = 0;
                    this.func_70296_d();
                } else {
                    this.func_70299_a(aIndex, null);
                }
            } else {
                rStack = tStack.func_77979_a(aAmount);
                this.func_70296_d();
                if (tStack.field_77994_a == 0 && !this.setStackToZeroInsteadOfNull(aIndex)) {
                    this.func_70299_a(aIndex, null);
                }
            }
        }
        return rStack;
    }

    public int[] func_94128_d(int ordinalSide) {
        TIntArrayList tList = new TIntArrayList();
        IGregTechTileEntity tTileEntity = this.getBaseMetaTileEntity();
        CoverInfo tileCoverInfo = tTileEntity.getCoverInfoAtSide(ForgeDirection.getOrientation((int)ordinalSide));
        boolean tSkip = tileCoverInfo.letsItemsIn(-2) || tileCoverInfo.letsItemsOut(-2);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.isValidSlot(i) || !tSkip && !tileCoverInfo.letsItemsOut(i) && !tileCoverInfo.letsItemsIn(i)) continue;
            tList.add(i);
        }
        return tList.toArray();
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual(aStack, this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, ForgeDirection.getOrientation((int)ordinalSide), aStack);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && this.allowPullStack(this.getBaseMetaTileEntity(), aIndex, ForgeDirection.getOrientation((int)ordinalSide), aStack);
    }

    public boolean canFill(ForgeDirection side, Fluid aFluid) {
        return this.fill(side, new FluidStack(aFluid, 1), false) == 1;
    }

    public boolean canDrain(ForgeDirection side, Fluid aFluid) {
        return this.drain(side, new FluidStack(aFluid, 1), false) != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        if (this.getCapacity() <= 0 && !this.getBaseMetaTileEntity().hasSteamEngineUpgrade()) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.getInfo()};
    }

    public int fill_default(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        this.func_70296_d();
        return this.fill(aFluid, doFill);
    }

    public int fill(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        if (this.getBaseMetaTileEntity().hasSteamEngineUpgrade() && GT_ModHandler.isSteam(aFluid) && aFluid.amount > 1) {
            int tSteam = (int)Math.min(Integer.MAX_VALUE, Math.min((long)(aFluid.amount / 2), this.getBaseMetaTileEntity().getSteamCapacity() - this.getBaseMetaTileEntity().getStoredSteam()));
            if (tSteam > 0) {
                this.func_70296_d();
                if (doFill) {
                    this.getBaseMetaTileEntity().increaseStoredSteam(tSteam, true);
                }
                return tSteam * 2;
            }
        } else {
            return this.fill_default(side, aFluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection side, FluidStack aFluid, boolean doDrain) {
        if (this.getFluid() != null && aFluid != null && this.getFluid().isFluidEqual(aFluid)) {
            return this.drain(aFluid.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection side, int maxDrain, boolean doDrain) {
        return this.drain(maxDrain, doDrain);
    }

    public int getFluidAmount() {
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    @Override
    public String getMetaName() {
        return this.mName;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean doTickProfilingMessageDuringThisTick() {
        return this.doTickProfilingInThisTick;
    }

    public void func_70296_d() {
        if (this.mBaseMetaTileEntity != null) {
            this.mBaseMetaTileEntity.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    @Deprecated
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    @Override
    @Deprecated
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    @Override
    public boolean connectsToItemPipe(ForgeDirection side) {
        return false;
    }

    @Override
    public float getExplosionResistance(ForgeDirection side) {
        return 10.0f;
    }

    @Override
    public ItemStack[] getRealInventory() {
        return this.mInventory;
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        IGregTechTileEntity meta = this.getBaseMetaTileEntity();
        int aX = meta.getXCoord();
        short aY = meta.getYCoord();
        int aZ = meta.getZCoord();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tTileEntity = meta.getTileEntityAtSide(side);
            if (!(tTileEntity instanceof BaseMetaPipeEntity)) continue;
            BaseMetaPipeEntity pipe = (BaseMetaPipeEntity)tTileEntity;
            pipe.onNeighborBlockChange(aX, aY, aZ);
        }
    }

    @Override
    public void onColorChangeClient(byte aColor) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInInventory(Block aBlock, int aMeta, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderInWorld(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        return false;
    }

    @Override
    public void doExplosion(long aExplosionPower) {
        float tStrength = GT_Values.getExplosionPowerForVoltage(aExplosionPower);
        int tX = this.getBaseMetaTileEntity().getXCoord();
        short tY = this.getBaseMetaTileEntity().getYCoord();
        int tZ = this.getBaseMetaTileEntity().getZCoord();
        World tWorld = this.getBaseMetaTileEntity().getWorld();
        GT_Utility.sendSoundToPlayers(tWorld, SoundResource.IC2_MACHINES_MACHINE_OVERLOAD, 1.0f, -1.0f, tX, (int)tY, tZ);
        tWorld.func_147449_b(tX, (int)tY, tZ, Blocks.field_150350_a);
        if (GregTech_API.sMachineExplosions) {
            tWorld.func_72876_a(null, (double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5, tStrength, true);
        }
    }

    @Override
    public int getLightOpacity() {
        return ((BaseMetaTileEntity)this.getBaseMetaTileEntity()).getLightValue() > 0 ? 0 : 255;
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        AxisAlignedBB axisalignedbb1 = this.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        if (axisalignedbb1 != null && inputAABB.func_72326_a(axisalignedbb1)) {
            outputAABB.add(axisalignedbb1);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
    }

    @Override
    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return false;
    }

    @Deprecated
    public String trans(String aKey, String aEnglish) {
        return GT_Utility.trans(aKey, aEnglish);
    }

    @Override
    public boolean hasAlternativeModeText() {
        return false;
    }

    @Override
    public String getAlternativeModeText() {
        return "";
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return false;
    }

    public boolean shouldTriggerBlockUpdate() {
        return false;
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return AECableType.NONE;
    }

    public AENetworkProxy getProxy() {
        return null;
    }

    public void gridChanged() {
    }

    @Override
    public ItemStack getMachineCraftingIcon() {
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        if (mte == null) {
            return null;
        }
        return mte.getDrops().stream().findAny().orElse(null);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        currenttip.add(String.format("Facing: %s", this.mBaseMetaTileEntity.getFrontFacing().name()));
        MetaTileEntity metaTileEntity = this;
        if (metaTileEntity instanceof IPowerChannelState) {
            IPowerChannelState state = (IPowerChannelState)metaTileEntity;
            NBTTagCompound tag = accessor.getNBTData();
            boolean isActive = tag.func_74767_n("isActive");
            boolean isPowered = tag.func_74767_n("isPowered");
            boolean isBooting = tag.func_74767_n("isBooting");
            if (isBooting) {
                currenttip.add(WailaText.Booting.getLocal());
            } else if (isActive && isPowered) {
                currenttip.add(WailaText.DeviceOnline.getLocal());
            } else if (isPowered) {
                currenttip.add(WailaText.DeviceMissingChannel.getLocal());
            } else {
                currenttip.add(WailaText.DeviceOffline.getLocal());
            }
        }
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        MetaTileEntity metaTileEntity = this;
        if (metaTileEntity instanceof IPowerChannelState) {
            IPowerChannelState state = (IPowerChannelState)metaTileEntity;
            boolean isActive = state.isActive();
            boolean isPowered = state.isPowered();
            boolean isBooting = state.isBooting();
            tag.func_74757_a("isActive", isActive);
            tag.func_74757_a("isPowered", isPowered);
            tag.func_74757_a("isBooting", isBooting);
        }
    }

    protected String getAEDiagnostics() {
        try {
            if (this.getProxy() == null) {
                return "(proxy)";
            }
            if (this.getProxy().getNode() == null) {
                return "(node)";
            }
            if (this.getProxy().getNode().getGrid() == null) {
                return "(grid)";
            }
            if (!this.getProxy().getNode().meetsChannelRequirements()) {
                return "(channels)";
            }
            IPathingGrid pg = (IPathingGrid)this.getProxy().getNode().getGrid().getCache(IPathingGrid.class);
            if (!pg.isNetworkBooting()) {
                return "(booting)";
            }
            IEnergyGrid eg = (IEnergyGrid)this.getProxy().getNode().getGrid().getCache(IEnergyGrid.class);
            if (!eg.isNetworkPowered()) {
                return "(power)";
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return "";
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.DEFAULT;
    }

    @Override
    public int getGUIColorization() {
        Dyes dye = Dyes.dyeWhite;
        if (this.colorOverride.sLoaded()) {
            if (this.colorOverride.sGuiTintingEnabled() && this.getBaseMetaTileEntity() != null) {
                dye = Dyes.getDyeFromIndex(this.getBaseMetaTileEntity().getColorization());
                return this.colorOverride.getGuiTintOrDefault(dye.mName, GT_Util.getRGBInt(dye.getRGBA()));
            }
        } else if (GregTech_API.sColoredGUI) {
            if (GregTech_API.sMachineMetalGUI) {
                dye = Dyes.MACHINE_METAL;
            } else if (this.getBaseMetaTileEntity() != null) {
                dye = Dyes.getDyeFromIndex(this.getBaseMetaTileEntity().getColorization());
            }
        }
        return GT_Util.getRGBInt(dye.getRGBA());
    }

    @Override
    public int getTextColorOrDefault(String textType, int defaultColor) {
        return this.colorOverride.getTextColorOrDefault(textType, defaultColor);
    }
}

