/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_Single_Recipe_Check {
    protected final GT_MetaTileEntity_MultiBlockBase multiBlockBase;
    protected final GT_Recipe recipe;
    protected final ImmutableMap<GT_Utility.ItemId, Integer> itemCost;
    protected final ImmutableMap<Fluid, Integer> fluidCost;
    protected final int totalItemCost;
    protected final int totalFluidCost;

    protected GT_Single_Recipe_Check(GT_MetaTileEntity_MultiBlockBase multiBlockBase, GT_Recipe recipe, ImmutableMap<GT_Utility.ItemId, Integer> itemCost, ImmutableMap<Fluid, Integer> fluidCost) {
        this.multiBlockBase = multiBlockBase;
        this.recipe = recipe;
        this.itemCost = itemCost;
        this.fluidCost = fluidCost;
        this.totalItemCost = itemCost.values().stream().mapToInt(Integer::intValue).sum();
        this.totalFluidCost = fluidCost.values().stream().mapToInt(Integer::intValue).sum();
    }

    public GT_Recipe getRecipe() {
        return this.recipe;
    }

    public boolean checkRecipeInputsSingleStack(boolean consumeInputs) {
        HashMap<GT_Utility.ItemId, ItemStack> itemMap = null;
        if (this.totalItemCost > 0) {
            itemMap = new HashMap<GT_Utility.ItemId, ItemStack>();
            for (ItemStack itemStack : this.multiBlockBase.getStoredInputs()) {
                itemMap.merge(GT_Utility.ItemId.createNoCopy(itemStack), itemStack, (a, b) -> a.field_77994_a >= b.field_77994_a ? a : b);
            }
            for (Map.Entry entry : this.itemCost.entrySet()) {
                ItemStack itemStack = (ItemStack)itemMap.get(entry.getKey());
                if (itemStack != null && itemStack.field_77994_a >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        HashMap<Fluid, FluidStack> fluidMap = null;
        if (this.totalFluidCost > 0) {
            fluidMap = new HashMap<Fluid, FluidStack>();
            for (FluidStack fluidStack : this.multiBlockBase.getStoredFluids()) {
                fluidMap.merge(fluidStack.getFluid(), fluidStack, (a, b) -> a.amount >= b.amount ? a : b);
            }
            for (Map.Entry entry : this.fluidCost.entrySet()) {
                FluidStack fluidStack = (FluidStack)fluidMap.get(entry.getKey());
                if (fluidStack != null && fluidStack.amount >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        if (consumeInputs) {
            if (this.totalItemCost > 0) {
                for (Map.Entry entry : this.itemCost.entrySet()) {
                    ((ItemStack)itemMap.get(entry.getKey())).field_77994_a -= ((Integer)entry.getValue()).intValue();
                }
            }
            if (this.totalFluidCost > 0) {
                for (Map.Entry entry : this.fluidCost.entrySet()) {
                    ((FluidStack)fluidMap.get(entry.getKey())).amount -= ((Integer)entry.getValue()).intValue();
                }
            }
        }
        return true;
    }

    public boolean checkRecipeInputs(boolean consumeInputs) {
        ArrayList<ItemStack> items = null;
        if (this.totalItemCost > 0) {
            items = this.multiBlockBase.getStoredInputs();
            HashMap<GT_Utility.ItemId, Integer> itemMap = new HashMap<GT_Utility.ItemId, Integer>();
            for (ItemStack itemStack : items) {
                itemMap.merge(GT_Utility.ItemId.createNoCopy(itemStack), itemStack.field_77994_a, Integer::sum);
            }
            for (Object entry : this.itemCost.entrySet()) {
                if (itemMap.getOrDefault(entry.getKey(), 0) >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        ArrayList<FluidStack> fluids = null;
        if (this.totalFluidCost > 0) {
            fluids = this.multiBlockBase.getStoredFluids();
            HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
            for (FluidStack fluidStack : fluids) {
                fluidMap.merge(fluidStack.getFluid(), fluidStack.amount, Integer::sum);
            }
            for (Map.Entry entry : this.fluidCost.entrySet()) {
                if (fluidMap.getOrDefault(entry.getKey(), 0) >= (Integer)entry.getValue()) continue;
                return false;
            }
        }
        if (consumeInputs) {
            int paid;
            int runningCost;
            GT_Utility.ItemId key;
            if (this.totalItemCost > 0) {
                int remainingItemCost = this.totalItemCost;
                HashMap runningItemCost = Maps.newHashMap(this.itemCost);
                for (ItemStack itemStack : items) {
                    key = GT_Utility.ItemId.createNoCopy(itemStack);
                    runningCost = runningItemCost.getOrDefault(key, 0);
                    paid = Math.min(itemStack.field_77994_a, runningCost);
                    itemStack.field_77994_a -= paid;
                    runningItemCost.put(key, runningCost - paid);
                    if ((remainingItemCost -= paid) > 0) continue;
                    break;
                }
            }
            if (this.totalFluidCost > 0) {
                int remainingFluidCost = this.totalFluidCost;
                HashMap runningFluidCost = Maps.newHashMap(this.fluidCost);
                for (FluidStack fluidStack : fluids) {
                    key = fluidStack.getFluid();
                    runningCost = runningFluidCost.getOrDefault(key, 0);
                    paid = Math.min(fluidStack.amount, runningCost);
                    fluidStack.amount -= paid;
                    runningFluidCost.put(key, runningCost - paid);
                    if ((remainingFluidCost -= paid) > 0) continue;
                    break;
                }
            }
        }
        return true;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("inputs", (NBTBase)GT_Single_Recipe_Check.writeList(this.recipe.mInputs, GT_Utility::saveItem));
        tag.func_74782_a("outputs", (NBTBase)GT_Single_Recipe_Check.writeList(this.recipe.mOutputs, GT_Utility::saveItem));
        tag.func_74783_a("chances", this.recipe.mChances);
        tag.func_74782_a("fInputs", (NBTBase)GT_Single_Recipe_Check.writeList(this.recipe.mFluidInputs, (T s) -> s == null ? new NBTTagCompound() : s.writeToNBT(new NBTTagCompound())));
        tag.func_74782_a("fOutputs", (NBTBase)GT_Single_Recipe_Check.writeList(this.recipe.mFluidOutputs, (T s) -> s == null ? new NBTTagCompound() : s.writeToNBT(new NBTTagCompound())));
        tag.func_74768_a("eut", this.recipe.mEUt);
        tag.func_74768_a("duration", this.recipe.mDuration);
        tag.func_74768_a("specialValue", this.recipe.mSpecialValue);
        tag.func_74782_a("itemCost", (NBTBase)GT_Single_Recipe_Check.writeList(this.itemCost.entrySet(), (T e) -> {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74782_a("id", (NBTBase)((GT_Utility.ItemId)e.getKey()).writeToNBT());
            ret.func_74768_a("count", ((Integer)e.getValue()).intValue());
            return ret;
        }));
        tag.func_74782_a("fluidCost", (NBTBase)GT_Single_Recipe_Check.writeList(this.fluidCost.entrySet(), (T e) -> {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74778_a("id", ((Fluid)e.getKey()).getName());
            ret.func_74768_a("count", ((Integer)e.getValue()).intValue());
            return ret;
        }));
        return tag;
    }

    private static <T, NBT extends NBTBase> NBTTagList writeList(T[] arr, Function<T, NBT> ser) {
        return GT_Single_Recipe_Check.writeList(Arrays.asList(arr), ser);
    }

    private static <T, NBT extends NBTBase> NBTTagList writeList(Collection<T> arr, Function<T, NBT> ser) {
        NBTTagList l = new NBTTagList();
        for (T t : arr) {
            l.func_74742_a((NBTBase)ser.apply(t));
        }
        return l;
    }

    @Nullable
    public static GT_Single_Recipe_Check tryLoad(GT_MetaTileEntity_MultiBlockBase parent, NBTTagCompound tag) {
        return GT_Single_Recipe_Check.tryLoad(parent, parent.getRecipeMap(), tag);
    }

    @Nullable
    public static GT_Single_Recipe_Check tryLoad(GT_MetaTileEntity_MultiBlockBase parent, GT_Recipe.GT_Recipe_Map recipeMap, NBTTagCompound tag) {
        GT_Recipe found = GT_Single_Recipe_Check.tryFindRecipe(parent, recipeMap, tag);
        if (found == null) {
            return null;
        }
        return new GT_Single_Recipe_Check(parent, found, GT_Single_Recipe_Check.loadItemCost(tag), GT_Single_Recipe_Check.loadFluidCost(tag));
    }

    protected static ImmutableMap<Fluid, Integer> loadFluidCost(NBTTagCompound tag) {
        return GT_Utility.streamCompounds(tag.func_150295_c("fluidCost", 10)).collect(GT_Utility.toImmutableMapSerial(t -> FluidRegistry.getFluid((String)t.func_74779_i("id")), t -> t.func_74762_e("count")));
    }

    protected static ImmutableMap<GT_Utility.ItemId, Integer> loadItemCost(NBTTagCompound tag) {
        return GT_Utility.streamCompounds(tag.func_150295_c("itemCost", 10)).collect(GT_Utility.toImmutableMapSerial(t -> GT_Utility.ItemId.create(t.func_74775_l("id")), t -> t.func_74762_e("count")));
    }

    protected static GT_Recipe tryFindRecipe(GT_MetaTileEntity_MultiBlockBase parent, GT_Recipe.GT_Recipe_Map recipeMap, NBTTagCompound tag) {
        if (tag == null || tag.func_82582_d()) {
            return null;
        }
        ItemStack[] inputs = (ItemStack[])GT_Utility.streamCompounds(tag.func_150295_c("inputs", 10)).map(GT_Utility::loadItem).toArray(ItemStack[]::new);
        ItemStack[] outputs = (ItemStack[])GT_Utility.streamCompounds(tag.func_150295_c("outputs", 10)).map(GT_Utility::loadItem).toArray(ItemStack[]::new);
        Object[] fInputs = (FluidStack[])GT_Utility.streamCompounds(tag.func_150295_c("fInputs", 10)).map(FluidStack::loadFluidStackFromNBT).toArray(FluidStack[]::new);
        Object[] fOutputs = (FluidStack[])GT_Utility.streamCompounds(tag.func_150295_c("fOutputs", 10)).map(FluidStack::loadFluidStackFromNBT).toArray(FluidStack[]::new);
        int eut = tag.func_74762_e("eut");
        GT_Recipe found = recipeMap.findRecipe((IHasWorldObjectAndCoords)parent.getBaseMetaTileEntity(), false, GT_Values.V[GT_Utility.getTier(eut)], (FluidStack[])fInputs, inputs);
        int[] chances = tag.func_74759_k("chances");
        if (!(found != null && GT_Utility.equals(inputs, found.mInputs) && Arrays.equals(fInputs, found.mFluidInputs) && GT_Utility.equals(outputs, found.mOutputs) && Arrays.equals(fOutputs, found.mFluidOutputs) && Arrays.equals(chances, found.mChances) && found.mDuration == tag.func_74762_e("duration") && found.mEUt == eut && found.mSpecialValue == tag.func_74762_e("specialValue"))) {
            return null;
        }
        return found;
    }

    protected static Map<GT_Utility.ItemId, Integer> buildItemMap(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        HashMap<GT_Utility.ItemId, Integer> itemMap = new HashMap<GT_Utility.ItemId, Integer>();
        for (ItemStack itemStack : multiBlockBase.getStoredInputs()) {
            itemMap.merge(GT_Utility.ItemId.create(itemStack), itemStack.field_77994_a, Integer::sum);
        }
        return itemMap;
    }

    protected static Map<Fluid, Integer> buildFluidMap(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
        for (FluidStack fluidStack : multiBlockBase.getStoredFluids()) {
            fluidMap.merge(fluidStack.getFluid(), fluidStack.amount, Integer::sum);
        }
        return fluidMap;
    }

    public static Builder builder(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
        return new Builder(multiBlockBase);
    }

    public static final class Builder {
        private final GT_MetaTileEntity_MultiBlockBase multiBlockBase;
        private Map<GT_Utility.ItemId, Integer> beforeItems;
        private Map<Fluid, Integer> beforeFluids;
        private Map<GT_Utility.ItemId, Integer> afterItems;
        private Map<Fluid, Integer> afterFluids;
        private GT_Recipe recipe;

        private Builder(GT_MetaTileEntity_MultiBlockBase multiBlockBase) {
            this.multiBlockBase = multiBlockBase;
        }

        public Builder setBefore(ItemStack[] inputs, FluidStack[] fluids) {
            this.beforeItems = Builder.buildItemMapDirect(inputs);
            this.beforeFluids = Builder.buildFluidMapDirect(fluids);
            return this;
        }

        public Builder setAfter(ItemStack[] inputs, FluidStack[] fluids) {
            this.afterItems = Builder.buildItemMapDirect(inputs);
            this.afterFluids = Builder.buildFluidMapDirect(fluids);
            return this;
        }

        public Builder setRecipe(GT_Recipe recipe) {
            this.recipe = recipe;
            return this;
        }

        static Map<GT_Utility.ItemId, Integer> buildItemMapDirect(ItemStack[] inputs) {
            HashMap<GT_Utility.ItemId, Integer> itemMap = new HashMap<GT_Utility.ItemId, Integer>();
            for (ItemStack itemStack : inputs) {
                itemMap.merge(GT_Utility.ItemId.create(itemStack), itemStack.field_77994_a, Integer::sum);
            }
            return itemMap;
        }

        static Map<Fluid, Integer> buildFluidMapDirect(FluidStack[] fluids) {
            HashMap<Fluid, Integer> fluidMap = new HashMap<Fluid, Integer>();
            for (FluidStack fluidStack : fluids) {
                fluidMap.merge(fluidStack.getFluid(), fluidStack.amount, Integer::sum);
            }
            return fluidMap;
        }

        public GT_Single_Recipe_Check build() {
            ImmutableMap.Builder itemCostBuilder = ImmutableMap.builder();
            for (Map.Entry<GT_Utility.ItemId, Integer> entry : this.beforeItems.entrySet()) {
                int cost = entry.getValue() - this.afterItems.getOrDefault(entry.getKey(), 0);
                if (cost <= 0) continue;
                itemCostBuilder.put((Object)entry.getKey(), (Object)cost);
            }
            ImmutableMap.Builder fluidCostBuilder = ImmutableMap.builder();
            for (Map.Entry<Fluid, Integer> entry : this.beforeFluids.entrySet()) {
                int cost = entry.getValue() - this.afterFluids.getOrDefault(entry.getKey(), 0);
                if (cost <= 0) continue;
                fluidCostBuilder.put((Object)entry.getKey(), (Object)cost);
            }
            return new GT_Single_Recipe_Check(this.multiBlockBase, this.recipe, (ImmutableMap<GT_Utility.ItemId, Integer>)itemCostBuilder.build(), (ImmutableMap<Fluid, Integer>)fluidCostBuilder.build());
        }
    }
}

